/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.TNodeSort;
import com.cognos.xqe.ast.olap.TNodeSortItem;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertV5ValueSetSortToTNodeSort
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5ValueSetSortToTNodeSort() {
        this.mName = "Convert Sorted V5ValueSet To TNodeSort.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String sValueSet = node.getPropertyValue("name").toString();
        int idx = sValueSet.indexOf("_rm_");
        if (idx != -1) {
            IXQEQueryNode[] v5SortItemNodes;
            for (IXQEQueryNode sortItem : v5SortItemNodes = node.getChildrenOfTypeOrdered(101056)) {
                node.detachChild(sortItem);
            }
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode sortTarget = node.getChild(0);
        while (sortTarget != null && sortTarget.getType() == 1039 && sortTarget.getNumberChildren() == 1 && !(sortTarget = sortTarget.getChild(0)).isOfCategory(1022)) {
        }
        if (sortTarget.isOfCategory(1022)) {
            IXQEQueryNode[] sortItemNodes = node.getChildrenOfType(101056);
            for (int i = 0; i < sortItemNodes.length; ++i) {
                sortItemNodes[i].detach();
            }
            return;
        }
        TNodeSort tNodeSort = (TNodeSort)nodeFactory.createNode(1117);
        for (int iNode = 0; iNode < node.getNumberChildren(); ++iNode) {
            if (!node.getChild(iNode).isOfCategory(1021)) continue;
            node.getChild(iNode).insertParent(tNodeSort);
            break;
        }
        tNodeSort.setRefDataItemProperty((String)node.getPropertyValue("refDataItem"));
        tNodeSort.setPropertyValue("name", node.getPropertyValue("name"));
        IXQEQueryNode[] v5SortItemNodes = node.getChildrenOfTypeOrdered(101056);
        for (int i = 0; i < v5SortItemNodes.length; ++i) {
            V5SortItem v5SortItem = (V5SortItem)v5SortItemNodes[i];
            TNodeSortItem tNodeSortItem = (TNodeSortItem)nodeFactory.createNode(1118);
            if (v5SortItem.getNumberChildren() > 0) {
                v5SortItem.getChild(0).move(tNodeSortItem);
            }
            tNodeSortItem.setSortOrder(v5SortItem.getPropertyValue("sortOrder").toString());
            tNodeSortItem.setRefDataItem(v5SortItem.getPropertyValue("refDataItem").toString());
            tNodeSortItem.setMetadata((IMetadata)v5SortItem.getPropertyValue("metadata"));
            tNodeSort.addChild(tNodeSortItem);
            tNodeSort.setPropertyValue("edgeID", v5SortItem.getPropertyValue("edgeID"));
            String nullsPlacement = (String)v5SortItem.getPropertyValue("nullPlace");
            if (nullsPlacement != null) {
                tNodeSortItem.setPropertyValue("nullsPlacement", nullsPlacement);
            }
            node.detachChild(v5SortItem);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] v5SortItemNodes = node.getChildrenOfType(101056);
        if (v5SortItemNodes.length == 0) {
            this.traceNodeCondition(false, "The V5ValueSet node does not have any V5SortItem child nodes.", trace);
            return false;
        }
        IXQEQueryNode[] summaries = node.getAncestorsOfType(1080);
        if (summaries.length != 0) {
            this.traceNodeCondition(false, "V5ValueSet is a descendant of a Report Summary", trace);
            return false;
        }
        int iNode = 0;
        for (iNode = 0; iNode < node.getNumberChildren() && !node.getChild(iNode).isOfCategory(1021); ++iNode) {
        }
        if (iNode >= node.getNumberChildren()) {
            this.traceNodeCondition(false, "V5ValueSet does not have a child MDX node coercable to set.", trace);
            return false;
        }
        for (int i = 0; i < v5SortItemNodes.length; ++i) {
            if (v5SortItemNodes[i].getNumberChildren() != 0 && v5SortItemNodes[i].getChild(0).isOfCategory(1001)) continue;
            this.traceNodeCondition(false, "At least one of the V5SortItem nodes has an unresolved V5 expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5ValueSet node has at least one V5SortItem child node.", trace);
        return true;
    }
}

