/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.HandleRowsProjectingDuplicatedSets;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasFromGroupBodyHeaderFooter;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class TransformNonDetailGroupBodyItems
extends AbstractV5ToCogMDXTransformation {
    public TransformNonDetailGroupBodyItems() {
        this.mName = "Transform data items in a non-detail group's groupBody.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101051};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXLevelInfo projLevelInfo;
        int i = 0;
        V5ValueSet v5ValueSet = (V5ValueSet)node.getParent();
        AbstractMDXNode valueSetProjSet = (AbstractMDXNode)v5ValueSet.getChild(0);
        ILevel valueSetSingleNonContextDependentProjLevel = null;
        MDXHierInfo valueSetProjHierInfo = valueSetProjSet.getHierarchyInfo();
        IHierarchy valueSetProjHier = null;
        if (valueSetProjHierInfo.getNumProjectedHierarchies() > 0 && !valueSetProjSet.isContextDependent(valueSetProjHier = valueSetProjSet.getHierarchyInfo().getProjectedHierarchy(0)) && (projLevelInfo = valueSetProjSet.getLevelInfo()).getNumProjectedLevels(valueSetProjHier) == 1) {
            valueSetSingleNonContextDependentProjLevel = projLevelInfo.getProjectedLevel(valueSetProjHier, 0);
        }
        RSAPIEdgeRowset rowset = v5ValueSet.getRSAPIEdgeRowset();
        RSAPIDataItem refDataItem = rowset.getRefDataItem();
        while (i < node.getNumberChildren()) {
            boolean notApplicable = false;
            valueSetProjSet = (AbstractMDXNode)v5ValueSet.getChild(0);
            V5DataItemRef v5DataItemRef = (V5DataItemRef)node.getChild(i);
            AbstractMDXNode expr = (AbstractMDXNode)v5DataItemRef.getChild(0);
            MDXHierInfo hierInfo = expr.getHierarchyInfo();
            if (expr.getType() == 1116) {
                if (valueSetProjHierInfo.getNumProjectedHierarchies() > 1 || !valueSetProjHierInfo.compareProjectedHierarchies(hierInfo)) {
                    notApplicable = true;
                }
                MDXLevelInfo propertyLevelInfo = expr.getLevelInfo();
                if (valueSetSingleNonContextDependentProjLevel != null && propertyLevelInfo.getNumProjectedLevels(valueSetProjHier) == 1 && !valueSetSingleNonContextDependentProjLevel.equals(propertyLevelInfo.getProjectedLevel(valueSetProjHier, 0))) {
                    notApplicable = true;
                }
                if (!notApplicable) {
                    String dataItemRefName = v5DataItemRef.getDataItemRefProperty();
                    int ordinal = rowset.getDataItemOrdinalByName(dataItemRefName);
                    if (ordinal == -1 && (dataItemRefName = (String)v5DataItemRef.getPropertyValue("orgName")) != null) {
                        ordinal = rowset.getDataItemOrdinalByName(dataItemRefName);
                    }
                    v5ValueSet.appendDataItemIndexProjectingSameSet(rowset.getRowsetId(), ordinal);
                    refDataItem.addAdditionalDataItemIndex(ordinal);
                    HandleRowsProjectingDuplicatedSets.updateQueryOfAssociatedSet(v5DataItemRef, v5ValueSet);
                    v5DataItemRef.detach();
                    if (valueSetProjSet.isOfCategory(1021)) {
                        HandleRowsProjectingDuplicatedSets.associateProjectSets((AbstractMDXSet)expr, (AbstractMDXSet)valueSetProjSet);
                    }
                }
            } else {
                boolean projectMeasures = hierInfo.projectsMeasures();
                if (!projectMeasures) {
                    if (expr.getType() == 1039 && expr.getNumberChildren() == 1) {
                        expr = (AbstractMDXNode)((MDXSet)expr).getChild(0);
                    }
                    if (expr.getType() == 1013) {
                        expr = (AbstractMDXNode)((MDXCalculatedMemberReference)expr).getDefinition().getChild(0);
                    }
                    if (expr.isOfCategory(1061)) {
                        projectMeasures = true;
                    }
                }
                if (projectMeasures) {
                    ++i;
                    node.setPropertyValue("nonDetailGroupBodyValue", Boolean.TRUE);
                } else {
                    notApplicable = true;
                }
            }
            if (!notApplicable) continue;
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)v5DataItemRef.getPropertyValue("RSAPIRefDataItem");
            rsapiDataItem.setNotApplicableGroupbody();
            node.detachChild(i);
        }
        if (node.getNumberChildren() == 0) {
            node.detach();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getAncestorOfType(101049) != null) {
            status = true;
            this.traceQueryCondition(status, "The V5GroupBody node is within a V5Edge.", trace);
        } else {
            this.traceQueryCondition(status, "The V5GroupBody node is not within a V5Edge.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int i;
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue("nonDetailGroupBodyValue") != null) {
            this.traceQueryCondition(false, "The V5GroupBody node has only non-detail groupbody measures to be processed.", trace);
            return false;
        }
        if (RemoveReplicasFromGroupBodyHeaderFooter.queryCondition(node, environment, null) && RemoveReplicasFromGroupBodyHeaderFooter.nodeCondition(node, null)) {
            this.traceQueryCondition(false, "The V5GroupBody node has replica of an ancestor valueset to be processed.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 101057) {
            this.traceQueryCondition(false, "The V5GroupBody node is not within a V5ValueSet.", trace);
            return false;
        }
        V5ValueSet v5ValueSet = (V5ValueSet)parent;
        String refDataItem = v5ValueSet.getRefDataItemProperty();
        if (refDataItem == null || refDataItem.length() == 0) {
            this.traceQueryCondition(false, "The V5GroupBody node is a detail.", trace);
            return false;
        }
        for (i = 0; i < parent.getNumberChildren(); ++i) {
            IXQEQueryNode child = parent.getChild(i);
            if (child == node || child.isOfCategory(1001)) continue;
            this.traceQueryCondition(false, " need to wait children nodes tranformed into AbstractMDXSet nodes.", trace);
            return false;
        }
        for (i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode v5DataItemRef = node.getChild(i);
            if (v5DataItemRef == null || v5DataItemRef.getNumberChildren() == 0 || !v5DataItemRef.getChild(0).isOfCategory(1001)) {
                this.traceQueryCondition(false, " The V5GroupBody node has a V5DataItemRef child node that has no MDX child node.", trace);
                return false;
            }
            if (v5DataItemRef.getPropertyValue("RSAPIRefDataItem") != null) continue;
            this.traceQueryCondition(false, " The V5GroupBody node has a V5DataItemRef child node that has no RSAPIDataItem property.", trace);
            return false;
        }
        this.traceQueryCondition(true, " The V5GroupBody node is a nondetail that is not a member property or measure.", trace);
        return true;
    }
}

