/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.assignhierarchytocalc.AssignHierarchyToCalculatedMemberInInnermostValueSet;

public class DetectCalcMembersWithShellHiearchy
extends Transformation {
    public DetectCalcMembersWithShellHiearchy() {
        this.mName = "Throws an exception if finds at least one calculated member assigned to a shell hierarchy.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Integer nodeId = node.getId();
        throw new XQERuntimeException(XQEMessageKeys.PLN_AssignHierarchyToCalculatedMemberFail, nodeId.toString());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calculatedMemberReference = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition definition = calculatedMemberReference.getDefinition();
        IHierarchy hierarchy = definition.getHierarchy();
        if (hierarchy.isShell()) {
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfCategory(1002);
            if (!mdxQuery.validateDescendantCategories()) {
                this.traceNodeCondition(false, "The MDXQuery is not valid.  Throw errors for why the tree is invalid.", trace);
                return false;
            }
            if (AssignHierarchyToCalculatedMemberInInnermostValueSet.isNestedCalculationUnderValidHierarchy(calculatedMemberReference)) {
                String msg = "Should be handled by AssignHierarchyToCalculatedMemberInInnermostValueSet.";
                this.traceNodeCondition(false, "Should be handled by AssignHierarchyToCalculatedMemberInInnermostValueSet.", trace);
                return false;
            }
            this.traceNodeCondition(true, "The hierarchy for the target node has not been resolved", trace);
            return true;
        }
        this.traceNodeCondition(false, "The hierarchy for the target node has been resolved", trace);
        return false;
    }
}

