/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.for_clause;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeForClause;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class ValidateForClauseDataItems
extends Transformation {
    public static final String PROP_APPLIED = "ValidateForClauseDataItemsApplied";

    public ValidateForClauseDataItems() {
        this.mName = "Validate For Clause Data Items.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1138};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode child;
        int i;
        for (i = 0; i < node.getNumberChildren(); ++i) {
            child = node.getChild(i);
            if (child.isOfCategory(1021) || child.isOfCategory(1022) || child.isOfCategory(1072) || child.isOfCategory(1023)) continue;
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppFORExpr);
        }
        for (i = 0; i < node.getNumberChildren(); ++i) {
            child = (AbstractMDXNode)node.getChild(i);
            MDXLevelInfo levelInfo = ((AbstractMDXNode)child).getLevelInfo();
            if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_IndOrInvFORExprHierInfo);
            }
            IHierarchy hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            if (hierarchy.getDimension().isMeasuresDimension()) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_IndOrInvFORExprHierInfo);
            }
            if (levelInfo.getNumProjectedLevels(hierarchy) == 0) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_IndFORExprLevelInfo);
            }
            if (!((AbstractMDXNode)child).isContextDependent(hierarchy)) continue;
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppCtxtDepFORExpr);
        }
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target TNodeForClause node are invalid.", trace);
            return false;
        }
        TNodeForClause tNode = (TNodeForClause)node;
        String forType = tNode.getForType();
        if (!(forType.equals("for") || forType.equals("forAll") || forType.equals("forAny"))) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not of type TNodeForClause.FOR/FOR_ANY/FOR_ALL.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target TNodeForClause node.", trace);
        return true;
    }
}

