/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertV5IfExpressionToMDXIIF
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5IfExpressionToMDXIIF() {
        this.mName = "Convert the V5IfExpression function by any of the MDXIIF function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5IfExpression v5IfExpression = (V5IfExpression)node;
        IDataType dataType = v5IfExpression.getDataTypeProperty();
        int iifType = 0;
        if (dataType.getSubType() == DataSubType.NUMERICTYPE) {
            iifType = 1085;
        } else if (dataType.getSubType() == DataSubType.TEXTTYPE) {
            iifType = 1086;
        } else if (dataType.getSubType() == DataSubType.DATETIMETYPE) {
            iifType = 1168;
        }
        AbstractMDXNode mdxIIF = (AbstractMDXNode)nodeFactory.createNode(iifType);
        boolean transferDescendants = true;
        mdxIIF.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.getParent().exchangeChildNode(node, mdxIIF, transferDescendants);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int maxNumchildren = 3;
        V5IfExpression v5IfExpression = (V5IfExpression)node;
        if (node.getNumberChildren() == 3 && node.getChild(0).isOfCategory(1071) && node.getChild(1).isOfCategory(1061) && node.getChild(2).isOfCategory(1061) && v5IfExpression.getDataTypeProperty() != null) {
            status = true;
            this.traceNodeCondition(status, "The V5IfExpression expression have 3 valid arguments.", trace);
        } else {
            this.traceNodeCondition(status, "The V5IfExpression expression have not 3 valid arguments.", trace);
        }
        IDataType dataType = v5IfExpression.getDataTypeProperty();
        if (dataType != null && dataType.getSubType() != DataSubType.NUMERICTYPE && dataType.getSubType() != DataSubType.TEXTTYPE && dataType.getSubType() != DataSubType.DATETIMETYPE) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_Unsupported_IIF_FunctionArgument);
        }
        return status;
    }
}

