/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXOrder;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5OrderFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class ConvertV5OrderToMDXOrder
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5OrderToMDXOrder() {
        this.mName = "Convert V5 Tuple Function to MDX Tuple Function";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201091};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int mdxOrderType;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXOrder mdxOrder = (MDXOrder)nodeFactory.createNode(1058);
        node.getParent().exchangeChildNode(node, mdxOrder, true);
        int v5OrderType = ((V5OrderFunction)node).getOption();
        switch (v5OrderType) {
            case 2: {
                mdxOrderType = 2;
                break;
            }
            case 4: {
                mdxOrderType = 3;
                break;
            }
            case 1: {
                mdxOrderType = 0;
                break;
            }
            case 3: {
                mdxOrderType = 1;
                break;
            }
            case 0: {
                mdxOrderType = 0;
                break;
            }
            default: {
                mdxOrderType = 0;
            }
        }
        mdxOrder.setOrderingProperty(mdxOrderType);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2) {
            IXQEQueryNode firstChild = node.getChild(0);
            IXQEQueryNode secondChild = node.getChild(1);
            if (node.getChild(0).isOfCategory(1021) && V5ToCogMDXUtilities.isCoercableToValueExpression(secondChild)) {
                MDXHierInfo hierarchyInfo = ((AbstractMDXNode)firstChild).getHierarchyInfo();
                if (hierarchyInfo.getNumProjectedHierarchies() == 1) {
                    int v5OrderType = ((V5OrderFunction)node).getOption();
                    if (v5OrderType == 0 || v5OrderType == 1 || v5OrderType == 3 || v5OrderType == 4 || v5OrderType == 2) {
                        status = true;
                        this.traceNodeCondition(status, "The V5 Order expression is valid and could be converted to the MDX expression.", trace);
                    }
                } else {
                    this.traceNodeCondition(status, "One of the arguments is from a invalid type.", trace);
                }
            } else {
                this.traceNodeCondition(status, "The set expression from more than one hierarchy.", trace);
            }
        } else {
            this.traceNodeCondition(status, "The V5 Order function has a missing or extra argument(s).", trace);
        }
        return status;
    }
}

