/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.CogMDXStringFunction;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertV5StringFunctionToMDXStringFunction
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5StringFunctionToMDXStringFunction() {
        this.mName = "Convert V5 String functions to CogMDX String functions.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXStringFunction stringFunctionNode = (CogMDXStringFunction)nodeFactory.createNode(1149);
        int functionType = ((V5StringFunction)node).getSubType();
        int functionMDXType = -1;
        if (functionType == 0) {
            functionMDXType = 1;
        } else if (functionType == 1) {
            functionMDXType = 2;
        }
        stringFunctionNode.setOperatorType(functionMDXType);
        node.getParent().exchangeChildNode(node, stringFunctionNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.getChild(0).isOfCategory(1061) || !((AbstractMDXValueExpression)node.getChild(0)).isString()) {
            this.traceNodeCondition(false, "The first child of the target V5StringFunction node is not a string.", trace);
            return false;
        }
        int functionType = ((V5StringFunction)node).getSubType();
        if (functionType != 0 && functionType != 1) {
            this.traceNodeCondition(false, "Unsupported type for V5StringFunction node", trace);
            return false;
        }
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "Incorrect number of children for V5StringFunction", trace);
            return false;
        }
        return true;
    }
}

