/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5SubsetToMDXSubset
extends AbstractV5ToCogMDXTransformation {
    public static final int MIN_V5SUBSET_CHILDREN = 2;
    public static final int MAX_V5SUBSET_CHILDREN = 3;

    public ConvertV5SubsetToMDXSubset() {
        this.mName = "Convert the V5 Subset function by the MDX Subset function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201104};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxHeadNode = nodeFactory.createNode(1090);
        node.getParent().exchangeChildNode(node, mdxHeadNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        int nbrArguments = node.getNumberChildren();
        if (nbrArguments < 2 || nbrArguments > 3) {
            status = false;
            this.traceNodeCondition(status, "The V5 Subset function doesn't have valid number of arguments.", trace);
        } else {
            if (!node.getChild(0).isOfCategory(1021)) {
                status = false;
                this.traceNodeCondition(status, "The first argument of the V5 Subset function is not a valid set expression.", trace);
            }
            if (status && nbrArguments == 2 && !node.getChild(1).isOfCategory(1061)) {
                status = false;
                this.traceNodeCondition(status, "The second argument of the V5 Subset function is not a valid numeric expression.", trace);
            } else if (status && nbrArguments == 3 && !node.getChild(2).isOfCategory(1061)) {
                status = false;
                this.traceNodeCondition(status, "The third argument of the V5 Subset function is not a valid numeric expression.", trace);
            }
            if (status) {
                this.traceNodeCondition(status, "The V5 Subset functions is valid.", trace);
            }
        }
        return status;
    }
}

