/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.util.MetadatatoMDXMemberPropertyTranslator;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.provider.ProviderTransformation;

public class AddSAPBusinessKey
extends ProviderTransformation {
    public AddSAPBusinessKey() {
        super(new String[]{"BW"});
        this.mName = "Add Projected Member Properties to the Axi's DIMENSION PROPERTIES Clause.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        while (node.getNumberChildren() > 1) {
            String propertyName = null;
            BaseProperty baseProperty = (BaseProperty)node.detachChild(1);
            IQueryItem property = baseProperty.getPropertyMetadata();
            if (property == null) {
                propertyName = baseProperty.getPropertyName();
            } else {
                propertyName = property.getUniqueName();
                if (property.isBusinessKey()) {
                    propertyName = "memberUniqueName";
                }
            }
            if ((propertyName = MetadatatoMDXMemberPropertyTranslator.translate(propertyName)) == null) continue;
            edge.addMemberProperty(propertyName);
        }
        node.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getAncestorOfType(1006) != null) {
            status = true;
            this.traceQueryCondition(status, "The TNodeProjProperty node is within a MDXEdge.", trace);
        } else {
            this.traceQueryCondition(status, "The TNodeProjProperty node is not within a MDXEdge.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        int numChildren = node.getNumberChildren();
        if (numChildren > 1) {
            for (int i = 1; i < numChildren; ++i) {
                IQueryItem property;
                BaseProperty baseProperty = (BaseProperty)node.getChild(i);
                if (baseProperty.getPropertyMetadata() == null || !(property = baseProperty.getPropertyMetadata()).isBusinessKey()) continue;
                this.traceQueryCondition(true, "The TNodeProjProperty has a businesskey property, and is against SAPBW provider.", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "The edge dose not project an SAP business key property.", trace);
        return false;
    }
}

