/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.rsapicompensation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.normalization.OrderCogMDXNestNodesByHierarchyAndLevel;
import java.util.List;

public final class UpdateRSAPIDataTypeUsageProjectedDataItem
extends Transformation {
    public static final String DATA_TYPE_USAGE_UPDATED = "dataTypeUsageUpdated";

    public UpdateRSAPIDataTypeUsageProjectedDataItem() {
        this.mName = "Update RSAPI data type and for projected data item.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1027, 1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataItem rsapiDataItem = ((AbstractMDXSet)node).getFirstRSAPIDataItem();
        AbstractMDXSet firstChild = (AbstractMDXSet)node.getChild(0);
        MDXHierInfo hierInfo = firstChild.getHierarchyInfo();
        boolean measuresFound = hierInfo.projectsMeasures();
        List<MDXCalculatedMemberReference> projectedCalculatedMembers = firstChild.getProjectedCalculatedMembers();
        boolean isMeasureNumericExpression = hierInfo.projectsMeasures() && hierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0 && projectedCalculatedMembers.size() == 1;
        isMeasureNumericExpression = isMeasureNumericExpression && node.getType() == 1027 && projectedCalculatedMembers.get(0).getPropertyValue("AdjustUsageForNumericMemberFunctions") == Boolean.TRUE;
        for (IXQEQueryNode iXQEQueryNode : projectedCalculatedMembers) {
            boolean isLiteral = false;
            measuresFound = false;
            MDXCalculatedMemberReference mdxCalcMemberReference = (MDXCalculatedMemberReference)iXQEQueryNode;
            if (!mdxCalcMemberReference.isPlannerHierarchy()) {
                hierInfo = mdxCalcMemberReference.getHierarchyInfo();
            } else {
                AbstractMDXValueExpression calcExpression = (AbstractMDXValueExpression)mdxCalcMemberReference.getDefinition().getChild(0);
                hierInfo = calcExpression.getResolvedHierarchyInfo(calcExpression);
                if (hierInfo.getNumProjectedHierarchies() == 0) {
                    isLiteral = calcExpression.isLiteral();
                }
                boolean bl = isMeasureNumericExpression = isMeasureNumericExpression && calcExpression.isOfCategory(1062);
            }
            if (hierInfo.projectsShellHierarchy()) {
                mdxCalcMemberReference.throwInternalError("hierInfo.projectsShellHierarchy()");
            }
            if (isMeasureNumericExpression) {
                measuresFound = true;
                break;
            }
            if (!hierInfo.projectsMeasures() && !isLiteral) continue;
            measuresFound = true;
            break;
        }
        if (rsapiDataItem.getDataType() == MemberType.MEMBERTYPE || rsapiDataItem.getDataType() == null && measuresFound) {
            rsapiDataItem.setDataType(DoubleType.DOUBLETYPE);
        }
        if (measuresFound || rsapiDataItem.isGroupbodyMeasure()) {
            rsapiDataItem.setUsage(RSAPIUsage.FACT);
        } else {
            RSAPIDataset dataset = (RSAPIDataset)node.getAncestorOfType(401005);
            if (rsapiDataItem.getUsage() != RSAPIUsage.FACT || !dataset.forXtabRelational()) {
                rsapiDataItem.setUsage(RSAPIUsage.IDENTIFIER);
            }
        }
        node.setPropertyValue(DATA_TYPE_USAGE_UPDATED, "true");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo hierInfo;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(DATA_TYPE_USAGE_UPDATED) != null) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        if (node.getType() == 1027 && (!OrderCogMDXNestNodesByHierarchyAndLevel.isProjected((CogMDXGroup)node) || ((CogMDXGroup)node).isNonDetailGroupBodyValue())) {
            this.traceNodeCondition(false, "The node is a not projected.", trace);
            return false;
        }
        RSAPIDataItem rsapiDataItem = ((AbstractMDXSet)node).getFirstRSAPIDataItem();
        if (rsapiDataItem == null) {
            this.traceNodeCondition(false, "The node does not have a referenced RSAPIRefDataItem.", trace);
            return false;
        }
        if (!(rsapiDataItem.getDataType() != MemberType.MEMBERTYPE && rsapiDataItem.getUsage() != RSAPIUsage.ATTRIBUTE || (hierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo()).projectsMeasures() || node.getPropertyValue("Wrapped Measure") != null)) {
            this.traceNodeCondition(false, "The data type of the referenced RSAPIRefDataItem is Member and not in the measures dimension.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The first child of the node projects a value expression.", trace);
        return true;
    }
}

