/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasFromGroupBodyHeaderFooter;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class ConvertV5GroupHeaderFooterToCogMDXReportSummaries
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5GroupHeaderFooterToCogMDXReportSummaries() {
        this.mName = "Convert V5 Group Header/Footer to Cog MDX Report Summary nodes as sibling to the related V5 Value Set.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101053, 101052};
    }

    private IXQEQueryNode buildDetailExpr(IXQEQueryNode origNode, IXQENodeFactory nodeFactory) {
        if (origNode == null) {
            return null;
        }
        if (origNode.getType() == 1080 || origNode.getType() == 101053 || origNode.getType() == 101052) {
            return null;
        }
        int[] types = new int[]{1027, 1026, 101057};
        if (origNode.getDescendantsOfTypes(types, true).length == 0) {
            return nodeFactory.deepCopyNode(origNode);
        }
        int i = 0;
        if (origNode.getType() == 1027 || origNode.getType() == 1026 || origNode.getType() == 101057) {
            MDXHierInfo mdxHierInfo;
            IXQEQueryNode firstChild = origNode.getChild(0);
            if (firstChild.getType() == 1117) {
                firstChild = firstChild.getChild(0);
            }
            if (firstChild.getType() == 1026) {
                return this.buildDetailExpr(firstChild, nodeFactory);
            }
            if (firstChild.isOfCategory(1001) && (mdxHierInfo = ((AbstractMDXNode)firstChild).getHierarchyInfo()).projectsMeasures()) {
                i = 1;
                if (origNode.getNumberChildren() == 1) {
                    if (origNode.getAncestorOfType(1026) == null) {
                        return nodeFactory.deepCopyNode(origNode);
                    }
                    return null;
                }
            }
        }
        IXQEQueryNode newNode = null;
        if (i != 1) {
            newNode = nodeFactory.copyNode(origNode);
        }
        while (i < origNode.getNumberChildren()) {
            IXQEQueryNode newChildNode = this.buildDetailExpr(origNode.getChild(i), nodeFactory);
            if (newChildNode != null) {
                if (newNode == null) {
                    newNode = newChildNode;
                } else {
                    newNode.addChild(newChildNode);
                }
            }
            ++i;
        }
        if (newNode != null && newNode.getNumberChildren() > 0) {
            return newNode;
        }
        return null;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getAncestorOfType(1012) != null) {
            node.getParent().detachChild(node);
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXReportSummary cogMDXRepSummary = (CogMDXReportSummary)nodeFactory.createNode(1080);
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        MDXQuery mdQuery = (MDXQuery)node.getAncestorOfType(1002);
        String refQuery = mdQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        IXQEQueryNode origDetailExpr = node.getParent();
        IXQEQueryNode detailExpr = this.buildDetailExpr(origDetailExpr, nodeFactory);
        IXQEQueryNode[] v5DataItemRefs = node.getChildren();
        for (int idx = 0; idx < v5DataItemRefs.length; ++idx) {
            V5DataItemRef v5DataItemRef = (V5DataItemRef)v5DataItemRefs[idx];
            IXQEQueryNode mdxTuple = nodeFactory.createNode(1069);
            CogMDXReportSummaryExpr cogMDXReportSummaryExpr = (CogMDXReportSummaryExpr)nodeFactory.createNode(1028);
            mdxTuple.addChild(cogMDXReportSummaryExpr);
            V5DataItem v5DataItemRefv5DataItem = v5Query.getV5Selection().getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
            Integer solveOrder = v5DataItemRefv5DataItem.getSolveOrderProperty();
            if (solveOrder == null) {
                solveOrder = XQEIntegerPool.getInteger(0);
            }
            cogMDXReportSummaryExpr.setSolveOrder(solveOrder);
            V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(v5DataItemRefv5DataItem.getRollupAggregateProperty());
            if (detailExpr != null) {
                AbstractMDXNumericValueFunction cogMDXAggregate;
                IXQEQueryNode context = nodeFactory.deepCopyNode(detailExpr);
                if ((rollupAggregate == V5RollupAggregateEnum.COUNT || rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT) && v5DataItemRef.getPropertyValue("CountOnProjectedNonMeasureColumn") != null) {
                    IXQEQueryNode mdxCount = nodeFactory.createNode(1087);
                    ICube cube = mdQuery.getMDXFrom().getCube();
                    if (mdQuery.isSuppressNulls() && (!(cube instanceof CubeWrapper) || ((CubeWrapper)cube).containsNonDefaultMeasure())) {
                        ((MDXCount)mdxCount).setIncludeEmpty(false);
                        context = nodeFactory.deepCopyNode(origDetailExpr);
                    }
                    cogMDXReportSummaryExpr.addChild(mdxCount);
                    ((MDXCount)mdxCount).setIsWithinDetailCalc(true);
                    mdxCount.addChild(context);
                    mdxCount.setPropertyValue("CountOnProjectedNonMeasureColumn", v5DataItemRef.getPropertyValue("CountOnProjectedNonMeasureColumn"));
                } else if (v5DataItemRef.getChild(0).getType() != 1016 || context.getChild(0).getType() != 1116 || rollupAggregate != V5RollupAggregateEnum.COUNT && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT) {
                    cogMDXAggregate = (CogMDXAggregate)nodeFactory.createNode(1012);
                    cogMDXReportSummaryExpr.addChild(cogMDXAggregate);
                    cogMDXAggregate.addChild(context);
                    AbstractMDXNode valueExpression = this.generateValueExpression(v5DataItemRef, rollupAggregate, mdQuery, environment);
                    ((MDXSummaryFunction)cogMDXAggregate).setIsWithinDetailCalc(true);
                    cogMDXAggregate.addChild(valueExpression);
                } else {
                    cogMDXAggregate = (MDXCount)nodeFactory.createNode(1087);
                    cogMDXAggregate.setIsWithinDetailCalc(true);
                    cogMDXReportSummaryExpr.addChild(cogMDXAggregate);
                    cogMDXAggregate.addChild(context);
                }
            } else {
                if (rollupAggregate == V5RollupAggregateEnum.COUNT || rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregationNonMeasureDataItem, rollupAggregate.getName(), v5DataItemRef.getPropertyValue("refDataItem").toString());
                }
                AbstractMDXNode valueExpression = this.generateValueExpression(v5DataItemRef, rollupAggregate, mdQuery, environment);
                cogMDXReportSummaryExpr.addChild(valueExpression);
            }
            cogMDXRepSummary.addChild(mdxTuple);
            RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)v5DataItemRefs[idx].getPropertyValue("RSAPIRefDataItem");
            cogMDXRepSummary.setRSAPIDataItem(rsapiRefDataItem);
            cogMDXRepSummary.setRSAPIEdgeRowset(rowset);
        }
        cogMDXRepSummary.bindSummaryToDetailExpr(node.getParent());
        if (node.getType() == 101053) {
            node.getParent().getParent().addChildBeforeNode(cogMDXRepSummary, node.getParent());
        } else {
            node.getParent().getParent().addChildAfterNode(cogMDXRepSummary, node.getParent());
        }
        node.detach();
    }

    private AbstractMDXNode generateValueExpression(V5DataItemRef v5DataItemRef, V5RollupAggregateEnum rollupAggregate, MDXQuery mdQuery, PlanningEnvironment environment) {
        AbstractMDXNode valueExpression = (AbstractMDXNode)v5DataItemRef.getChild(0);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        boolean isMeasure = false;
        if (valueExpression.getType() == 1067) {
            isMeasure = ((BaseMember)valueExpression).isMeasure();
        }
        if (rollupAggregate != V5RollupAggregateEnum.NONE && rollupAggregate != V5RollupAggregateEnum.UNDEFINED && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT && (V5ToCogMDXUtilities.isCoercableToNumericValueExpression(valueExpression) || isMeasure) || rollupAggregate == V5RollupAggregateEnum.COUNT && V5ToCogMDXUtilities.isCoercableToValueExpression(valueExpression)) {
            valueExpression = (AbstractMDXNode)nodeFactory.deepCopyNode(valueExpression);
            valueExpression = MDXBuilder.coerceToValueExpression(valueExpression, nodeFactory);
        } else {
            MDXNumericConstant anyValue = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)nodeFactory, 1);
            MDXCalculatedMemberReference mdxCalcMemberRef = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdQuery, mdQuery.getMeasuresHierarchy(), "_RSNONE", anyValue, 0);
            mdxCalcMemberRef.setIsReportSumary();
            valueExpression = MDXBuilder.coerceToNumericValueExpression(mdxCalcMemberRef, nodeFactory);
            if (rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT) {
                ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
                messageFolder.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_UnsupportedAggregateAttribute, rollupAggregate.getName(), (String)v5DataItemRef.getPropertyValue("refDataItem")));
                rollupAggregate = V5RollupAggregateEnum.NONE;
            } else if (rollupAggregate == V5RollupAggregateEnum.NONE || rollupAggregate == V5RollupAggregateEnum.UNDEFINED) {
                ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
                messageFolder.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_AggregationTypeNone, rollupAggregate.getName(), (String)v5DataItemRef.getPropertyValue("refDataItem")));
            } else {
                ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
                messageFolder.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_UnsupportedAggregationNonMeasureDataItem, rollupAggregate.getName(), (String)v5DataItemRef.getPropertyValue("refDataItem")));
                rollupAggregate = V5RollupAggregateEnum.NONE;
            }
        }
        valueExpression.setRollupAggregate(rollupAggregate);
        return valueExpression;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5DataItemRefs;
        XQETrace trace = environment.getTrace();
        if (RemoveReplicasFromGroupBodyHeaderFooter.queryCondition(node, environment, null) && RemoveReplicasFromGroupBodyHeaderFooter.nodeCondition(node, null)) {
            this.traceNodeCondition(false, "Apply first RemoveReplicasFromGroupBodyHeaderFooter.", trace);
            return false;
        }
        if (node.getPropertyValue("summaryType") == null) {
            this.traceNodeCondition(false, "This node is not ready for summary generation.", trace);
            return false;
        }
        if (node.getPropertyValue("summaryType") == "summaryLocal") {
            this.traceNodeCondition(false, "This node will be transformed to a local summary.", trace);
            return false;
        }
        for (IXQEQueryNode dataItemRef : v5DataItemRefs = node.getChildren()) {
            if (dataItemRef.getType() != 101015) {
                node.throwInternalError("Child of header/footer is not a data item reference.");
            }
            if (dataItemRef.getNumberChildren() != 1) {
                node.throwInternalError("Failed to get referenced data item.");
            }
            if (dataItemRef.getChild(0).isOfCategory(1001)) continue;
            this.traceNodeCondition(false, "The child is not an AbstractMDXNode yet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This node will be transformed to a mdx summary.", trace);
        return true;
    }
}

