/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXIsEmpty;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXValue;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.summary.ValidateV5ValueSummaryFunction;

public final class ConvertV5ValueCountToIfThenElse
extends Transformation {
    public ConvertV5ValueCountToIfThenElse() {
        this.mName = "Convert the V5 Value Summary Function (count) when having a numeric value expression as single argument to an if-then-else.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXValueExpression valueExpr = (AbstractMDXValueExpression)node.getChild(0).detach();
        MDXIsEmpty isEmpty = MDXBuilder.buildMDXIsEmptyExpr(factory, valueExpr);
        MDXNumericConstant one = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 1);
        MDXNumericConstant zero = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0);
        MDXNumericIIF iif = MDXBuilder.buildMDXNumericIIFExpr(factory, isEmpty, zero, one);
        node.exchange(iif);
    }

    public static boolean isValidCountMeasure(V5ValueSummaryFunction v5ValueSummaryFunction) {
        int v5SummaryType = v5ValueSummaryFunction.getSubType();
        if (v5SummaryType != 2 && v5SummaryType != 3) {
            return false;
        }
        if (v5ValueSummaryFunction.getBooleanPropertyValue("ChildV5ValueSummaryFunctionCollapsed") == Boolean.TRUE) {
            return false;
        }
        IXQEQueryNode childNode = v5ValueSummaryFunction.getChild(0);
        MDXSummaryFunctionTypeEnum mdxSummaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryType);
        if (childNode.getType() == 1059 && ((MDXValue)childNode).containsOnlyMeasure() && childNode.getChild(0).getChild(0).getType() == 1067) {
            IMeasure measure = (IMeasure)((BaseMember)childNode.getChild(0).getChild(0)).getMember();
            return ValidateV5ValueSummaryFunction.isSummaryTypeValidForMeasure(v5SummaryType, mdxSummaryType, measure);
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1002) == null) {
            this.traceQueryCondition(false, "The target V5ValueSummaryFunction node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter != null && mdxDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceNodeCondition(false, "Not applicable to detail filter expression pushed to relational planning.", environment.getTrace());
            return false;
        }
        if (node.getNumberChildren() != 1 || !node.getChild(0).isOfCategory(1061)) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node has more than one argument or it's child is not an MDX value expression.", trace);
            return false;
        }
        int v5SummaryType = ((V5ValueSummaryFunction)node).getSubType();
        if (v5SummaryType != 2 && v5SummaryType != 3) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node is not a count.", trace);
            return false;
        }
        if (ConvertV5ValueCountToIfThenElse.isValidCountMeasure((V5ValueSummaryFunction)node)) {
            this.traceNodeCondition(false, "Count summary function is valid to push to the provider based on measure.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target V5ValueSummaryFunction node is a count.", trace);
        return true;
    }
}

