/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.DisableMasterDetailOptimizationWhenV5Reform;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformInfo;
import java.util.List;

public final class NormalizeMeasuresOnMultipleEdges
extends Transformation {
    private static final String TRANSFORMATION_APPLIED = "appliedNormalizeMeasuresOnMultipleEdges";

    public NormalizeMeasuresOnMultipleEdges() {
        this.mName = "Normalize measures on multiple edges.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] iXQEQueryNodeArray;
        IXQEQueryNode[] measures;
        if (Boolean.TRUE.equals(node.getPropertyValue(TRANSFORMATION_APPLIED))) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMeasureMultiEdges);
        }
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node;
        IXQEQueryNode[] edges = mdxQuery.getChildrenOfTypeOrdered(101049);
        ReformInfo reformInfo = new ReformInfo(mdxQuery, edges);
        reformInfo.needReform(environment, mdxQuery);
        List<V5Edge> measuresEdges = reformInfo.getMeasuresEdges();
        XQEBaseQueryNode edge = null;
        Integer edgeId = null;
        for (V5Edge v5Edge : measuresEdges) {
            if (edgeId != null && v5Edge.getEdgeID() >= edgeId) continue;
            edge = v5Edge;
        }
        for (IXQEQueryNode measure : measures = edge.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)measure;
            if (!identifier.isMeasure() || measure.getParent().getType() != 201101 || measure.getParent().getParent().getType() != 101057) continue;
            IXQEQueryNode nullLiteral = factory.createNode(201023);
            measure.exchange(nullLiteral);
            V5ToCogMDXUtilities.createV5MemberExpression(nullLiteral, environment, identifier.getNativeName(), identifier.getNativeName());
        }
        for (IXQEQueryNode calcMeasure : iXQEQueryNodeArray = edge.getDescendantsOfType(201085, false)) {
            V5MemberFunction v5MemberFunction = (V5MemberFunction)calcMeasure;
            if (v5MemberFunction.getNumberChildren() < 4 || !v5MemberFunction.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension() || v5MemberFunction.getParent().getType() != 201101 || v5MemberFunction.getParent().getParent().getType() != 101057) continue;
            IXQEQueryNode nullLiteral = factory.createNode(201023);
            v5MemberFunction.getChild(0).exchange(nullLiteral);
            v5MemberFunction.getChild(3).detach().removeFromIndex();
        }
        IXQEQueryNode[] v5Groups = node.getDescendantsOfType(101050, false);
        for (int i = 0; i < v5Groups.length; ++i) {
            if (!((V5EdgeGroup)v5Groups[i]).hasPropertyHierarchy()) continue;
            ((V5EdgeGroup)v5Groups[i]).removePropertyHierarchy();
        }
        node.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        DisableMasterDetailOptimizationWhenV5Reform transformation;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getCapabilities().isSupported("v5.reportermode.measureOnMultipleEdges")) {
            this.traceQueryCondition(false, "Reporter mode transformations will handle the projected measures.", trace);
            return false;
        }
        if (((MDXQuery)node).isListReport()) {
            this.traceQueryCondition(false, "This transformation just handles MDXQuery for xtab.", trace);
            return false;
        }
        IXQEQueryNode mdw = node.getAncestorOfType(601026);
        if (mdw != null && ((Transformation)(transformation = new DisableMasterDetailOptimizationWhenV5Reform())).passesQueryCondition(mdw, environment) && ((Transformation)transformation).passesNodeCondition(mdw, environment)) {
            this.traceQueryCondition(false, "Awaiting DisableMasterDetailOptimization.", trace);
            return false;
        }
        IXQEQueryNode[] v5Groups = node.getDescendantsOfType(101050, false);
        for (int i = 0; i < v5Groups.length; ++i) {
            if (((V5EdgeGroup)v5Groups[i]).hasPropertyHierarchy()) continue;
            this.traceQueryCondition(false, "This transformation needs V5EdgeGroup property hierarchy.", trace);
            return false;
        }
        IXQEQueryNode[] edges = node.getChildrenOfTypeOrdered(101049);
        if (edges.length == 0) {
            this.traceQueryCondition(false, "No V5Edge nodes found for the query.", trace);
            return false;
        }
        ReformInfo reformInfo = new ReformInfo((MDXQuery)node, edges);
        reformInfo.needReform(environment, mdxQuery);
        if (reformInfo.getState() > 0) {
            if (reformInfo.measureOnEdges()) {
                this.traceNodeCondition(true, "The MXDQuery needs reform on measures.", trace);
                return true;
            }
            this.traceNodeCondition(false, "The MXDQuery needs reform.", trace);
            return false;
        }
        this.traceQueryCondition(false, "The MDXQuery does not need reform.", trace);
        return false;
    }
}

