/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformInfo;
import java.util.ArrayList;
import java.util.List;

public final class NormalizeRelationalCrosstabCalculations
extends Transformation {
    private static final String APPLIED = "Normalized";
    public static final String WRAPPED_MEASURE = "Wrapped Measure";

    public NormalizeRelationalCrosstabCalculations() {
        this.mName = "Normalize relational crosstab calculations.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Integer highestAggrSolveOrder = this.getHighestSolveOrderAggr(node);
        IXQEQueryNode[] edges = node.getChildrenOfTypeOrdered(101049);
        this.wrapMeasures(edges, environment.getNodeFactory(), highestAggrSolveOrder);
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(APPLIED) != null) {
            return false;
        }
        if (((MDXQuery)node).isListReport()) {
            this.traceQueryCondition(false, "This transformation just handles MDXQuery for xtab.", trace);
            return false;
        }
        IXQEQueryNode[] v5Groups = node.getDescendantsOfType(101050, false);
        for (int i = 0; i < v5Groups.length; ++i) {
            if (((V5EdgeGroup)v5Groups[i]).hasPropertyHierarchy()) continue;
            this.traceQueryCondition(false, "This transformation needs V5EdgeGroup property hierarchy.", trace);
            return false;
        }
        IXQEQueryNode[] edges = node.getChildrenOfTypeOrdered(101049);
        if (edges.length <= 1) {
            this.traceQueryCondition(false, "More than one V5Edge nodes not found for the query.", trace);
            return false;
        }
        ReformInfo reformInfo = new ReformInfo((MDXQuery)node, edges);
        MDXQuery mdxQuery = (MDXQuery)node;
        if (reformInfo.getState() <= 0 && reformInfo.needRelationalCrosstabNormalization(environment, mdxQuery)) {
            this.traceNodeCondition(true, "The MXDQuery needs reform.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The MDXQuery does not need reform.", trace);
        return false;
    }

    protected Integer getHighestSolveOrderAggr(IXQEQueryNode node) {
        IXQEQueryNode[] aggrFuncs = node.getDescendantsOfType(201032, false);
        if (aggrFuncs.length == 0) {
            return null;
        }
        MDXQuery mdQuery = (MDXQuery)node;
        String refQuery = mdQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)mdQuery.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        V5Selection v5Select = v5Query.getV5Selection();
        Integer highestSO = null;
        for (IXQEQueryNode f : aggrFuncs) {
            String refDataItemName;
            V5DataItem v5DataItem;
            V5ValueSet vs = (V5ValueSet)f.getAncestorOfType(101057);
            if (vs == null || (v5DataItem = v5Select.getDataItemByRefName(refDataItemName = vs.getRefDataItemProperty())) == null) continue;
            Integer so = v5DataItem.getSolveOrderProperty();
            if (so == null) {
                so = 0;
            }
            if (highestSO != null && highestSO.compareTo(so) >= 0) continue;
            highestSO = so;
        }
        return highestSO;
    }

    public void wrapMeasures(IXQEQueryNode[] edges, IXQENodeFactory nodeFactory, Integer highestAggrSolveOrder) {
        Integer leastSO = null;
        ArrayList<V5MemberFunction> generatedV5MemberFunction = new ArrayList<V5MemberFunction>();
        for (IXQEQueryNode e : edges) {
            V5Edge edge = (V5Edge)e;
            Boolean b = (Boolean)edge.getPropertyValue("reportMeasure");
            if (Boolean.TRUE.equals(b)) continue;
            List<IXQEQueryNode> v5Grps = edge.getDescendantsOfTypeOrdered(101050, false);
            for (int j = 0; j < v5Grps.size(); ++j) {
                V5EdgeGroup v5Grp = (V5EdgeGroup)v5Grps.get(j);
                IHierarchy v5GrpHier = v5Grp.getPropertyHierarchy();
                if (!v5GrpHier.getDimension().isMeasuresDimension()) continue;
                ArrayList<V5MemberFunction> rtV5members = new ArrayList<V5MemberFunction>();
                this.addMemberFunction(v5Grp, nodeFactory, rtV5members);
                if (rtV5members.isEmpty()) continue;
                generatedV5MemberFunction.addAll(rtV5members);
                for (V5MemberFunction f : rtV5members) {
                    Integer so = f.getSolveOrder();
                    if (so == null) {
                        so = 0;
                    }
                    if (leastSO != null && leastSO.compareTo(so) <= 0) continue;
                    leastSO = so;
                }
            }
        }
        if (highestAggrSolveOrder != null && leastSO != null && leastSO.compareTo(leastSO) >= 0) {
            int solveOrder = highestAggrSolveOrder + 1;
            for (V5MemberFunction f : generatedV5MemberFunction) {
                Integer so = f.getSolveOrder();
                int newSO = solveOrder;
                if (so != null) {
                    newSO += so.intValue();
                }
                f.setSolveOrder(newSO);
            }
        }
    }

    private void addMemberFunction(V5EdgeGroup v5Grp, IXQENodeFactory nodeFactory, List<V5MemberFunction> rt) {
        if (v5Grp.getNumberChildren() == 0) {
            return;
        }
        V5ValueSet valueset = (V5ValueSet)v5Grp.getChild(0);
        IXQEQueryNode expression = valueset.getChild(0);
        if (expression.getType() == 201101 && expression.getNumberChildren() == 1) {
            IXQEQueryNode setChild = expression.getChild(0);
            IXQEQueryNode v5Tuple = nodeFactory.createNode(201110);
            setChild.insertParent(v5Tuple);
            IXQEQueryNode v5Value = nodeFactory.createNode(201113);
            v5Tuple.insertParent(v5Value);
            RSAPIDataItem rsapiDataItem = valueset.getRSAPIDataItem();
            int solveOrder = rsapiDataItem.getSolveOrder();
            V5MemberFunction v5Member = (V5MemberFunction)nodeFactory.createNode(201085);
            if (solveOrder != 0) {
                v5Member.setSolveOrder(solveOrder);
            }
            v5Value.insertParent(v5Member);
            String mun = null;
            String caption = null;
            if (setChild.getType() == 201116) {
                V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)setChild;
                IMetadata metadata = modelIdentifier.getMetadata();
                if (metadata instanceof V5DataItemToMeasureWrapper) {
                    mun = null;
                    caption = metadata.getCaption();
                } else {
                    mun = metadata.getV5UniqueName();
                    caption = metadata.getCaption();
                }
            }
            if (setChild.getType() == 201085) {
                V5MemberFunction calcMember = (V5MemberFunction)setChild;
                rt.add(v5Member);
                rt.add(calcMember);
                if (calcMember.isQueryCalculation()) {
                    v5Member.setIsQueryCalculation();
                }
                if (calcMember.getNumberChildren() >= 2) {
                    V5LiteralValue munLiteral = (V5LiteralValue)setChild.getChild(1);
                    mun = munLiteral.getValue().getString();
                } else {
                    mun = null;
                }
                if (calcMember.getNumberChildren() >= 3) {
                    V5LiteralValue captionLiteral = (V5LiteralValue)setChild.getChild(2);
                    caption = captionLiteral.getValue().getString();
                } else {
                    caption = null;
                }
            }
            if (mun == null && caption != null) {
                mun = "";
            }
            if (mun != null) {
                V5LiteralValue munV = (V5LiteralValue)nodeFactory.createNode(201026);
                munV.setDataType(DataTypeFactory.getVarcharType(mun.length()));
                munV.setValue(mun);
                v5Member.addChild(munV);
            }
            if (caption != null) {
                V5LiteralValue capV = (V5LiteralValue)nodeFactory.createNode(201026);
                capV.setDataType(DataTypeFactory.getVarcharType(caption.length()));
                capV.setValue(caption);
                v5Member.addChild(capV);
            }
            V5EdgeGroup ancestorGroup = (V5EdgeGroup)v5Grp.getAncestorOfType(101050);
            V5ValueSet ancestorValueset = null;
            if (ancestorGroup != null) {
                ancestorValueset = (V5ValueSet)ancestorGroup.getChild(0);
            }
            if (ancestorValueset != null && Boolean.TRUE.equals(ancestorValueset.getBooleanPropertyValue(WRAPPED_MEASURE))) {
                v5Grp.setPropertyHierarchy(ancestorGroup.getPropertyHierarchy());
            } else {
                v5Grp.setPropertyHierarchy(AbstractV5ValueExpression.getShellHierarchy(v5Member));
            }
            valueset.setPropertyValue(WRAPPED_MEASURE, true);
        }
    }
}

