/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class PropagateROLAPRelativeTimeMember
extends Transformation {
    public PropagateROLAPRelativeTimeMember() {
        this.mName = "Propagate all ROLAP Relative Time Calculations to MDXQuery.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        IXQEQueryNode[] relativeTimeMemberList = v5Query.getChildrenOfType(101078);
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode n : relativeTimeMemberList) {
            IXQEQueryNode relativeTimeMember = factory.createNode(1187);
            relativeTimeMember.addChild(factory.deepCopyNode(n.getChild(0)));
            node.addChild(relativeTimeMember);
            relativeTimeMember.setPropertyValue("externalMun", n.getPropertyValue("externalMun"));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getFirstChildByType(1187) != null) {
            this.traceQueryCondition(false, "All nodes have already been propagated.", trace);
            return false;
        }
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        if (v5Query == null || v5Query.getFirstChildByType(101078) == null) {
            this.traceQueryCondition(false, "The V5Query does not have a ROLAP relative time calculation.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5Query has ROLAP relative time calculations specified.", trace);
        return true;
    }
}

