/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RemoveV5DataItem
extends AbstractV5ToCogMDXTransformation {
    public RemoveV5DataItem() {
        this.mName = "Remove V5DataItem nodes from the QRD.";
        this.mPassNumbers = new int[]{4, 8};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        this.transferAppliedTo((V5DataItem)node);
        this.transferDynamicScopedTo((V5DataItem)node);
        node.extract();
    }

    protected void transferAppliedTo(V5DataItem node) {
        String applyTo = (String)node.getPropertyValue("applyToDSQS");
        if (applyTo == null) {
            return;
        }
        List<IXQEQueryNode> nodes = node.getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode n : nodes) {
            n.setPropertyValue("applyToDSQS", applyTo);
        }
    }

    protected void transferDynamicScopedTo(V5DataItem node) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            return;
        }
        V5Query v5query = mdxQuery.getRefV5Query();
        if (v5query == null) {
            return;
        }
        Map dynamicScopedTo = (Map)v5query.getPropertyValue("DynamicScopedTo");
        if (dynamicScopedTo == null) {
            return;
        }
        String name = node.getNameProperty();
        if (dynamicScopedTo.containsKey(name)) {
            IXQEQueryNode[] nodes;
            for (IXQEQueryNode n : nodes = node.getDescendantsOfType(201116, false)) {
                V5BoundModelIdentifier id = (V5BoundModelIdentifier)n;
                if (!id.isMeasure()) continue;
                id.setPropertyValue("DynamicScopedTo", name);
            }
        } else {
            for (Map st : dynamicScopedTo.values()) {
                for (Pair pr : st.values()) {
                    Set incl = (Set)pr.getFirst();
                    Set excl = (Set)pr.getSecond();
                    if (!this.containsDataItemName(name, incl) && !this.containsDataItemName(name, excl)) continue;
                    List<IXQEQueryNode> nodes = node.getDescendantsOfCategory(201029, false);
                    for (IXQEQueryNode n : nodes) {
                        V5BoundToMetadata metaNode = (V5BoundToMetadata)n;
                        IHierarchy hier = V5BoundModelIdentifier.getHierarchyFromIMetadata(metaNode.getMetadata());
                        if (hier == null || hier.getDimension().isMeasuresDimension()) continue;
                        metaNode.setPropertyValue("DynamicScopedTo", name);
                    }
                    return;
                }
            }
        }
    }

    private boolean containsDataItemName(String diName, Set<Pair> s) {
        for (Pair p : s) {
            if (!diName.equals(p.getFirst())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        if (dataItem.getSolveOrderProperty() != null) {
            this.traceNodeCondition(false, "The data item has a solveOrder property.", trace);
            return false;
        }
        if (dataItem.getRollupAggregateProperty() != null) {
            this.traceNodeCondition(false, "The data item has a rollupAggregate property.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item can be collapsed.", trace);
        return true;
    }
}

