/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;
import java.util.Locale;

public final class SetSuppressNullsOnMDXQuery
extends Transformation {
    public static final String PROP_STRING_NULLS = "nulls";
    public static final String PROP_STRING_NONE = "none";

    public SetSuppressNullsOnMDXQuery() {
        this.mName = "Set Suppress Nulls to the MDX Query based on V5 query hint, governor and capacity file.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        String suppress = (String)v5Query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName());
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (capabilities.isSupported("v5.suppress.queryhint.ignore")) {
            suppress = null;
        }
        boolean supressNullsEqualNone = false;
        boolean supressNullsEqualNulls = false;
        if (PROP_STRING_NULLS.equalsIgnoreCase(suppress)) {
            mdxQuery.setSuppressNulls(Boolean.TRUE);
            supressNullsEqualNulls = true;
        } else if (PROP_STRING_NONE.equalsIgnoreCase(suppress)) {
            supressNullsEqualNone = true;
            mdxQuery.setSuppressNulls(Boolean.FALSE);
        } else if ("BW".equals(mdxQuery.getDataSourceType()) && mdxQuery.getGovernors().getSuppress() == Governors.Suppress.NULLS) {
            supressNullsEqualNulls = true;
            mdxQuery.setSuppressNulls(Boolean.TRUE);
        } else if ("BW".equals(mdxQuery.getDataSourceType()) && mdxQuery.getGovernors().getSuppress() == Governors.Suppress.NONE) {
            supressNullsEqualNone = true;
            mdxQuery.setSuppressNulls(Boolean.FALSE);
        } else {
            mdxQuery.setSuppressNulls(mdxQuery.getSuppressNullsProviderDefault());
        }
        if (((RequestEnvironment)environment.getRequestEnvironment()).getMigrationBaseVersion() == RequestEnvironment.MigrationBaseVersionEnum.COMPATIBLE && mdxQuery.isDMR()) {
            Locale locale = XQEMessages.getCurrProductLocale();
            IMessageKey.Param1 messageKey = null;
            if (supressNullsEqualNone) {
                messageKey = XQEMessageKeys.MIG_SuppressNullsEqualNone;
            } else if (supressNullsEqualNulls) {
                messageKey = XQEMessageKeys.MIG_SuppressNullsEqualNulls;
            }
            String message = XQEMessages.getMessage(messageKey, locale, refQueryName);
            ((ExecutionEnvironment)environment.getExecutionEnvironment()).addMigrateNag(message);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getPropertyValue("suppressNulls") != null) {
            this.traceQueryCondition(false, "The suppress nulls has been set on the target MDXQuery node.", trace);
            return false;
        }
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        String suppress = (String)v5Query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName());
        if (PROP_STRING_NULLS.equalsIgnoreCase(suppress)) {
            this.traceQueryCondition(true, "V5 query hint specifies null suppression.", trace);
            return true;
        }
        if (PROP_STRING_NONE.equalsIgnoreCase(suppress)) {
            this.traceQueryCondition(true, "V5 query hint specifies no null suppression.", trace);
            return true;
        }
        if (mdxQuery.isListReport() && "BW".equals(mdxQuery.getDataSourceType())) {
            if (mdxQuery.getGovernors().getSuppress() == Governors.Suppress.NONE) {
                this.traceQueryCondition(true, "SAP null suppression is turned off in governor.", trace);
                return true;
            }
            if (mdxQuery.getGovernors().getSuppress() == Governors.Suppress.NULLS) {
                this.traceQueryCondition(true, "SAP null suppression is turned on in governor.", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "Suppress nulls is not requested for the target MDXQuery.", trace);
        return false;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "suppress");
        trace.endElement();
    }
}

