/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public class UpdateBoundHierarchyToLevels
extends Transformation {
    public UpdateBoundHierarchyToLevels() {
        this.mName = "Update bound hierarchy with levels.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        IXQEQueryNode filterExpression = detailFilter.getChild(0);
        UpdateBoundHierarchyToLevels.updateBoundHierarchyToLevels(nodeFactory, node, filterExpression);
    }

    public static void updateBoundHierarchyToLevels(IXQENodeFactory nodeFactory, IXQEQueryNode node, IXQEQueryNode filterExpression) {
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 201086) {
            parentNode.extract();
        }
        V5BoundModelIdentifier boundId = (V5BoundModelIdentifier)node;
        IHierarchy hierarchy = (IHierarchy)boundId.getMetadata();
        ArrayList<IXQEQueryNode> levelFilterExpressions = new ArrayList<IXQEQueryNode>();
        for (ILevel level : hierarchy.getLevels()) {
            IXQEQueryNode[] boundIds;
            IXQEQueryNode[] boundMUNs;
            IXQEQueryNode expressionCopy = nodeFactory.deepCopyNode(filterExpression);
            for (IXQEQueryNode childNode : boundMUNs = expressionCopy.getDescendantsOfType(201117, false)) {
                V5BoundMemberUniqueName copyMUN = (V5BoundMemberUniqueName)childNode;
                if (copyMUN.getMetadata() == level) continue;
                copyMUN.detach();
            }
            if (expressionCopy.getDescendantsOfType(201117, false).length == 0) continue;
            for (IXQEQueryNode childNode : boundIds = expressionCopy.getDescendantsOfType(201116, false)) {
                V5BoundModelIdentifier copyBoundId = (V5BoundModelIdentifier)childNode;
                if (copyBoundId.getMetadata() != hierarchy) continue;
                copyBoundId.setMetadata(level);
                break;
            }
            levelFilterExpressions.add(expressionCopy);
        }
        IXQEQueryNode newFilterExpression = null;
        if (levelFilterExpressions.size() > 1) {
            V5LogicalExpression orExpression = (V5LogicalExpression)nodeFactory.createNode(201003);
            orExpression.setSubType(1);
            orExpression.addChild((IXQEQueryNode)levelFilterExpressions.get(0));
            orExpression.addChild((IXQEQueryNode)levelFilterExpressions.get(1));
            for (int i = 2; i < levelFilterExpressions.size(); ++i) {
                V5LogicalExpression expr = (V5LogicalExpression)nodeFactory.createNode(201003);
                expr.setSubType(1);
                expr.addChild((IXQEQueryNode)levelFilterExpressions.get(i));
                expr.addChild(orExpression);
                orExpression = expr;
            }
            newFilterExpression = orExpression;
        } else {
            newFilterExpression = (IXQEQueryNode)levelFilterExpressions.get(0);
        }
        filterExpression.exchange(newFilterExpression);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IMetadata metadata;
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() && (metadata = ((V5BoundModelIdentifier)node).getMetadata()) != null && metadata instanceof HierarchyWrapper) {
            this.traceNodeCondition(true, "The bound identifier is for a hierarchy to be converted.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier do not need any conversion.", trace);
        return false;
    }
}

