/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.HashSet;

public class AddWarningForCalculatedMemberWithDiffHierarchySibling
extends AbstractV5ToCogMDXTransformation {
    private static final String APPLIED = "warningForDiffHierSiblingApplied";

    public AddWarningForCalculatedMemberWithDiffHierarchySibling() {
        this.mName = "Add warning for calculated members with siblings from a different hierarchy.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> context;
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)node;
        node.setPropertyValue(APPLIED, true);
        IHierarchy edgeGroupHierarchy = v5EdgeGroup.getEdgeGroupHierarchy();
        IXQEQueryNode[] edgeGroupSiblings = v5EdgeGroup.getParent().getChildrenOfType(101050);
        ArrayList<IXQEQueryNode> baseSiblings = new ArrayList<IXQEQueryNode>();
        HashSet<IHierarchy> siblingHierarchies = new HashSet<IHierarchy>();
        ArrayList<IXQEQueryNode> calcSiblings = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode sibling : edgeGroupSiblings) {
            IHierarchy currSiblingHierarchy;
            if (sibling.equals(v5EdgeGroup) || (currSiblingHierarchy = ((V5EdgeGroup)sibling).getEdgeGroupHierarchy()) == null || currSiblingHierarchy.isShell()) continue;
            if (this.isBaseMemberSet(sibling)) {
                if (edgeGroupHierarchy.equals(currSiblingHierarchy)) continue;
                siblingHierarchies.add(currSiblingHierarchy);
                baseSiblings.add(sibling);
                continue;
            }
            if (!this.isUserCalcMember(sibling) || currSiblingHierarchy.equals(edgeGroupHierarchy)) continue;
            calcSiblings.add(sibling);
        }
        if (baseSiblings.isEmpty()) {
            for (IXQEQueryNode calc : calcSiblings) {
                calc.setPropertyValue(APPLIED, true);
            }
            calcSiblings.add(node);
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_SameLevelNestingOfDifferentHierarchyCalculations, calcSiblings);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
        } else if (siblingHierarchies.size() == 1) {
            context = new ArrayList<IXQEQueryNode>();
            context.add(v5EdgeGroup);
            context.add((IXQEQueryNode)baseSiblings.get(0));
            IHierarchy baseHierarchy = ((V5EdgeGroup)baseSiblings.get(0)).getEdgeGroupHierarchy();
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_SameLevelNestingOfCalculationAndDifferentHierarchyMembers, edgeGroupHierarchy.toString(), baseHierarchy.toString(), context);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
        } else {
            context = new ArrayList();
            context.add(v5EdgeGroup);
            context.addAll(baseSiblings);
            XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_SameLevelNestingOfCalculationAndManyDiffHierarchyMembers, edgeGroupHierarchy.toString(), ((Object)siblingHierarchies).toString(), context);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)node;
        if (node.getPropertyValue(APPLIED) != null) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        IXQEQueryNode[] edgeGroupSiblings = v5EdgeGroup.getParent().getChildrenOfType(101050);
        if (edgeGroupSiblings.length < 2) {
            this.traceNodeCondition(false, "The EdgeGroup has no siblings.", trace);
            return false;
        }
        boolean v5UserCalcMember = this.isUserCalcMember(v5EdgeGroup);
        if (!v5UserCalcMember) {
            this.traceNodeCondition(false, "The EdgeGroup does not contain a single calculated member.", trace);
            return false;
        }
        IHierarchy edgeGroupHierarchy = v5EdgeGroup.getEdgeGroupHierarchy();
        if (v5EdgeGroup.getEdgeGroupHierarchy() == null || edgeGroupHierarchy.isShell()) {
            this.traceNodeCondition(false, "The EdgeGroup has no hierarchy.", trace);
            return false;
        }
        boolean hasBaseSiblingFromOtherHierarchy = false;
        boolean hasCalcSiblingFromOtherHierarchy = false;
        for (IXQEQueryNode sibling : edgeGroupSiblings) {
            IHierarchy currSiblingHierarchy;
            if (sibling.equals(v5EdgeGroup) || (currSiblingHierarchy = ((V5EdgeGroup)sibling).getEdgeGroupHierarchy()) == null || currSiblingHierarchy.isShell()) continue;
            if (this.isBaseMemberSet(sibling)) {
                if (edgeGroupHierarchy.equals(currSiblingHierarchy)) {
                    this.traceNodeCondition(false, "The EdgeGroup has a sibling from the same hierarchy", trace);
                    return false;
                }
                hasBaseSiblingFromOtherHierarchy = true;
                continue;
            }
            if (this.isUserCalcMember(sibling)) {
                if (currSiblingHierarchy.equals(edgeGroupHierarchy)) continue;
                hasCalcSiblingFromOtherHierarchy = true;
                continue;
            }
            this.traceNodeCondition(false, "The EdgeGroup has complex siblings.", trace);
            return false;
        }
        if (hasBaseSiblingFromOtherHierarchy || hasCalcSiblingFromOtherHierarchy) {
            this.traceNodeCondition(false, "The EdgeGroup has siblings from a different hierarchy.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The EdgeGroup has no siblings from a different hierarchy.", trace);
        return false;
    }

    private boolean isUserCalcMember(IXQEQueryNode node) {
        if (node.getType() == 101050 || node.getType() == 101057) {
            return this.isUserCalcMember(node.getChild(0));
        }
        if (node.getType() == 201101) {
            if (node.getNumberChildren() != 1) {
                return false;
            }
            return this.isUserCalcMember(node.getChild(0));
        }
        if (node.getType() == 201085) {
            V5MemberFunction member = (V5MemberFunction)node;
            if (member.isQueryCalculation() || member.isPlannerV5MemberFn()) {
                return false;
            }
            return member.getChild(0).getType() != 201032;
        }
        return false;
    }

    private boolean isBaseMemberSet(IXQEQueryNode node) {
        if (node.getType() == 101050 || node.getType() == 101057) {
            return this.isBaseMemberSet(node.getChild(0));
        }
        if (node.getType() == 201085) {
            return false;
        }
        for (IXQEQueryNode child : node.getChildren()) {
            if (this.isBaseMemberSet(child)) continue;
            return false;
        }
        return true;
    }
}

