/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.HashSet;

public class InsertNACellUpdateDecoForWDNestDiffHierSiblings
extends AbstractV5ToCogMDXTransformation {
    public InsertNACellUpdateDecoForWDNestDiffHierSiblings() {
        this.mName = "Insert V5 result cell update decoration to force NA value.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{201039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5EdgeGroup matchingEdgeGroup;
        String refDataItemName;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node;
        V5ValueSet vs = (V5ValueSet)node.getAncestorOfType(101057);
        IXQEQueryNode matchingValueSet = V5ToCogMDXUtilities.getReferencedSiblingOfType(101057, vs, refDataItemName = (String)withinClause.getPropertyValue("refDataItemName"), false);
        if (matchingValueSet != null && (matchingEdgeGroup = (V5EdgeGroup)((V5ValueSet)matchingValueSet).getAncestorOfType(101050)) != null && !this.checkChildHierarchies(matchingEdgeGroup)) {
            RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
            V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
            RSAPIDataItem v5RefDataItem = (RSAPIDataItem)valueSet.getPropertyValue("RSAPIRefDataItem");
            RSAPIEdge[] edges = rsapiDataset.getEdges();
            RSAPIEdgeRowset rsapiRowset = null;
            int dataItemId = -1;
            boolean foundIt = false;
            block0: for (int j = 0; j < edges.length && !foundIt; ++j) {
                RSAPIEdgeRowset[] rowsets = edges[j].getRowsets();
                block1: for (int i = 0; i < rowsets.length && !foundIt; ++i) {
                    dataItemId = -1;
                    rsapiRowset = rowsets[i];
                    RSAPIDataItem refDataItem = rsapiRowset.getRefDataItem();
                    if (refDataItem == v5RefDataItem) {
                        foundIt = true;
                        continue block0;
                    }
                    RSAPIDataItem[] dataItems = rsapiRowset.getDataItems();
                    for (dataItemId = 0; dataItemId < dataItems.length; ++dataItemId) {
                        if (dataItems[dataItemId] != v5RefDataItem) continue;
                        foundIt = true;
                        continue block1;
                    }
                }
            }
            V5ResultCellUpdate cellUpdateNode = null;
            int descendantType = 601014;
            IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(descendantType, false);
            if (nodeCellUpdate.length == 0) {
                cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
                rsapiDataset.getChild(0).insertParent(cellUpdateNode);
            } else {
                cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
            }
            String v5Name = null;
            V5MemberFunction v5MemberFunction = (V5MemberFunction)node.getFirstChildByType(201085);
            if (v5MemberFunction != null) {
                if (v5MemberFunction.getNumberChildren() > 1) {
                    Value name = ((V5LiteralValue)v5MemberFunction.getChild(1)).getValue();
                    v5Name = name.getString();
                    if (v5MemberFunction.isQueryCalculation()) {
                        if (v5MemberFunction.getNumberChildren() > 2) {
                            name = ((V5LiteralValue)v5MemberFunction.getChild(2)).getValue();
                            v5Name = name.getString();
                        } else {
                            v5Name = null;
                        }
                    }
                }
                if (v5Name == null || v5Name.length() == 0) {
                    node.throwInternalError("Unexpected parameters for V5MemberFunction");
                }
            }
            int rowSetId = rsapiRowset.getRowsetId();
            int edgeOrdinal = rsapiRowset.getEdge().getPositionalOrdinal();
            XV5CellSpec nodeCellSpec = new XV5CellSpec(edgeOrdinal, rowSetId, dataItemId, v5Name);
            AbstractXV5CellUpdateRule cellUpdateRule = new AbstractXV5CellUpdateRule(nodeCellSpec){

                @Override
                public boolean apply(ICell cell) {
                    Value v = null;
                    v = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
                    v = (Value)v.copy();
                    v.setState(ValueState.NOT_APPLICABLE);
                    cell.setValue(v);
                    return true;
                }
            };
            cellUpdateNode.addCellUpdateRule(cellUpdateRule);
            HashSet<RSAPIEdgeRowset> contextRowsets = new HashSet<RSAPIEdgeRowset>();
            V5ToCogMDXUtilities.collectSubTree(rsapiRowset, contextRowsets);
            for (int j = 0; j < edges.length; ++j) {
                RSAPIEdgeRowset[] rowsets = edges[j].getRowsets();
                for (int i = 0; i < rowsets.length; ++i) {
                    rsapiRowset = rowsets[i];
                    int edgeOrdinalCurrent = rsapiRowset.getEdge().getPositionalOrdinal();
                    if (edgeOrdinalCurrent == edgeOrdinal && !contextRowsets.contains(rsapiRowset)) continue;
                    RSAPIDataItem refDataItem = rsapiRowset.getRefDataItem();
                    int ordinal = rsapiRowset.getDataItemOrdinal(refDataItem);
                    nodeCellSpec = new XV5CellSpec(edgeOrdinalCurrent, rsapiRowset.getRowsetId(), ordinal, null);
                    cellUpdateRule.addIntersectingCellSpec(nodeCellSpec);
                    RSAPIDataItem[] dataItems = rsapiRowset.getDataItems();
                    for (int k = 0; k < dataItems.length; ++k) {
                        nodeCellSpec = new XV5CellSpec(edgeOrdinalCurrent, rsapiRowset.getRowsetId(), k, null);
                        cellUpdateRule.addIntersectingCellSpec(nodeCellSpec);
                    }
                }
            }
        }
        node.setPropertyValue("errorCellUpdateDecoApplied", Boolean.TRUE);
    }

    private boolean checkChildHierarchies(V5EdgeGroup edgeGroup) {
        IXQEQueryNode[] children;
        MDXHierInfo firstValueSetHierInfo = null;
        MDXHierInfo nextValueSetHierInfo = null;
        MDXHierInfo firstEdgeGroupHierInfo = null;
        MDXHierInfo nextEdgeGroupHierInfo = null;
        for (IXQEQueryNode child : children = edgeGroup.getChildren()) {
            V5QueryNode childNode = (V5QueryNode)child;
            if (childNode.getType() == 101057) {
                nextValueSetHierInfo = ((V5ValueSet)childNode).getHierarchyInfo();
                if (firstValueSetHierInfo == null) {
                    firstValueSetHierInfo = nextValueSetHierInfo;
                    continue;
                }
                if (firstValueSetHierInfo.isBalancedAndEquivalentHierarchies(nextValueSetHierInfo, false)) continue;
                return false;
            }
            if (childNode.getType() != 101050) continue;
            if (!this.checkChildHierarchies((V5EdgeGroup)childNode)) {
                return false;
            }
            if ((childNode = (V5QueryNode)childNode.getChild(0)).getType() != 101057) continue;
            if (!((V5ValueSet)childNode).checkHierarchies()) {
                return false;
            }
            nextEdgeGroupHierInfo = ((V5ValueSet)childNode).getHierarchyInfo();
            if (!(firstEdgeGroupHierInfo == null ? (firstEdgeGroupHierInfo = nextEdgeGroupHierInfo).getNumProjectedHierarchies() < 1 : !firstEdgeGroupHierInfo.isBalancedAndEquivalentHierarchies(nextEdgeGroupHierInfo, false))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue("errorCellUpdateDecoApplied");
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "Transformation InsertErrorCellUpdateDecorationForNoneRollup has been applied.", trace);
            return false;
        }
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        if (edge == null) {
            this.traceNodeCondition(false, "The node is not in V5Edge.", trace);
            return false;
        }
        MDXHierInfo patternHierInfo = edge.getPropertyPatternHierInfo();
        if (patternHierInfo == null) {
            this.traceNodeCondition(false, "The V5Edge patternHierInfo property has not been created yet for this node.", trace);
            return false;
        }
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node;
        if (withinClause.getWithinClauseType() == 1) {
            this.traceNodeCondition(true, "The item can be used for cell update decoration transformation.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The item can not be used for cell update decoration transformation.", trace);
        return false;
    }
}

