/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization.PatternHierInfoNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PatternHierResolver {
    V5Edge mOwner;
    PatternHierInfoNode mPatternHierInfoRoot = null;
    private HashMap<IHierarchy, ArrayList<PatternHierInfoNode>> mHierToNodes = new HashMap();
    private List<IHierarchy> mProjectedHierarchies = new ArrayList<IHierarchy>();

    public PatternHierInfoNode getPatternHierInfoRoot() {
        return this.mPatternHierInfoRoot;
    }

    public PatternHierResolver(V5Edge edge) {
        this.mOwner = edge;
        this.mPatternHierInfoRoot = new PatternHierInfoNode();
        this.mPatternHierInfoRoot.setParent(null);
    }

    public void buildTree(IXQEQueryNode node, PatternHierInfoNode parentTreeNode, IHierarchy parentHier) {
        IXQEQueryNode[] v5EdgeGroups = node.getChildrenOfTypeOrdered(101050);
        HashMap<IHierarchy, List<V5SimpleNode>> hierarchyToExprssionMap = new HashMap<IHierarchy, List<V5SimpleNode>>();
        for (int i = 0; i < v5EdgeGroups.length; ++i) {
            V5EdgeGroup v5Grp = (V5EdgeGroup)v5EdgeGroups[i];
            if (v5Grp.isDetailGroup()) {
                this.checkUnsupportedGroupingOnDetailHierarchy(hierarchyToExprssionMap, v5Grp, parentHier);
                continue;
            }
            IHierarchy hier = v5Grp.getPropertyHierarchy();
            if (hier == null) continue;
            if (!this.mProjectedHierarchies.contains(hier)) {
                Boolean add = true;
                for (IHierarchy h : this.mProjectedHierarchies) {
                    if (!h.equals(hier)) continue;
                    add = false;
                    break;
                }
                if (add.booleanValue()) {
                    this.mProjectedHierarchies.add(hier);
                    V5SimpleNode[] projectedExpressions = v5Grp.getProjectedExpressions(1);
                    ArrayList<V5SimpleNode> expressions = (ArrayList<V5SimpleNode>)hierarchyToExprssionMap.get(hier);
                    if (expressions == null) {
                        expressions = new ArrayList<V5SimpleNode>();
                    }
                    expressions.add(projectedExpressions[0]);
                    hierarchyToExprssionMap.put(hier, expressions);
                }
            }
            if (hier.equals(parentHier)) {
                parentTreeNode.addV5EdgeGroup(v5Grp);
                this.buildTree(v5Grp, parentTreeNode, parentHier);
                continue;
            }
            PatternHierInfoNode aTreeNode = new PatternHierInfoNode();
            aTreeNode.setHierarchy(hier);
            aTreeNode.addV5EdgeGroup(v5Grp);
            parentTreeNode.addChild(aTreeNode);
            this.buildTree(v5Grp, aTreeNode, hier);
            if (aTreeNode.getHierarchy().isShell()) continue;
            ArrayList<Object> ls = null;
            if (this.mHierToNodes.containsKey(aTreeNode.getHierarchy())) {
                ls = this.mHierToNodes.get(aTreeNode.getHierarchy());
            } else {
                ls = new ArrayList();
                this.mHierToNodes.put(aTreeNode.getHierarchy(), ls);
            }
            ls.add(aTreeNode);
        }
    }

    private void checkUnsupportedGroupingOnDetailHierarchy(Map<IHierarchy, List<V5SimpleNode>> hierarchyToExprssionMap, V5EdgeGroup v5Grp, IHierarchy parentHier) {
        if (parentHier == null) {
            return;
        }
        IXQEQueryNode[] detailDataItemRefs = v5Grp.getDescendantsOfType(101015, false);
        ArrayList<IHierarchy> detailDataItemHierarchies = new ArrayList<IHierarchy>();
        for (IXQEQueryNode currDetail : detailDataItemRefs) {
            V5EdgeGroup parentGroup;
            MetadataType ancestorValueSetMetadataType;
            IMetadata ancestorValueSetMetadata;
            V5SimpleNode ancestorValueSetExpression;
            IXQEQueryNode ancestorV5EdgeGroup;
            V5EdgeGroup ancestorGroup;
            V5ValueSet ancestorValueSet;
            IHierarchy currDetailHier;
            V5DataItemRef detailDataItemRef = (V5DataItemRef)currDetail;
            MDXHierInfo currDetailHierInfo = ((V5SimpleNode)detailDataItemRef.getChild(0)).getHierarchyInfo();
            if (currDetailHierInfo.getProjectedHierarchies().isEmpty() || detailDataItemHierarchies.contains(currDetailHier = currDetailHierInfo.getProjectedHierarchies().get(0))) continue;
            detailDataItemHierarchies.add(currDetailHier);
            if (parentHier.getUniqueName().equals(currDetailHier.getUniqueName()) || !this.mProjectedHierarchies.contains(currDetailHier)) continue;
            V5SimpleNode detailDataItemRefExpression = (V5SimpleNode)detailDataItemRef.getChild(0);
            IMetadata detailDataItemRefMetadata = detailDataItemRefExpression.getMetadata();
            MetadataType detailDataItemRefMetadataType = detailDataItemRefMetadata.getObjectType();
            IXQEQueryNode[] ancestorV5EdgeGroups = detailDataItemRef.getParent().getAncestorsOfType(101050);
            boolean canAssociateMetadata = false;
            IXQEQueryNode[] iXQEQueryNodeArray = ancestorV5EdgeGroups;
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; !(i >= n || (ancestorValueSet = (V5ValueSet)(ancestorGroup = (V5EdgeGroup)(ancestorV5EdgeGroup = iXQEQueryNodeArray[i])).getChild(0)).getChild(0).isOfCategory(201120) && (canAssociateMetadata = this.canAssociateMetadata(detailDataItemRefExpression, detailDataItemRefMetadata, detailDataItemRefMetadataType, ancestorValueSetExpression = (V5SimpleNode)ancestorValueSet.getChild(0), ancestorValueSetMetadata = ancestorValueSetExpression.getMetadata(), ancestorValueSetMetadataType = ancestorValueSetMetadata.getObjectType()))); ++i) {
            }
            if (canAssociateMetadata) continue;
            MDXQuery mdxQuery = (MDXQuery)v5Grp.getAncestorOfType(1002);
            String dataItemName = detailDataItemRef.getDataItemRefProperty();
            for (parentGroup = (V5EdgeGroup)v5Grp.getAncestorOfType(101050); parentGroup != null && !currDetailHier.equals(parentGroup.getPropertyHierarchy()); parentGroup = (V5EdgeGroup)parentGroup.getAncestorOfType(101050)) {
            }
            V5ValueSet ancestorVS = (V5ValueSet)parentGroup.getFirstChildByType(101057);
            String ancestorDataItemName = ancestorVS.getRefDataItemProperty();
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidHierarchyDistributionOnEdge, currDetailHier.getName(), (Object)ancestorDataItemName, (Object)dataItemName, (Object)mdxQuery.getRefQueryProperty());
        }
    }

    private boolean canAssociateMetadata(V5SimpleNode detailDataItemRefExpression, IMetadata detailDataItemRefMetadata, MetadataType detailDataItemRefMetadataType, V5SimpleNode ancestorValueSetExpression, IMetadata ancestorValueSetMetadata, MetadataType ancestorValueSetMetadataType) {
        boolean canAssociateMetadatas = false;
        if (detailDataItemRefMetadataType == MetadataType.PROPERTY) {
            if (ancestorValueSetMetadataType == MetadataType.PROPERTY) {
                canAssociateMetadatas = ancestorValueSetMetadata.equals(detailDataItemRefMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.LEVEL) {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(ancestorValueSetMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "attribute") {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(((IProperty)ancestorValueSetMetadata).getLevel());
            } else if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "identifier") {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(((IProperty)ancestorValueSetMetadata).getLevel());
            }
        } else if (detailDataItemRefMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)detailDataItemRefMetadata).getUsage() == "attribute") {
            if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "attribute") {
                canAssociateMetadatas = ancestorValueSetMetadata.equals(detailDataItemRefMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "identifier") {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(((IProperty)ancestorValueSetMetadata).getLevel());
            } else if (ancestorValueSetMetadataType == MetadataType.LEVEL) {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(ancestorValueSetMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.PROPERTY) {
                canAssociateMetadatas = ((IProperty)detailDataItemRefMetadata).getLevel().equals(((IProperty)ancestorValueSetMetadata).getLevel());
            }
        } else if (detailDataItemRefMetadataType == MetadataType.LEVEL) {
            if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "attribute") {
                canAssociateMetadatas = ((IProperty)ancestorValueSetMetadata).getLevel().equals(detailDataItemRefMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.QUERY_ITEM && ((IQueryItem)ancestorValueSetMetadata).getUsage() == "identifier") {
                canAssociateMetadatas = ((IProperty)ancestorValueSetMetadata).getLevel().equals(detailDataItemRefMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.PROPERTY) {
                canAssociateMetadatas = ((IProperty)ancestorValueSetMetadata).getLevel().equals(detailDataItemRefMetadata);
            } else if (ancestorValueSetMetadataType == MetadataType.LEVEL) {
                canAssociateMetadatas = ancestorValueSetExpression.isSameExpression(detailDataItemRefExpression, false);
            }
        }
        return canAssociateMetadatas;
    }

    public void refineTree(V5Edge v5Edge) {
        ArrayList<ArrayList<PatternHierInfoNode>> patternHierInfoPerHier = new ArrayList<ArrayList<PatternHierInfoNode>>();
        for (IHierarchy hierarchy : this.mProjectedHierarchies) {
            ArrayList<PatternHierInfoNode> patternHierInfos;
            if (hierarchy.isShell() || (patternHierInfos = this.mHierToNodes.get(hierarchy)).size() <= 1) continue;
            patternHierInfoPerHier.add(patternHierInfos);
        }
        while (!patternHierInfoPerHier.isEmpty()) {
            ArrayList<PatternHierInfoNode> patternHierInfos = this.getPatternHierInfosForMaxDepth(patternHierInfoPerHier);
            int[] maxDepthIdx = new int[1];
            this.getMaxDepth(patternHierInfos, maxDepthIdx);
            PatternHierInfoNode target = patternHierInfos.get(maxDepthIdx[0]);
            for (PatternHierInfoNode curr : patternHierInfos) {
                if (curr == target) continue;
                target.merge(curr, v5Edge);
            }
        }
        ArrayList<PatternHierInfoNode> rootNodes = new ArrayList<PatternHierInfoNode>();
        rootNodes.add(this.getPatternHierInfoRoot());
        int currDepth = 1;
        while (true) {
            ArrayList<PatternHierInfoNode> nodesForCurrDepth = new ArrayList<PatternHierInfoNode>();
            for (PatternHierInfoNode currRootNode : rootNodes) {
                nodesForCurrDepth.addAll(currRootNode.getPatternHierInfoNodesAtDepth(currDepth));
            }
            if (nodesForCurrDepth.isEmpty()) break;
            this.handleShellHierarchyAtDepth(currDepth, nodesForCurrDepth, v5Edge);
            rootNodes.clear();
            rootNodes.addAll(nodesForCurrDepth);
            ++currDepth;
        }
    }

    private void handleShellHierarchyAtDepth(Integer depth, ArrayList<PatternHierInfoNode> patternHierInfoForDepth, V5Edge v5Edge) {
        ArrayList<PatternHierInfoNode> forDelete = new ArrayList<PatternHierInfoNode>();
        PatternHierInfoNode previousParent = null;
        PatternHierInfoNode previousShell = null;
        for (PatternHierInfoNode currPatternHierInfo : patternHierInfoForDepth) {
            boolean needsMerging = false;
            if (!currPatternHierInfo.getHierarchy().isShell()) continue;
            this.resetDepth(currPatternHierInfo, depth);
            if (previousParent != currPatternHierInfo.getParent()) {
                previousParent = currPatternHierInfo.getParent();
                if (previousShell != null && currPatternHierInfo.getParent().getHierarchy() == null) {
                    forDelete.add(currPatternHierInfo);
                    needsMerging = currPatternHierInfo.getNumChildren() > 0 && currPatternHierInfo.getNumChildren() != currPatternHierInfo.getNumShellChildren();
                }
            } else {
                forDelete.add(currPatternHierInfo);
                boolean bl = needsMerging = currPatternHierInfo.getNumChildren() > 0 && currPatternHierInfo.getNumChildren() != currPatternHierInfo.getNumShellChildren();
            }
            if (needsMerging) {
                PatternHierInfoNode targetNode = previousShell;
                while (targetNode.getNumChildren() != 0) {
                    if (targetNode.getNumChildren() > 1) {
                        for (PatternHierInfoNode currChild : targetNode.getChildren()) {
                            if (currChild.getNumChildren() == 0) continue;
                            Integer edgeId = v5Edge.getEdgeID();
                            throw new XQERuntimeException(XQEMessageKeys.PLN_FailToCreateV5EdgePatternHierInfo, edgeId.toString());
                        }
                        break;
                    }
                    targetNode = targetNode.getChildren().get(0);
                }
                targetNode.merge(currPatternHierInfo, v5Edge);
            }
            if (forDelete.contains(currPatternHierInfo)) continue;
            previousShell = currPatternHierInfo;
        }
        for (PatternHierInfoNode currNode : forDelete) {
            PatternHierInfoNode parentNode = currNode.getParent();
            if (parentNode == null) continue;
            parentNode.removeChild(currNode);
        }
    }

    private ArrayList<PatternHierInfoNode> getPatternHierInfosForMaxDepth(ArrayList<ArrayList<PatternHierInfoNode>> patternHierInfoPerHier) {
        int maxDepths = -1;
        int maxDepthIdx = -1;
        for (int i = 0; i < patternHierInfoPerHier.size(); ++i) {
            int depth = this.getMaxDepth(patternHierInfoPerHier.get(i), null);
            if (depth <= maxDepths) continue;
            maxDepths = depth;
            maxDepthIdx = i;
        }
        ArrayList<PatternHierInfoNode> ls = patternHierInfoPerHier.get(maxDepthIdx);
        patternHierInfoPerHier.remove(maxDepthIdx);
        return ls;
    }

    private int getMaxDepth(ArrayList<PatternHierInfoNode> patternHierInfos, int[] maxDepthIdx) {
        int maxDepths = -1;
        int i = 0;
        int d = 0;
        for (i = 0; i < patternHierInfos.size(); ++i) {
            d = patternHierInfos.get(i).getDepth();
            if (d <= maxDepths) continue;
            maxDepths = d;
        }
        if (maxDepthIdx != null) {
            int maxParentDepths = -1;
            for (i = 0; i < patternHierInfos.size(); ++i) {
                d = patternHierInfos.get(i).getDepth();
                if (d != maxDepths) continue;
                int parenDepths = 0;
                for (PatternHierInfoNode parent = patternHierInfos.get(i).getParent(); parent != null && parent.getHierarchy() != null; parent = parent.getParent()) {
                    IHierarchy hier = parent.getHierarchy();
                    if (!this.mHierToNodes.containsKey(hier)) continue;
                    ArrayList<PatternHierInfoNode> nodes = this.mHierToNodes.get(parent.getHierarchy());
                    int hierarchyDepth = -1;
                    for (PatternHierInfoNode node : nodes) {
                        if (hierarchyDepth != -1 && node.getDepth() <= hierarchyDepth) continue;
                        hierarchyDepth = node.getDepth();
                    }
                    parenDepths += hierarchyDepth;
                }
                if (maxParentDepths != -1 && maxParentDepths >= parenDepths) continue;
                maxParentDepths = parenDepths;
                maxDepthIdx[0] = i;
            }
        }
        return maxDepths;
    }

    public List<IHierarchy> getPatternHierarchiesAtDepths(int depth, List<PatternHierInfoNode> patternHierInfoNodesAboveDepth) {
        ArrayList<IHierarchy> patternHierarchies = new ArrayList<IHierarchy>();
        ArrayList<IHierarchy> hierarchiesAboveDepth = new ArrayList<IHierarchy>();
        ArrayList<IHierarchy> hierarchiesAtDepth = new ArrayList<IHierarchy>();
        ArrayList<PatternHierInfoNode> nodesAtDepth = new ArrayList<PatternHierInfoNode>();
        for (PatternHierInfoNode currNodeAboveDepth : patternHierInfoNodesAboveDepth) {
            if (currNodeAboveDepth.getHierarchy() != null) {
                hierarchiesAboveDepth.add(currNodeAboveDepth.getHierarchy());
            }
            currNodeAboveDepth.getPatternHierInfoNodesAtDepth(depth, nodesAtDepth, hierarchiesAtDepth);
        }
        block1: for (IHierarchy currHierAtDepth1 : hierarchiesAtDepth) {
            if (!currHierAtDepth1.isShell()) {
                patternHierarchies.add(currHierAtDepth1);
                continue;
            }
            boolean justShellAtDepth = true;
            for (IHierarchy currHierAtDepth2 : hierarchiesAtDepth) {
                if (currHierAtDepth2.equals(currHierAtDepth1)) continue;
                justShellAtDepth = false;
                break;
            }
            if (justShellAtDepth && hierarchiesAtDepth.size() == patternHierInfoNodesAboveDepth.size()) {
                patternHierarchies.addAll(hierarchiesAtDepth);
                break;
            }
            if (!justShellAtDepth) continue;
            int numShell = 0;
            int numNonShell = 0;
            for (IHierarchy currHierAboveDepth : hierarchiesAboveDepth) {
                if (currHierAboveDepth.isShell()) {
                    ++numShell;
                } else {
                    ++numNonShell;
                }
                if (numShell > 0 && numNonShell > 0) {
                    patternHierarchies.add(currHierAtDepth1);
                    continue block1;
                }
                if (numShell != 0 || numNonShell <= 0) continue;
                patternHierarchies.add(currHierAtDepth1);
                continue block1;
            }
        }
        patternHierInfoNodesAboveDepth.clear();
        patternHierInfoNodesAboveDepth.addAll(nodesAtDepth);
        return patternHierarchies;
    }

    private void resetDepth(PatternHierInfoNode node, Integer depth) {
        String newName;
        String oldName = node.getHierarchy().getName();
        if (!oldName.equals(newName = MDXQuery.getShellHierarchyName(this.mOwner, depth))) {
            MDXQuery mdxQuery = (MDXQuery)this.mOwner.getAncestorOfType(1002);
            IHierarchy newHier = mdxQuery.getShellHierarchy(newName, depth);
            node.setHierarchy(newHier);
            node.setDepth(depth);
            for (int i = 0; i < node.getNumV5EdgeGroups(); ++i) {
                node.getV5EdgeGroup(i).setPropertyHierarchy(newHier);
            }
        }
    }
}

