/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5UnionFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.List;

public final class NormalizeCalculatedMemberGroups
extends AbstractV5ToCogMDXTransformation {
    public NormalizeCalculatedMemberGroups() {
        this.mName = "Normalize calculated member edge groups.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{201101, 201111};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode valueSet = node.getParent();
        IXQEQueryNode edgeGroup = valueSet.getParent();
        ArrayList<IXQEQueryNode> nestedEdgeGroups = new ArrayList<IXQEQueryNode>();
        for (int idx = 1; idx < edgeGroup.getNumberChildren(); ++idx) {
            nestedEdgeGroups.add(edgeGroup.getChild(idx));
        }
        ArrayList<IXQEQueryNode> newEdgeGroups = new ArrayList<IXQEQueryNode>();
        this.splitSetIntoEdgeGroups(nodeFactory, node, valueSet, nestedEdgeGroups, newEdgeGroups);
        IXQEQueryNode insertEdgeGroup = edgeGroup.getAncestorOfType(101050);
        if (insertEdgeGroup == null) {
            insertEdgeGroup = edgeGroup.getAncestorOfType(101049);
        }
        int edgeGroupPos = insertEdgeGroup.getPositionOfChild(edgeGroup) + 1;
        edgeGroup.exchange((IXQEQueryNode)newEdgeGroups.get(0), false);
        newEdgeGroups.remove(0);
        for (IXQEQueryNode newEdgeGroup : newEdgeGroups) {
            insertEdgeGroup.addChild(newEdgeGroup, edgeGroupPos);
            ++edgeGroupPos;
        }
    }

    private void splitSetIntoEdgeGroups(IXQENodeFactory nodeFactory, IXQEQueryNode setNode, IXQEQueryNode valueSet, List<IXQEQueryNode> nestedEdgeGroups, List<IXQEQueryNode> newEdgeGroups) {
        for (IXQEQueryNode child : setNode.getChildren()) {
            if (child.getNumberChildren() > 1 && (child.getType() == 201101 || child.getType() == 201111 && ((V5UnionFunction)child).getAll())) {
                this.splitSetIntoEdgeGroups(nodeFactory, child, valueSet, nestedEdgeGroups, newEdgeGroups);
                continue;
            }
            IXQEQueryNode newEdgeGroup = nodeFactory.createNode(101050);
            IXQEQueryNode valueSetCopy = nodeFactory.copyNode(valueSet);
            IXQEQueryNode childCopy = nodeFactory.deepCopyNode(child);
            if (setNode.getType() == 201101) {
                IXQEQueryNode setParent = nodeFactory.createNode(201101);
                childCopy.insertParent(setParent);
                childCopy = setParent;
            }
            valueSetCopy.addChild(childCopy);
            newEdgeGroup.addChild(valueSetCopy);
            for (IXQEQueryNode nestedEdgeGroup : nestedEdgeGroups) {
                IXQEQueryNode nestedEdgeGroupCopy = nodeFactory.deepCopyNode(nestedEdgeGroup);
                newEdgeGroup.addChild(nestedEdgeGroupCopy);
            }
            newEdgeGroups.add(newEdgeGroup);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] membersetRefs;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 101057) {
            this.traceQueryCondition(false, "The node is not a child of a V5ValueSet.", trace);
            return false;
        }
        IXQEQueryNode edgeGroup = parent.getParent();
        if (edgeGroup.getType() != 101050) {
            this.traceQueryCondition(false, "The node is not a grandchild of a V5EdgeGroup.", trace);
            return false;
        }
        if (edgeGroup.getAncestorOfType(101050) == null && ((membersetRefs = node.getDescendantsOfType(201138, false)) == null || membersetRefs.length == 0)) {
            this.traceQueryCondition(false, "The node is not within a nested edge group.", trace);
            return false;
        }
        if (node.getNumberChildren() <= 1) {
            this.traceQueryCondition(false, "The node doesn't have at least 2 children.", trace);
            return false;
        }
        if (node.getType() == 201101 && !this.hasNestedLevelCalc(node, (V5EdgeGroup)edgeGroup)) {
            this.traceQueryCondition(false, "The node is a set and does not contain a nested level calc.", trace);
            return false;
        }
        if (this.shouldSetBeSplit(node)) {
            this.traceQueryCondition(true, "The set contains a calculated member which needs to be normalized.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The node doesn't have a child with a calculated member which requires normalization.", trace);
        return false;
    }

    private boolean hasNestedLevelCalc(IXQEQueryNode set, V5EdgeGroup edgeGroup) {
        IXQEQueryNode[] calcs;
        V5EdgeGroup ancestorGroup = (V5EdgeGroup)edgeGroup.getAncestorOfType(101050);
        if (ancestorGroup == null) {
            return false;
        }
        MDXHierInfo ancestorHierInfo = ((V5ValueSet)ancestorGroup.getChild(0)).getHierarchyInfo();
        for (IXQEQueryNode calc : calcs = set.getDescendantsOfType(201085, false)) {
            V5MemberFunction memCalc = (V5MemberFunction)calc;
            MDXHierInfo hierInfo = memCalc.getHierarchyInfo();
            if (hierInfo.projectsShellHierarchy()) {
                return true;
            }
            if (!hierInfo.projectedHierarchiesOverlap(ancestorHierInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSetBeSplit(IXQEQueryNode setNode) {
        boolean shouldBeSplit = false;
        if (setNode.getType() != 201111 || ((V5UnionFunction)setNode).getAll()) {
            for (IXQEQueryNode child : setNode.getChildren()) {
                switch (child.getType()) {
                    case 201085: {
                        shouldBeSplit = true;
                        break;
                    }
                    case 201101: 
                    case 201111: {
                        shouldBeSplit = this.shouldSetBeSplit(child);
                        break;
                    }
                }
                if (shouldBeSplit) break;
            }
        }
        return shouldBeSplit;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return super.passesQueryCondition(node, environment);
    }
}

