/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5HierarchyFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractCoerceWithinSetToReportSummary
extends Transformation {
    protected abstract V5ValueSet getSiblingProjectingAggregationSet(V5ValueSet var1);

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5MemberFunction member = (V5MemberFunction)node.getParent();
        V5ValueSet valueSet = (V5ValueSet)V5ToCogMDXUtilities.getParentOverSet(member);
        V5ValueSet sibling = this.getSiblingProjectingAggregationSet(valueSet);
        String refDataItem = (String)sibling.getPropertyValue("refDataItem");
        valueSet.setIsReportSummary(refDataItem);
        valueSet.setIsReportDetail(false);
        V5MemberSummaryFunction sf = (V5MemberSummaryFunction)node;
        MDXHierInfo hierInfo = member.getHierarchyInfo();
        if (hierInfo.projectsShellHierarchy()) {
            if (member.getNumberChildren() < 3) {
                String dataItemName = valueSet.getRefDataItemProperty();
                String defaultMun = "";
                StringType valueDataType = DataTypeFactory.getStringType();
                if (member.getNumberChildren() < 2) {
                    V5LiteralValue memberName = (V5LiteralValue)factory.createNode(201026);
                    memberName.setDataType(valueDataType);
                    memberName.setValue(defaultMun);
                    member.addChild(memberName);
                }
                String caption = "";
                V5LiteralValue memberName = (V5LiteralValue)factory.createNode(201026);
                memberName.setDataType(valueDataType);
                if (dataItemName != null && dataItemName.length() > 0) {
                    caption = dataItemName;
                }
                memberName.setValue(caption);
                member.addChild(memberName);
            }
            V5SimpleNode set = (V5SimpleNode)sf.getChild(1).getChild(0);
            V5HierarchyFunction hierarchyFunction = null;
            hierarchyFunction = (V5HierarchyFunction)factory.createNode(201073);
            hierarchyFunction.addChild(factory.deepCopyNode(set));
            member.addChild(hierarchyFunction);
        }
    }

    public boolean queryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        boolean bl = status = node.getAncestorOfType(1002) != null;
        if (!status) {
            this.traceQueryCondition(status, "Node is not within a MDXQuery.", trace);
            return status;
        }
        boolean bl2 = status = node.getParent().getType() == 201085;
        if (!status) {
            this.traceQueryCondition(status, "Parent node is not a V5MemberFunction.", trace);
            return status;
        }
        IXQEQueryNode valueSet = V5ToCogMDXUtilities.getParentOverSet(node.getParent());
        boolean bl3 = status = valueSet.getType() == 101057;
        if (!status) {
            this.traceQueryCondition(status, "Grand-Parent node is not a V5ValueSet.", trace);
            return status;
        }
        String refDataItem = ((V5ValueSet)valueSet).isReportSummary();
        boolean bl4 = status = refDataItem == null;
        if (!status) {
            this.traceQueryCondition(status, "Node already identified as part of a ReportSummary.", trace);
            return status;
        }
        boolean bl5 = status = ((V5ValueSet)valueSet).getIsDetailAutomatic() || !((V5ValueSet)valueSet).isReportDetail();
        if (!status) {
            this.traceQueryCondition(status, "Cannot coerce, the detail flag on this summary was specifically set to true in the V5.", trace);
            return status;
        }
        return status;
    }

    public boolean nodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder traceMessage;
        V5SimpleNode aggregationSet;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5MemberSummaryFunction v5MemberSummaryFunction = (V5MemberSummaryFunction)node;
        boolean bl = status = v5MemberSummaryFunction.getChild(1).getType() == 201039;
        if (!status) {
            this.traceNodeCondition(status, "The V5MemberSummaryFunction this node refers to does not have a within clause.", trace);
            return status;
        }
        V5AggregateWithinClause v5AggregateWithinClause = (V5AggregateWithinClause)v5MemberSummaryFunction.getChild(1);
        boolean bl2 = status = v5AggregateWithinClause.getWithinClauseType() == 0;
        if (!status) {
            this.traceNodeCondition(status, "The V5MemberFunction this node refers to does not have a within set clause.", trace);
            return status;
        }
        if (v5AggregateWithinClause.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The within set clause does not have one child.", trace);
            return false;
        }
        IXQEQueryNode v5AggregateWithinClauseChild = v5AggregateWithinClause.getChild(0);
        boolean bl3 = status = v5AggregateWithinClauseChild.isOfCategory(201122) || v5AggregateWithinClauseChild.getType() == 601024;
        if (!status && v5AggregateWithinClauseChild.getType() == 201116) {
            String calcType;
            IMetadata metaData = ((V5BoundModelIdentifier)v5AggregateWithinClauseChild).getMetadata();
            MetadataType metadataType = metaData.getObjectType();
            if (metadataType == MetadataType.NAMED_SET) {
                status = true;
            } else if (metadataType == MetadataType.CALCULATION && (calcType = ((ICalculation)metaData).getCalcType()).equals("namedSet")) {
                status = true;
            }
        }
        if (!status) {
            V5ValueSet v5ValueSet = (V5ValueSet)v5MemberSummaryFunction.getAncestorOfType(101057);
            String refDataItem = v5ValueSet.getRefDataItemProperty();
            String v5ValueSetName = v5ValueSet.getNameProperty();
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidWithinSetClauseArgument, v5ValueSetName, refDataItem);
        }
        V5MemberFunction member = (V5MemberFunction)node.getParent();
        V5ValueSet valueSet = (V5ValueSet)V5ToCogMDXUtilities.getParentOverSet(member);
        MDXHierInfo hierInfo = member.getHierarchyInfo();
        if (hierInfo.projectsShellHierarchy()) {
            boolean bl4 = status = v5MemberSummaryFunction.getHierarchyInfo().getNumProjectedHierarchies() == 1;
            if (!status) {
                this.traceNodeCondition(status, "member function does not specify the hierarchy  and the aggregation set does not project only 1 hierarchy", trace);
                return status;
            }
        }
        boolean bl5 = status = (aggregationSet = this.getAggregationSet(valueSet, traceMessage = new StringBuilder())) != null;
        if (!status) {
            this.traceNodeCondition(status, traceMessage.toString(), trace);
            return status;
        }
        V5ValueSet sibling = this.getSiblingProjectingAggregationSet(valueSet);
        boolean bl6 = status = sibling != null;
        if (!status) {
            this.traceNodeCondition(status, "A sibling that projects the aggregation set could not be identified.", trace);
            return status;
        }
        if (!hierInfo.projectsShellHierarchy() && !(status = sibling.getHierarchyInfo().equals(hierInfo))) {
            this.traceNodeCondition(status, "The hierarchy specified by the MEMBER function is not the hierarchy projected by the sibling valueset that projects the aggregation set", trace);
            return status;
        }
        this.traceNodeCondition(status, "This expression is projected as a sibling to the set it aggregates.", trace);
        return status;
    }

    protected List<IXQEQueryNode> getSiblings(V5ValueSet valueSet, StringBuilder traceMessage) {
        boolean status = true;
        IXQEQueryNode parentGroup = valueSet.getParent();
        if (parentGroup.getParent().getType() == 101050 || parentGroup.getParent().getType() == 101049) {
            parentGroup = parentGroup.getParent();
        }
        int numberOfAncestorGroup = valueSet.getAncestorsOfType(101050).length;
        List<IXQEQueryNode> potentialSiblings = parentGroup.getDescendantsOfTypeOrdered(101057, false);
        ListIterator<IXQEQueryNode> it = potentialSiblings.listIterator();
        while (it.hasNext()) {
            IXQEQueryNode potentialSibling = it.next();
            if (potentialSibling == valueSet) {
                it.remove();
                continue;
            }
            if (potentialSibling.getAncestorsOfType(101050).length != numberOfAncestorGroup) {
                it.remove();
                continue;
            }
            IXQEQueryNode v5Set = potentialSibling.getChild(0);
            status = v5Set.isOfCategory(201120);
            if (status) continue;
            if (traceMessage != null) {
                traceMessage.append("A sibling's expression is not yet of category SimpleNode.");
            }
            return new ArrayList<IXQEQueryNode>();
        }
        boolean bl = status = potentialSiblings.size() != 0;
        if (!status) {
            if (traceMessage != null) {
                traceMessage.append("Node does not have sibling ValueSets.");
            }
            return potentialSiblings;
        }
        V5SimpleNode aggregationSet = this.getAggregationSet(valueSet, null);
        ListIterator<IXQEQueryNode> itSibling = potentialSiblings.listIterator();
        while (itSibling.hasNext()) {
            IXQEQueryNode potentialSibling = itSibling.next();
            if (!potentialSibling.getChild(0).isOfCategory(201122) && potentialSibling.getChild(0).getType() != 201116) {
                itSibling.remove();
                continue;
            }
            V5SimpleNode v5Set = (V5SimpleNode)potentialSibling.getChild(0);
            if (v5Set.getHierarchyInfo().equals(aggregationSet.getHierarchyInfo())) continue;
            itSibling.remove();
        }
        return potentialSiblings;
    }

    protected V5SimpleNode getAggregationSet(V5ValueSet valueSet, StringBuilder traceMessage) {
        boolean status = true;
        List<IXQEQueryNode> summaries = valueSet.getDescendantsOfTypeOrdered(201032, false);
        ListIterator<IXQEQueryNode> it = summaries.listIterator();
        while (it.hasNext()) {
            IXQEQueryNode summary = it.next();
            if (summary.getAncestorOfType(201013) == null) continue;
            it.remove();
        }
        boolean bl = status = summaries.size() == 1;
        if (!status) {
            if (traceMessage != null) {
                traceMessage.append("The dataItem this node refers to does not have exactly 1 V5MemberSummaryFunction descendant.");
            }
            return null;
        }
        V5SimpleNode aggregationSet = (V5SimpleNode)summaries.get(0).getChild(1).getChild(0);
        return aggregationSet;
    }

    protected V5ValueSet getDetailSiblingBaseSet(V5ValueSet totalValueSet) {
        V5ValueSet detailSiblingBaseSet = null;
        List<IXQEQueryNode> potentialSiblings = this.getSiblings(totalValueSet, null);
        for (IXQEQueryNode potentialSibling : potentialSiblings) {
            V5ValueSet potentialDetailSiblingBaseSet = (V5ValueSet)potentialSibling;
            List<IXQEQueryNode> memberSetsTotal = V5ToCogMDXUtilities.getMemberSetsForV5ValueSet(totalValueSet);
            List<IXQEQueryNode> memberSetsSibling = V5ToCogMDXUtilities.getMemberSetsForV5ValueSet(potentialDetailSiblingBaseSet);
            block1: for (IXQEQueryNode memberSetSibling : memberSetsSibling) {
                for (IXQEQueryNode memberSetTotal : memberSetsTotal) {
                    if (!potentialDetailSiblingBaseSet.isReportDetail()) {
                        if (memberSetSibling.getParent() == memberSetTotal) continue;
                        return null;
                    }
                    if (!memberSetSibling.isAncestor(memberSetTotal) || memberSetSibling.getParent() == memberSetTotal) continue;
                    if (detailSiblingBaseSet != null) {
                        totalValueSet.throwInternalError("detailSiblingBaseSet number > 1");
                    }
                    detailSiblingBaseSet = potentialDetailSiblingBaseSet;
                    continue block1;
                }
            }
        }
        return detailSiblingBaseSet;
    }
}

