/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.fds.FunctionNode;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import java.util.ArrayList;

public final class ValidateV5ScalarFunctionAgainstDatasource
extends AbstractV5ToCogMDXTransformation {
    private static final String VALID_FUNCTION = "The scalar function is valid for the datasource.";

    public ValidateV5ScalarFunctionAgainstDatasource() {
        this.mName = "Validate V5ScalarFunction against datasource.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) throws XQEOlapUnsupportedQueryException {
        MDXQuery mdxquery = (MDXQuery)node.getAncestorOfType(1002);
        StringBuilder dataSource = new StringBuilder(mdxquery.getDataSourceType());
        String scalarFunction = ((V5ScalarFunction)node).getNodeSubTypeName();
        if ("WIDTH-BUCKET".equals(scalarFunction) && mdxquery.isDMR()) {
            dataSource.append(" - DMR");
        }
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_ScalarFunctionUnsupportedByDatasource, scalarFunction, dataSource.toString());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object[] functionsArray;
        ArrayList<IFunctionNode> functionList;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxquery = (MDXQuery)node.getAncestorOfType(1002);
        String dataSourceType = mdxquery.getDataSourceType();
        String scalarFunction = ((V5ScalarFunction)node).getNodeSubTypeName();
        if ("WIDTH-BUCKET".equals(scalarFunction) && mdxquery.isDMR()) {
            this.traceNodeCondition(true, "WIDTH-BUCKET is not supported by DMR.", trace);
            return true;
        }
        if (DataSourceTypeEnum.isRelational(dataSourceType)) {
            this.traceNodeCondition(false, "Relational dataSource will validate scalar function separately.", trace);
            return false;
        }
        try {
            IFunctionDefinition functionDefinition = IFunctionDefinition.Factory.createFDAllLocales();
            functionList = functionDefinition.findFuncListByName(scalarFunction.toLowerCase());
        }
        catch (RuntimeException e) {
            throw new XQERuntimeException(e);
        }
        if (scalarFunction.equals("CEIL")) {
            this.traceNodeCondition(false, VALID_FUNCTION, trace);
            return false;
        }
        if (functionList == null) {
            this.traceNodeCondition(false, "Unable to find the function definition.", trace);
            return false;
        }
        for (Object funcNode : functionsArray = functionList.toArray()) {
            if (!((FunctionNode)funcNode).isSupportedByModelDatasourceInterfaceID(dataSourceType)) continue;
            this.traceNodeCondition(false, VALID_FUNCTION, trace);
            return false;
        }
        this.traceNodeCondition(true, "The scalar function is not valid for the datasource.", trace);
        return true;
    }
}

