/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import java.util.List;

public class AddForReportScopeOrRemoveAgg
extends RQPTransformation {
    private static final String CONTAINS_NON_AGGREGATED_PROJECTIONS = "containsNonAggregatedProjections";

    public AddForReportScopeOrRemoveAgg() {
        this.mName = "Add For-Report Scope";
        this.mPassNumbers = new int[]{121};
        this.mTypes = new int[]{201031, 201033, 201035};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Governors governors = node.getGovernors();
        if (governors.getNestedAggregateHandling().equals((Object)Governors.NestedAggregateHandling.REMOVE) && node.getType() == 201031 && ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(node.getChild(0))) {
            node.extract();
        } else {
            node.addChild(environment.getNodeFactory().createNode(201037));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (aggregate.getForClause() != null) {
            this.traceNodeCondition(false, "Already has a for-clause", xqeTrace);
            return false;
        }
        RMQueryItem queryItem = (RMQueryItem)node.getAncestorOfType(801033);
        if (queryItem != null) {
            IQuerySubject qs = queryItem.getQuerySubject();
            List<IDeterminant> dets = qs.getDeterminants();
            for (IDeterminant det : dets) {
                if (!det.getCanGroup()) continue;
                List<IQueryItem> attrs = det.getAttributes();
                for (IQueryItem attr : attrs) {
                    if (!attr.equals(queryItem.getQueryItem())) continue;
                    return false;
                }
            }
            return true;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        if (rqpQuery == null) {
            return false;
        }
        if (rqpQuery.isSummarizedQuery() || rqpQuery.getFirstChildByType(801013) != null) {
            this.traceNodeCondition(false, "The aggregate already is in a summary query which has a scope.", xqeTrace);
            return false;
        }
        if (this.rqpQueryContainsNonAggregatedProjections(rqpQuery)) {
            this.traceNodeCondition(true, "For-report scope will be added to the aggregate.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "All projections have for-report scope.", xqeTrace);
        return false;
    }

    private boolean rqpQueryContainsNonAggregatedProjections(RQPQuery rqpQuery) {
        Boolean containsNAP = rqpQuery.getBooleanPropertyValue(CONTAINS_NON_AGGREGATED_PROJECTIONS);
        if (containsNAP != null) {
            return containsNAP;
        }
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            if (ExpressionAnalyzer.exprOrRefExprHasAggregate(projection.getExpression()) || this.projectionIsAggregateTypeNotApplicable(projection)) continue;
            rqpQuery.setPropertyValue(CONTAINS_NON_AGGREGATED_PROJECTIONS, Boolean.TRUE);
            return true;
        }
        rqpQuery.setPropertyValue(CONTAINS_NON_AGGREGATED_PROJECTIONS, Boolean.FALSE);
        return false;
    }

    private boolean projectionIsAggregateTypeNotApplicable(RQPDataItem projection) {
        V5Query query = projection.getRootRQPQuery().getRefV5Query();
        V5DataItem dataItem = query.getV5Selection().getDataItemByRefName(projection.getName());
        if (dataItem == null) {
            return false;
        }
        String aggName = dataItem.getAggregateProperty();
        if (aggName == null) {
            return false;
        }
        return aggName.equalsIgnoreCase("notApplicable");
    }
}

