/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedSqlFilter;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.TransferJoinPathToFromClauseForRMSqlCalcFilter;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class AddSourcesToRMSqlCalcFilter
extends RQPTransformation {
    private static final String PROP_SOURCES_ADDED = "sourcesAdded";

    public AddSourcesToRMSqlCalcFilter() {
        this.mName = "Add sources to database query subject.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{801027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TreeSet<IQuerySubject> sources = new TreeSet<IQuerySubject>();
        this.getAllDBQuerySubjects(node, sources);
        this.addSQLAST(node, sources, environment);
        node.setPropertyValue(PROP_SOURCES_ADDED, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object transformationAppliedAlready = node.getPropertyValue(PROP_SOURCES_ADDED);
        if (transformationAppliedAlready != null && ((Boolean)transformationAppliedAlready).booleanValue()) {
            return false;
        }
        return this.getAllDBQuerySubjects(node, new TreeSet<IQuerySubject>());
    }

    private boolean getAllDBQuerySubjects(IXQEQueryNode node, TreeSet<IQuerySubject> sources) {
        IQuerySubject currentDBQS = ((RMQuery)node).getQuerySubject();
        List<IXQEQueryNode> v5BoundModelIds = node.getDescendantsOfTypeOrdered(201116, 801017);
        for (IXQEQueryNode v5BoundNode : v5BoundModelIds) {
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)v5BoundNode;
            IQuerySubject qs = v5BoundID.getQuerySubject();
            if (qs.equals(currentDBQS)) continue;
            sources.add(qs);
        }
        return !sources.isEmpty();
    }

    private void addSQLAST(IXQEQueryNode node, TreeSet<IQuerySubject> sources, PlanningEnvironment environment) {
        IXQEQueryNode nodeToAddTo;
        RMEmbeddedSqlFilter rmSqlFilter = (RMEmbeddedSqlFilter)node.getFirstDescendantOfTypeOrdered(801037, false);
        if (rmSqlFilter == null) {
            nodeToAddTo = node.getFirstDescendantOfTypeOrdered(301015, false);
        } else {
            nodeToAddTo = rmSqlFilter.getLowestSQLFilter();
            if (nodeToAddTo == null) {
                return;
            }
        }
        IXQEQueryNode sqlFrom = nodeToAddTo.getFirstChildByType(301043);
        if (sqlFrom == null) {
            sqlFrom = environment.getNodeFactory().createNode(301043);
            for (IXQEQueryNode child : nodeToAddTo.getChildren()) {
                if (child.getType() != 301007) continue;
                child.move(sqlFrom);
            }
            nodeToAddTo.addChild(sqlFrom, 0);
        }
        ArrayList<String> rangeVarNames = new ArrayList<String>();
        for (IXQEQueryNode c : sqlFrom.getChildren()) {
            rangeVarNames.add(((SQLRangeVar)c).getName());
        }
        IXQEQueryNode rmQueryList = node.getAncestorOfType(801032);
        for (IQuerySubject qs : sources) {
            RMQuery rmQuery = ((RMQueryList)rmQueryList).getRMQuery(qs);
            this.verifyDBQSApplied(rmQuery, environment);
            this.verifyDBQSJoinPathApplied(rmQuery, environment);
            IXQEQueryNode rangeVar = rmQuery.getFirstChildByType(301007);
            if (rangeVarNames.contains(((SQLRangeVar)rangeVar).getName())) continue;
            sqlFrom.addChild(environment.getNodeFactory().deepCopyNode(rangeVar));
            rangeVarNames.add(((SQLRangeVar)rangeVar).getName());
        }
    }

    private void verifyDBQSApplied(IXQEQueryNode rmQuery, PlanningEnvironment environment) {
        AddSourcesToRMSqlCalcFilter transformation = new AddSourcesToRMSqlCalcFilter();
        if (((Transformation)transformation).passesNodeCondition(rmQuery, environment)) {
            ((Transformation)transformation).apply(rmQuery, environment);
        }
    }

    private void verifyDBQSJoinPathApplied(IXQEQueryNode rmQuery, PlanningEnvironment environment) {
        TransferJoinPathToFromClauseForRMSqlCalcFilter transformation = new TransferJoinPathToFromClauseForRMSqlCalcFilter();
        for (IXQEQueryNode sqlFrom : rmQuery.getDescendantsOfType(301043, false)) {
            if (!((Transformation)transformation).passesNodeCondition(sqlFrom, environment)) continue;
            ((Transformation)transformation).apply(sqlFrom, environment);
        }
    }
}

