/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CopySecurityFilterNodes
extends RQPTransformation {
    public CopySecurityFilterNodes() {
        this.mName = "Copy Security filters to SQLFilter node";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{801036};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode rmQuery = node.getParent();
        IXQEQueryNode[] rmEmbeddedSqlFilter = rmQuery.getDescendantsOfType(801037, false);
        IXQEQueryNode rmEmbeddedSqlFilterNode = rmEmbeddedSqlFilter[0];
        IXQEQueryNode newSqlFilter = factory.createNode(301009);
        RMEmbeddedFilter.processSecurityFilters(node, environment, factory, newSqlFilter);
        rmEmbeddedSqlFilterNode.getChild(0).move(newSqlFilter, 0);
        newSqlFilter.insertParent(rmEmbeddedSqlFilterNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] securityFilters;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        IXQEQueryNode rmQuery = node.getParent();
        if (!rmQuery.hasDescendantOfType(801037, false)) {
            this.traceNodeCondition(false, "There is no rmEmbeddedSqlFilter node created yet.", xqeTrace);
            return false;
        }
        if (node.getPropertyValue("embeddedFilterApply") != null) {
            this.traceNodeCondition(false, "This embedded filter or join path node have been applied", xqeTrace);
            return false;
        }
        Boolean status = false;
        for (IXQEQueryNode securityFilter : securityFilters = node.getDescendantsOfType(801035, false)) {
            String filterType = ((RMEmbeddedFilter)securityFilter).getFilterType();
            if (null == filterType || !filterType.equals("securityFilterDefinition")) continue;
            status = true;
            break;
        }
        if (!status.booleanValue()) {
            this.traceNodeCondition(false, "The Filter list does not contains any Security filter", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The Filter list contains a Security filter; applied the transformation", xqeTrace);
        return true;
    }
}

