/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5MovingAndRunningSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class GenerateCastOverExactNumericDivision
extends RQPTransformation {
    public GenerateCastOverExactNumericDivision() {
        this.mName = "Generate a cast to double over Exact Numeric Division.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{201014, 201031, 201035};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5CastFunction castNode = (V5CastFunction)factory.createNode(201051);
        V5CastTarget dType = (V5CastTarget)factory.createNode(201052);
        dType.setDataType(DoubleType.DOUBLETYPE);
        XQEQueryNode dividend = (XQEQueryNode)node.getChild(0);
        dividend.insertParent(castNode);
        castNode.addChild(dType);
        castNode.setOptional(Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "Not a relational node.", trace);
            return false;
        }
        Governors.ExactNumericDivision exactNumericDivision = node.getGovernors().getExactNumericDivision();
        boolean status = true;
        switch (exactNumericDivision) {
            case CAST_TO_DOUBLE: {
                break;
            }
            case CAST_TO_DOUBLE_CONDITIONAL: {
                if (node.getChild(0).getType() != 201051) break;
                status = false;
                break;
            }
            case DO_NOT_ADJUST: {
                status = false;
                break;
            }
        }
        if (status) {
            status = this.optionalCastIsNeeded(node, exactNumericDivision);
        }
        if (status) {
            this.traceNodeCondition(status, "Need to compensate for exact numeric division.", trace);
        } else {
            this.traceNodeCondition(status, "Don't need to compensate for exact numeric division.", trace);
        }
        return status;
    }

    private boolean optionalCastIsNeeded(IXQEQueryNode node, Governors.ExactNumericDivision exactNumericDivision) {
        boolean status = false;
        if (this.isDivision(node)) {
            IDataType dividendDataType = this.getDataType(node.getChild(0), exactNumericDivision);
            IDataType divisorDataType = this.getDataType(node.getChild(1), exactNumericDivision);
            boolean dividentMatters = dividendDataType != null && dividendDataType.isExactNumeric();
            boolean divisorMatters = divisorDataType != null && divisorDataType.isExactNumeric();
            status = dividentMatters && divisorMatters;
        } else if (this.isPreciseAggr(node)) {
            IDataType childDataType = this.getDataType(node.getChild(0), exactNumericDivision);
            status = childDataType != null && childDataType.isExactNumeric();
        }
        return status;
    }

    private IDataType getDataType(IXQEQueryNode node, Governors.ExactNumericDivision exactNumericDivision) {
        if (node.getType() == 801009) {
            return this.getDataType(((RQPDataItemRef)node).getReferencedItem().getChild(0), exactNumericDivision);
        }
        if (this.isDivision(node) || this.isPreciseAggr(node)) {
            if (exactNumericDivision == Governors.ExactNumericDivision.CAST_TO_DOUBLE_CONDITIONAL) {
                if (node.getChild(0).getType() != 201051) {
                    return DoubleType.DOUBLETYPE;
                }
            } else {
                return DoubleType.DOUBLETYPE;
            }
        }
        if (node.isOfCategory(201120)) {
            return ((V5SimpleNode)node).getDataType();
        }
        return null;
    }

    private boolean isDivision(IXQEQueryNode node) {
        boolean status = false;
        if (node.getType() == 201014) {
            switch (((V5ValueExpression)node).getSubType()) {
                case 3: {
                    status = true;
                    break;
                }
            }
        }
        return status;
    }

    private boolean isPreciseAggr(IXQEQueryNode node) {
        boolean status = false;
        if (node.getType() == 201031) {
            switch (((V5ValueSummaryFunction)node).getSubType()) {
                case 1: {
                    status = true;
                    break;
                }
            }
        } else if (node.getType() == 201035) {
            switch (((V5MovingAndRunningSummaryFunction)node).getSubType()) {
                case 1: 
                case 20: 
                case 22: {
                    status = true;
                    break;
                }
            }
        }
        return status;
    }
}

