/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public final class GenerateCastOverNullLiteral
extends RQPTransformation {
    public GenerateCastOverNullLiteral() {
        this.mName = "Generate Cast Over NULL Literal.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{201023};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        String dataItemName = null;
        RQPDataItem rqpDataItem = (RQPDataItem)node.getAncestorOfType(801008);
        IDataType castDataType = null;
        if (rqpDataItem != null) {
            dataItemName = rqpDataItem.getOriginalName();
            castDataType = rqpDataItem.getCastDataType();
        } else {
            RMQueryItem rmQueryItem = (RMQueryItem)node.getAncestorOfType(801033);
            dataItemName = rmQueryItem.getName();
        }
        V5CastFunction castNode = (V5CastFunction)factory.createNode(201051);
        node.insertParent(castNode);
        V5CastTarget dType = (V5CastTarget)factory.createNode(201052);
        if (castDataType != null) {
            dType.setDataType(castDataType.getBaseDataType());
        } else {
            dType.setDataType(IntegerType.INTEGERTYPE);
        }
        castNode.addChild(dType);
        String nag = XQEMessages.getMessage(XQEMessageKeys.WRN_NULLLiteralOutOfContext, XQEMessages.getCurrProductLocale(), dataItemName, dType.getDataType().toString().toUpperCase());
        ((ExecutionEnvironment)environment.getExecutionEnvironment()).addNag(nag);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 201051) {
            if (parent.getType() == 801008 || parent.getType() == 801033) {
                status = true;
            } else if (node.getAncestorOfType(801008) != null || node.getAncestorOfType(801033) != null) {
                if (node.getBooleanPropertyValue("isCollapsedCaseExpr") == Boolean.TRUE || node.getBooleanPropertyValue("isCollapsedIfThenElseExpr") == Boolean.TRUE) {
                    status = true;
                } else if (parent.isOfCategory(201124) && parent.getChild(0).equals(node)) {
                    status = true;
                }
            }
        }
        if (status) {
            this.traceQueryCondition(status, "Generating Cast Over NULL Literal.", trace);
        } else {
            this.traceQueryCondition(status, "Not Generating Cast Over NULL Literal.", trace);
        }
        return status;
    }
}

