/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.BuildFullOuterJoin;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OrderFactStreams
extends RQPTransformation {
    public static final String PROP_OUTER_PROJ = "projInOuterQuery";
    public static final String PROP_STREAM_DATA = "streamData";

    public OrderFactStreams() {
        this.mName = "Order Fact Streams";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPFactManager rqpFactManager = RQPUtilities.getRQPFactManager(node);
        List<FactInfo> facts = this.getFacts(node, rqpFactManager);
        IXQEQueryNode[] orderedFacts = this.orderFacts(facts, rqpFactManager, environment);
        this.rebuildFromClause(node, orderedFacts);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        if (parentQuery != null) {
            this.traceNodeCondition(false, "This is not the root RQPQuery.", xqeTrace);
            return false;
        }
        RQPFactManager rqpFactManager = RQPUtilities.getRQPFactManager(node);
        if (rqpFactManager == null) {
            this.traceNodeCondition(false, "No factManager to drive the ordering process.", xqeTrace);
            return false;
        }
        IXQEQueryNode fromClause = node.getFirstChildByType(301043);
        if (fromClause == null) {
            this.traceNodeCondition(false, "Missing from clause, nothing to stitch.", xqeTrace);
            return false;
        }
        int numberOfFactStreams = rqpFactManager.getNumberOfFactStreams();
        if (numberOfFactStreams <= 2) {
            this.traceNodeCondition(false, "No need to order the fact streams", xqeTrace);
            return false;
        }
        IXQEQueryNode[] sqlRangeVars = fromClause.getChildren();
        if (sqlRangeVars.length != numberOfFactStreams) {
            this.traceNodeCondition(false, "Incomplete from clause.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "Order the fact streams", xqeTrace);
        return true;
    }

    private List<FactInfo> getFacts(IXQEQueryNode node, RQPFactManager rqpFactManager) {
        ArrayList<FactInfo> facts = new ArrayList<FactInfo>();
        IXQEQueryNode fromClause = node.getFirstChildByType(301043);
        IXQEQueryNode[] sqlRangeVars = fromClause.getChildren();
        for (int i = sqlRangeVars.length - 1; i >= 0; --i) {
            FactInfo fi = this.getFactStreamData((SQLRangeVar)sqlRangeVars[i]);
            facts.add(fi);
        }
        return facts;
    }

    private FactInfo getFactStreamData(SQLRangeVar node) {
        RQPQuery query = (RQPQuery)node.getChild(0);
        String factName = query.getName();
        FactInfo fi = new FactInfo();
        fi.sqlRangeVar = node;
        fi.factName = factName;
        return fi;
    }

    private IXQEQueryNode[] orderFacts(List<FactInfo> facts, RQPFactManager rqpFactManager, PlanningEnvironment environment) {
        IXQEQueryNode[] orderedFacts;
        block9: {
            ArrayList<List<FactInfo>> groupedFacts;
            block8: {
                orderedFacts = new IXQEQueryNode[facts.size()];
                int topPositionAvailable = 0;
                int bottomPositionAvailable = facts.size() - 1;
                groupedFacts = new ArrayList<List<FactInfo>>();
                ArrayList<FactInfo> singleFacts = new ArrayList<FactInfo>();
                while (facts.size() - 1 >= 0) {
                    ArrayList currentList = new ArrayList();
                    HashSet<String> hashSet = new HashSet<String>();
                    FactInfo currentFi = facts.remove(facts.size() - 1);
                    currentList.add(currentFi);
                    hashSet.add(currentFi.factName);
                    for (int i = facts.size() - 1; i >= 0; --i) {
                        String factNameToInclude = facts.get((int)i).factName;
                        hashSet.add(factNameToInclude);
                        Set<String> sharedDimensions = rqpFactManager.getSharedDimensions(hashSet);
                        if (sharedDimensions.size() > 0) {
                            FactInfo fi = facts.remove(i);
                            currentList.add(fi);
                            continue;
                        }
                        hashSet.remove(factNameToInclude);
                    }
                    if (currentList.size() == 1) {
                        orderedFacts[bottomPositionAvailable--] = ((FactInfo)currentList.get((int)0)).sqlRangeVar;
                        singleFacts.add((FactInfo)currentList.get(0));
                        continue;
                    }
                    Collections.sort(currentList);
                    if (facts.size() == 0) {
                        for (int j = 0; j < currentList.size(); ++j) {
                            orderedFacts[topPositionAvailable++] = ((FactInfo)currentList.get((int)j)).sqlRangeVar;
                        }
                        continue;
                    }
                    groupedFacts.add(currentList);
                }
                if (!this.needToMergeFacts(groupedFacts, singleFacts, rqpFactManager)) break block8;
                for (List list : groupedFacts) {
                    orderedFacts[topPositionAvailable++] = this.mergeFacts(list, environment);
                }
                break block9;
            }
            if (groupedFacts.size() <= 0) break block9;
            for (int j = 0; j < ((List)groupedFacts.get(0)).size(); ++j) {
                orderedFacts[topPositionAvailable++] = ((FactInfo)((List)groupedFacts.get((int)0)).get((int)j)).sqlRangeVar;
            }
        }
        return orderedFacts;
    }

    private boolean needToMergeFacts(List<List<FactInfo>> groupedFacts, List<FactInfo> singleFacts, RQPFactManager rqpFactManager) {
        if (groupedFacts.size() == 0) {
            return false;
        }
        if (groupedFacts.size() > 1) {
            return true;
        }
        if (singleFacts.size() == 0) {
            return false;
        }
        if (BuildFullOuterJoin.getRowNumberStitch(rqpFactManager.getRootRQPQuery())) {
            return true;
        }
        for (FactInfo factInfo : singleFacts) {
            BuildFullOuterJoin.FactInfo fInfo = BuildFullOuterJoin.getFactStreamData((SQLRangeVar)factInfo.sqlRangeVar, rqpFactManager);
            factInfo.sqlRangeVar.setPropertyValue(PROP_STREAM_DATA, fInfo);
            if (fInfo.allProjections.size() == 0) continue;
            return true;
        }
        return false;
    }

    private IXQEQueryNode mergeFacts(List<FactInfo> facts, PlanningEnvironment environment) {
        IXQEQueryNode fromClause = facts.get((int)0).sqlRangeVar.getParent();
        SQLRangeVar rangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        fromClause.addChild(rangeVar);
        RQPQuery outerQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
        rangeVar.addChild(outerQuery);
        outerQuery.setIsFactQuery();
        outerQuery.setIsMergedQuery();
        StringBuilder outerQueryName = new StringBuilder();
        for (FactInfo fact : facts) {
            outerQueryName.append(fact.factName);
        }
        RQPProjectionList projList = outerQuery.getOrCreateProjectionList(environment);
        IXQEQueryNode sqlFromClause = environment.getNodeFactory().createNode(301043);
        outerQuery.addChild(sqlFromClause);
        List<IXQEQueryNode> refsToFix = fromClause.getAncestorOfType(801017).getDescendantsOfTypeOrdered(801009, 801017);
        for (FactInfo fact : facts) {
            RQPQuery factQuery = (RQPQuery)fact.sqlRangeVar.getChild(0);
            for (IXQEQueryNode proj : factQuery.getProjectionList().getChildren()) {
                RQPDataItem di = (RQPDataItem)proj.getChild(0);
                String newName = fact.factName + ((SQLAlias)proj).getName();
                for (IXQEQueryNode r : refsToFix) {
                    RQPDataItemRef ref = (RQPDataItemRef)r;
                    if (!ref.getQueryName().equals(fact.factName) || !ref.getName().equals(di.getName())) continue;
                    ref.setQueryName(outerQueryName.toString());
                    ref.setName(newName);
                    if (ref.getNumberChildren() != 1 || ref.getChild(0).getNodeType() != 301005) continue;
                    SQLColumn c = (SQLColumn)ref.getChild(0);
                    c.setTableName(outerQueryName.toString());
                    c.setName(newName);
                }
                SQLAlias sqlAlias = (SQLAlias)environment.getNodeFactory().createNode(301028);
                projList.addChild(sqlAlias);
                sqlAlias.setName(newName);
                RQPDataItem newDI = RQPDataItem.create(environment, newName);
                RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, fact.factName, di.getName());
                newDI.addChild(rqpDataItemRef);
                sqlAlias.addChild(newDI);
            }
            fact.sqlRangeVar.move(sqlFromClause);
        }
        rangeVar.setName(outerQueryName.toString());
        outerQuery.setName(outerQueryName.toString());
        return rangeVar;
    }

    private void rebuildFromClause(IXQEQueryNode query, IXQEQueryNode[] orderedFacts) {
        IXQEQueryNode[] sqlRangeVars;
        IXQEQueryNode fromClause = query.getFirstChildByType(301043);
        for (IXQEQueryNode rv : sqlRangeVars = fromClause.getChildren()) {
            rv.detach();
        }
        for (IXQEQueryNode rv : orderedFacts) {
            if (rv == null) continue;
            fromClause.addChild(rv);
        }
    }

    class FactInfo
    implements Comparable<Object> {
        String factName = null;
        IXQEQueryNode sqlRangeVar;

        FactInfo() {
        }

        @Override
        public int compareTo(Object factInfo) {
            FactInfo compare = (FactInfo)factInfo;
            return this.factName.compareTo(compare.factName);
        }
    }
}

