/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMQueryOperation;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateColumnAlias;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.ReplaceV5SummaryFunction;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.CopyV5FiltersToRQPQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SummaryFilters.CreateRQPSubqueryForSummaryFilters;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqemoser.MoserQuerySubjectWrapper;
import java.util.ArrayList;

public class ProcessSummaryQuerySubject
extends Transformation {
    public static final String PROP_BOOL_FORSUMMARYFILTER = "forSummaryFilter";

    public ProcessSummaryQuerySubject() {
        this.mName = "ProcessSummaryQuerySubject";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{801017, 301018};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = null;
        rqpQuery = node.getType() == 301018 ? this.buildSubQueryOnTopOfSetOperator(node, environment) : (RQPQuery)node;
        if (rqpQuery.getPropertyValue("complexSQS") != null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "Summary query subject with explicit aggregates in query item expressions is not yet supported.");
        }
        this.processSimpleSQS(environment, rqpQuery, node);
    }

    private void processSimpleSQS(PlanningEnvironment environment, RQPQuery rqpQuery, IXQEQueryNode node) {
        IQuerySubject qs;
        MoserQuerySubjectWrapper wrapper = null;
        if (node.getType() == 301018 && (qs = (IQuerySubject)node.getPropertyValue("sqsOwner")) instanceof MoserQuerySubjectWrapper) {
            wrapper = (MoserQuerySubjectWrapper)qs;
        }
        if (wrapper == null) {
            this.processSQSProjections(environment, rqpQuery);
        } else {
            this.processSQSProjectionsItemNormalization(environment, rqpQuery, wrapper);
        }
        RQPDetailFilterList detailFilterList = rqpQuery.getDetailFilterList();
        boolean hasSummaryFilters = false;
        if (detailFilterList != null) {
            IXQEQueryNode[] v5DetailFilters;
            for (IXQEQueryNode v5DetailFilter : v5DetailFilters = detailFilterList.getChildrenOfType(101008)) {
                if (((V5DetailFilter)v5DetailFilter).getPostAutoAggregation()) {
                    this.convertDetailFilterToSummaryFilter(environment, rqpQuery, (V5DetailFilter)v5DetailFilter);
                    hasSummaryFilters = true;
                    continue;
                }
                v5DetailFilter.extract();
            }
            if (hasSummaryFilters) {
                this.processSummaryFilters(environment, rqpQuery);
            }
        }
        RQPProjectionList projectionList = rqpQuery.getProjectionList();
        int[] passNumber = new int[]{1};
        GenerateColumnAlias transformation = new GenerateColumnAlias(passNumber);
        ((Transformation)transformation).apply((IXQEQueryNode)projectionList, environment);
    }

    private void processSQSProjections(PlanningEnvironment environment, RQPQuery rqpQuery) {
        IXQEQueryNode[] projections;
        for (IXQEQueryNode p : projections = rqpQuery.getProjectionList().getChildren()) {
            RQPDataItem proj = (RQPDataItem)p;
            IQueryItem qi = (IQueryItem)proj.getPropertyValue("queryItem");
            if (this.isTreatedAsGroupingItem(qi.getUsage())) {
                this.addGroupingColumn(environment, rqpQuery, proj);
                continue;
            }
            String regAgg = qi.getRegularAggregate();
            if ("unknown".equals(regAgg) || "unsupported".equals(regAgg)) {
                this.addGroupingColumn(environment, rqpQuery, proj);
                continue;
            }
            IXQEQueryNode aggrExpr = this.generateAggrExpr(environment, proj.getExpression(), regAgg);
            proj.getChild(0).exchange(aggrExpr);
        }
    }

    private String getSQLOperate(MoserQuerySubjectWrapper wrapper, IQueryItem qi) {
        String strSQLOp = wrapper.getSQLOperator(qi);
        if (strSQLOp == null) {
            return "unknown";
        }
        int subType = RQPUtilities.convertAggregateNameToV5AggregateFunctionSubtype(strSQLOp);
        if (subType != 6 && subType != 4 && subType != 1) {
            return "unknown";
        }
        if (subType == 6) {
            return "minimum";
        }
        if (subType == 4) {
            return "maximum";
        }
        return "average";
    }

    private void processSQSProjectionsItemNormalization(PlanningEnvironment environment, RQPQuery rqpQuery, MoserQuerySubjectWrapper wrapper) {
        IQueryItem qi;
        RQPDataItem proj;
        IXQEQueryNode[] projections = rqpQuery.getProjectionList().getChildren();
        ArrayList<IXQEQueryNode> done = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> unused = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode p : projections) {
            proj = (RQPDataItem)p;
            qi = (IQueryItem)proj.getPropertyValue("queryItem");
            if (!ItemNormalization.isWrappedQueryItem(wrapper, qi)) {
                unused.add(p);
                continue;
            }
            if (!ItemNormalization.isGroupKey(wrapper, qi)) continue;
            this.addGroupingColumn(environment, rqpQuery, proj);
            done.add(p);
        }
        for (IXQEQueryNode p : projections) {
            if (unused.contains(p) || done.contains(p)) continue;
            proj = (RQPDataItem)p;
            qi = (IQueryItem)proj.getPropertyValue("queryItem");
            String regAgg = this.getSQLOperate(wrapper, qi);
            if ("unknown".equals(regAgg)) {
                this.addGroupingColumn(environment, rqpQuery, proj);
                continue;
            }
            IXQEQueryNode aggrExpr = this.generateAggrExpr(environment, proj.getExpression(), regAgg);
            proj.getChild(0).exchange(aggrExpr);
        }
        for (IXQEQueryNode p : unused) {
            p.detach();
        }
    }

    private IXQEQueryNode generateAggrExpr(PlanningEnvironment environment, IXQEQueryNode originalExpr, String regAgg) {
        AggregateExpressionBuilder aggExprBuilder;
        IXQEQueryNode aggrExpr;
        IXQEQueryNode[] v5Aggregates;
        if ("sum".equals(regAgg)) {
            regAgg = "total";
        }
        if ((v5Aggregates = (aggrExpr = (aggExprBuilder = new AggregateExpressionBuilder(environment)).generateAggregateExpression(regAgg, originalExpr)).getDescendantsOfType(201031, true)).length > 0) {
            for (int i = 0; i < v5Aggregates.length; ++i) {
                IXQEQueryNode v5Agg = v5Aggregates[i];
                int v5AggregateFunctionSubtype = ReplaceV5SummaryFunction.getV5AggregateFunctionSubType(v5Agg);
                SQLAggregate sqlAggregate = ReplaceV5SummaryFunction.createSqlAggregateNode(environment, v5Agg, v5AggregateFunctionSubtype);
                if (v5Agg.getParent() == null) {
                    v5Agg.getChild(0).move(sqlAggregate);
                    aggrExpr = sqlAggregate;
                } else {
                    v5Agg.exchange(sqlAggregate, true);
                }
                if (sqlAggregate.getSubType() != SQLAggregate.SubType.PERCENTILE_CONT) continue;
                ReplaceV5SummaryFunction.convertToPercentileCont(environment.getNodeFactory(), sqlAggregate);
            }
        }
        return aggrExpr;
    }

    private void processSummaryFilters(PlanningEnvironment environment, RQPQuery rqpQuery) {
        CreateRQPSubqueryForSummaryFilters transformation = new CreateRQPSubqueryForSummaryFilters();
        RQPSummaryFilterList sfl = rqpQuery.getSummaryFilterList();
        if (sfl != null) {
            ((Transformation)transformation).apply((IXQEQueryNode)sfl, environment);
        }
        this.updateSubQueryForSummaryFilter(sfl);
        this.modifyOuterQueryToReferenceSummaryFilterSubQuery(sfl, environment);
        sfl.detach();
        RQPQuery sfSubQuery = rqpQuery.getSubqueryForSummaryFilters();
        RQPProjectionList projectionList = sfSubQuery.getProjectionList();
        int[] passNumber = new int[]{1};
        GenerateColumnAlias transformation1 = new GenerateColumnAlias(passNumber);
        ((Transformation)transformation1).apply((IXQEQueryNode)projectionList, environment);
    }

    private void updateSubQueryForSummaryFilter(RQPSummaryFilterList sfl) {
        RQPQuery outerQuery = (RQPQuery)sfl.getParent();
        RQPQuery sfSubQuery = outerQuery.getSubqueryForSummaryFilters();
        sfSubQuery.removeProperty("sqsOwner");
        sfSubQuery.removeProperty("QSNAME");
        sfSubQuery.removeProperty("asViewModelQuery");
        sfSubQuery.removeProperty("asViewSubqueryGeneration");
        RQPDetailFilterList detailFilterList = sfSubQuery.getDetailFilterList();
        if (detailFilterList != null) {
            if (detailFilterList.getNumberChildren() > 0) {
                ArrayList<IXQEQueryNode> nodesToBeDeleted = new ArrayList<IXQEQueryNode>();
                for (IXQEQueryNode child : detailFilterList.getChildren()) {
                    if (child.getType() != 101008 || child.getNumberChildren() != 0) continue;
                    nodesToBeDeleted.add(child);
                }
                for (int i = 0; i < nodesToBeDeleted.size(); ++i) {
                    ((IXQEQueryNode)nodesToBeDeleted.get(i)).extract();
                }
                if (detailFilterList.getNumberChildren() == 0) {
                    detailFilterList.extract();
                }
            } else {
                detailFilterList.extract();
            }
        }
        IXQEQueryNode rqpJoinPath = outerQuery.getFirstChildByType(801039);
        IXQEQueryNode sqlFromClause = outerQuery.getFirstChildByType(301043);
        IXQEQueryNode rqpGroupByList = outerQuery.getFirstChildByType(801013);
        if (rqpJoinPath != null && rqpJoinPath.getNumberChildren() > 0) {
            rqpJoinPath.move(sfSubQuery);
        }
        if (sqlFromClause != null) {
            sqlFromClause.move(sfSubQuery);
        }
        if (rqpGroupByList != null) {
            rqpGroupByList.move(sfSubQuery);
        }
    }

    private void modifyOuterQueryToReferenceSummaryFilterSubQuery(RQPSummaryFilterList sfl, PlanningEnvironment environment) {
        int i;
        RQPQuery outerQuery = RQPNode.getRQPQuery(sfl);
        RQPProjectionList outerQueryProjList = outerQuery.getProjectionList();
        RQPQuery summaryFilterSubQuery = outerQuery.getSubqueryForSummaryFilters();
        RQPProjectionList sfSubQueryProjList = summaryFilterSubQuery.getProjectionList();
        ArrayList<RQPDataItem> projectionsForFilter = new ArrayList<RQPDataItem>();
        int projListSize = outerQueryProjList.getChildren().length;
        for (i = 0; i < projListSize; ++i) {
            RQPDataItemRef existingRef;
            RQPDataItem outerQueryProj = (RQPDataItem)outerQueryProjList.getChild(i);
            if (outerQueryProj.getPropertyValue(PROP_BOOL_FORSUMMARYFILTER) != null) {
                projectionsForFilter.add(outerQueryProj);
                continue;
            }
            IXQEQueryNode outerQueryProjExpr = outerQueryProj.getExpression();
            RQPDataItem sfQueryProj = (RQPDataItem)sfSubQueryProjList.getChild(i);
            if (outerQueryProjExpr.getType() == 801009 && (existingRef = (RQPDataItemRef)outerQueryProjExpr).getQueryName().equals(outerQuery.getName()) && existingRef.getName().equals(sfQueryProj.getName())) continue;
            RQPDataItemRef refToSfQuery = RQPDataItemRef.create(environment, (RQPDataItem)sfSubQueryProjList.getChild(i));
            outerQueryProjExpr.exchange(refToSfQuery);
        }
        for (i = 0; i < projectionsForFilter.size(); ++i) {
            ((IXQEQueryNode)projectionsForFilter.get(i)).detach();
        }
        for (IXQEQueryNode sf : sfl.getChildren()) {
            this.updateItemRefToPointToSFSubQuery(sf, outerQuery, summaryFilterSubQuery);
            sf.detach();
            outerQuery.addToDetailFilterList(environment, sf);
        }
    }

    private void updateItemRefToPointToSFSubQuery(IXQEQueryNode sf, RQPQuery outerQuery, RQPQuery summaryFilterSubQuery) {
        IXQEQueryNode[] itemRefs;
        String sfSubQueryName = summaryFilterSubQuery.getName();
        for (IXQEQueryNode node : itemRefs = sf.getDescendantsOfType(801009, true)) {
            RQPDataItemRef diRef = (RQPDataItemRef)node;
            if (diRef.getQueryName().equals(sfSubQueryName)) continue;
            diRef.setQueryName(sfSubQueryName);
        }
    }

    private RQPQuery buildSubQueryOnTopOfSetOperator(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] rmQIs;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IQuerySubject qs = (IQuerySubject)node.getPropertyValue("sqsOwner");
        SQLRangeVar existingRangeVar = (SQLRangeVar)node.getParent();
        String existingRangeVarName = existingRangeVar.getName();
        IXQEQueryNode existingFromClause = existingRangeVar.getAncestorOfType(301043);
        RQPQuery outerQuery = (RQPQuery)existingFromClause.getParent();
        SQLFromClause newSqlFromClause = (SQLFromClause)nodeFactory.createNode(301043);
        if (qs instanceof MoserQuerySubjectWrapper) {
            IXQEQueryNode[] children;
            for (IXQEQueryNode c : children = existingFromClause.getChildren()) {
                if (c.equals(existingRangeVar)) continue;
                c.detach();
                newSqlFromClause.addChild(c);
            }
        }
        SQLRangeVar newSqlRangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
        newSqlRangeVar.setName(existingRangeVarName);
        RQPQuery newRQPQuery = (RQPQuery)nodeFactory.createNode(801017);
        RQPProjectionList newRQPProjList = newRQPQuery.getOrCreateProjectionList(environment);
        newRQPQuery.setName(existingRangeVarName);
        newSqlFromClause.addChild(newSqlRangeVar);
        newSqlRangeVar.addChild(newRQPQuery);
        existingFromClause.detach();
        newRQPQuery.addChild(existingFromClause);
        String newQueryOperationName = ((SQLSetOperator)node).getSubType().key() + "_" + existingRangeVarName;
        existingRangeVar.setName(newQueryOperationName);
        outerQuery.addChild(newSqlFromClause);
        RMQueryList rmQueryList = this.getRMList(node);
        RMQueryOperation rmQueryOperation = (RMQueryOperation)rmQueryList.getRMQuery(qs);
        if (rmQueryOperation == null) {
            rmQueryOperation = ItemNormalization.getRMQueryOperation(rmQueryList, qs);
        }
        for (IXQEQueryNode item : rmQIs = rmQueryOperation.getRMQueryItemList(environment).getChildren()) {
            RMQueryItem rmQueryItem = (RMQueryItem)item;
            IQueryItem qi = (IQueryItem)rmQueryItem.getQueryItem();
            RQPDataItemRef rqpDIRef = RQPDataItemRef.create(environment, newQueryOperationName, rmQueryItem.getName());
            RQPDataItem newRqpDI = RQPDataItem.create(environment, rmQueryItem.getName());
            newRqpDI.addChild(rqpDIRef);
            newRqpDI.setPropertyValue("queryItem", qi);
            newRQPProjList.addChild(newRqpDI);
        }
        return newRQPQuery;
    }

    private void convertDetailFilterToSummaryFilter(PlanningEnvironment environment, RQPQuery rqpQuery, V5DetailFilter v5DetailFilter) {
        IXQEQueryNode filterExpr = v5DetailFilter.getChild(0);
        IXQEQueryNode[] v5BoundIds = filterExpr.getDescendantsOfType(201116, true);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (int i = 0; i < v5BoundIds.length; ++i) {
            RQPDataItem rqpDI;
            V5BoundModelIdentifier v5ID = (V5BoundModelIdentifier)v5BoundIds[i];
            IQuerySubject qs = this.getQuerySubject(v5ID);
            RQPDataItem aggrExprDI = null;
            aggrExprDI = qs != null && qs.getID().equals(rqpQuery.getSQSOwner().getID()) ? ((rqpDI = rqpQuery.getRQPDataItemByName(v5ID.getMetadata().getCaption())).isGroupingItem() ? this.getAggrExprProjectionForGroupingItem(environment, rqpQuery, rqpDI) : rqpDI) : this.getAggrExprProjectionForQueryItem(environment, rqpQuery, v5ID);
            RQPDataItemRef refToAggExpr = RQPDataItemRef.create(environment, rqpQuery.getName(), aggrExprDI.getName());
            v5ID.exchange(refToAggExpr);
        }
        CopyV5FiltersToRQPQuery.convertToSummaryFilter(environment, rqpQuery, v5DetailFilter, false);
    }

    private IQuerySubject getQuerySubject(V5BoundModelIdentifier v5id) {
        IMetadata metadata = v5id.getMetadata();
        if (metadata instanceof IQueryItem) {
            return ((IQueryItem)metadata).getQuerySubject();
        }
        return null;
    }

    private RQPDataItem getAggrExprProjectionForGroupingItem(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem rqpDI) {
        SQLAggregate minFunction = (SQLAggregate)environment.getNodeFactory().createNode(301034);
        minFunction.setSubType(SQLAggregate.SubType.MIN);
        minFunction.addChild(environment.getNodeFactory().deepCopyNode(rqpDI.getExpression()));
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueRQPDataItemName(rqpQuery, rqpDI.getName()));
        rqpDataItem.addChild(minFunction);
        rqpDataItem.setPropertyValue(PROP_BOOL_FORSUMMARYFILTER, true);
        rqpQuery.addToProjectionList(environment, rqpDataItem);
        return rqpDataItem;
    }

    private RQPDataItem getAggrExprProjectionForQueryItem(PlanningEnvironment environment, RQPQuery rqpQuery, V5BoundModelIdentifier v5Id) {
        IMetadata metadata = v5Id.getMetadata();
        if (!(metadata instanceof IQueryItem)) {
            return null;
        }
        IQueryItem qi = (IQueryItem)metadata;
        IXQEQueryNode aggrExpr = null;
        aggrExpr = this.isTreatedAsGroupingItem(qi.getUsage()) ? this.generateAggrExpr(environment, v5Id, "minimum") : this.generateAggrExpr(environment, v5Id, qi.getRegularAggregate());
        RQPDataItem di = rqpQuery.getRQPDataItemWithSameExpression(aggrExpr);
        if (di == null) {
            di = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueRQPDataItemName(rqpQuery, qi.getCaption()));
            di.addChild(aggrExpr);
            di.setPropertyValue(PROP_BOOL_FORSUMMARYFILTER, true);
            rqpQuery.addToProjectionList(environment, di);
        }
        return di;
    }

    private void addGroupingColumn(PlanningEnvironment environment, RQPQuery rqpQuery, RQPDataItem proj) {
        RQPGroupByList groupByList = rqpQuery.getOrCreateGroupbyList(environment);
        RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, proj.getName());
        groupByList.addChild(selfRef);
        proj.setGroupingItem(true);
    }

    private boolean isTreatedAsGroupingItem(String usage) {
        return "identifier".equals(usage) || "attribute".equals(usage) || "unknown".equals(usage);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        IQuerySubject qs = (IQuerySubject)node.getPropertyValue("sqsOwner");
        if (qs == null) {
            this.traceNodeCondition(false, "This is not a sub query for summary query subject.", xqeTrace);
            return false;
        }
        if (node.getType() == 301018) {
            if (node.getAncestorOfType(801031) != null) {
                this.traceNodeCondition(false, "This SqlSetOperator node is under an RMQueryOperation node.", xqeTrace);
                return false;
            }
            if (this.getRMList(node) == null) {
                this.traceNodeCondition(false, "This SqlSetOperator node is missing RMList an RMQuery nodes.", xqeTrace);
                return false;
            }
        }
        this.traceNodeCondition(true, "This is a sub query for summary query subject.", xqeTrace);
        return true;
    }

    private RMQueryList getRMList(IXQEQueryNode node) {
        IXQEQueryNode existingFromClause = node.getAncestorOfType(301043);
        if (existingFromClause == null) {
            return null;
        }
        RQPQuery outerQuery = (RQPQuery)existingFromClause.getParent();
        if (outerQuery != null && outerQuery.getRMQueryList() != null) {
            return outerQuery.getRMQueryList();
        }
        return this.getRMList(existingFromClause);
    }
}

