/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ApplyJoinFilterOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushFilterToSubQuery
extends RQPTransformation {
    public static final String CONTEXT_LIST = "contextList";

    public PushFilterToSubQuery() {
        this.mName = "PushFilterToSubQuery";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RMQuery rmQuery = this.getRMQuery(node);
        this.moveFilterToSubQuery(environment, node, rmQuery);
    }

    private RMQuery getRMQuery(IXQEQueryNode node) {
        String[] qsNames = (String[])node.getPropertyValue("pushedInSubQuery");
        RMQueryList rmQueryList = RQPUtilities.getRMQueryList(node);
        if (rmQueryList == null) {
            return null;
        }
        if (qsNames != null) {
            for (int i = 0; i < qsNames.length; ++i) {
                RMQuery rmQuery = rmQueryList.getRMQuery(qsNames[i]);
                if (rmQuery == null) continue;
                return rmQuery;
            }
            return null;
        }
        return this.precheck(node, rmQueryList);
    }

    protected RMQuery precheck(IXQEQueryNode node, RMQueryList rmQueryList) {
        int[] cats = new int[]{801017, 801026};
        IXQEQueryNode q = node.getAncestorOfCategories(cats);
        if (q == null) {
            return null;
        }
        if (q.isOfCategory(801026)) {
            return null;
        }
        RQPQuery rqpQuery = (RQPQuery)q;
        IMetadata qs = PushFilterToSubQuery.getSingleQuerySubject(node, true);
        if (qs == null) {
            return null;
        }
        if (!PushFilterToSubQuery.checkOuterJoin(rqpQuery.getJoinPath(), qs)) {
            return null;
        }
        return PushFilterToSubQuery.getRMQueryMoreCheck(node, rmQueryList, qs, true);
    }

    protected static IMetadata getSingleQuerySubject(IXQEQueryNode node, boolean b) {
        IXQEQueryNode[] ids;
        IMetadata qs = null;
        for (IXQEQueryNode id : ids = node.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier modelID = (V5BoundModelIdentifier)id;
            IQuerySubject theQS = modelID.getQuerySubject();
            if (theQS == null || theQS.getQuerySubjectUsage() == IQuerySubject.QuerySubjectUsageEnum.SUMMARY_QUERY) {
                return null;
            }
            if (b && theQS.getSelectListControl() != IQuerySubject.SelectListControl.USEDQUERYITEMS) {
                return null;
            }
            IMetadata aQS = (IMetadata)ApplyJoinFilterOptimization.getQSOrShortcut(theQS);
            if (aQS == null) {
                return null;
            }
            if (qs == null) {
                qs = aQS;
                continue;
            }
            if (qs.equals(aQS)) continue;
            return null;
        }
        return qs;
    }

    protected static RMQuery getRMQueryMoreCheck(IXQEQueryNode node, RMQueryList rmQueryList, IMetadata qs, boolean b) {
        Set ctxList;
        IXQEQueryNode rmLayer;
        if (b && (rmLayer = node.getAncestorOfTypes(new int[]{801032})) != null) {
            return null;
        }
        if (!node.getDescendantsOfTypeOrdered(201060, false).isEmpty()) {
            return null;
        }
        RMQuery rmQuery = rmQueryList.getRMQuery(qs);
        if (rmQuery == null) {
            return null;
        }
        IXQEQueryNode[] childOfType = rmQuery.getChildrenOfType(801034);
        if (childOfType.length == 1) {
            IXQEQueryNode[] rmQIs;
            for (IXQEQueryNode item : rmQIs = childOfType[0].getChildren()) {
                RMQueryItem rmQueryItem = (RMQueryItem)item;
                if (rmQueryItem.getCount() <= 0 || item.getDescendantsOfTypeOrdered(201031, false).isEmpty()) continue;
                return null;
            }
        }
        if ((ctxList = (Set)rmQuery.getPropertyValue(CONTEXT_LIST)) == null || ctxList.size() != 1) {
            return null;
        }
        return rmQuery;
    }

    protected static boolean checkOuterJoin(RQPJoinPath joinPath, IMetadata qs) {
        if (joinPath == null) {
            return true;
        }
        HashMap<IMetadata, HashMap<IMetadata, Boolean>> mp = new HashMap<IMetadata, HashMap<IMetadata, Boolean>>();
        List<IMetadata> joinPaths = joinPath.getJoinPath();
        for (IMetadata join : joinPaths) {
            IRelationship relationship = (IRelationship)join;
            IMetadata lhs = relationship.getLeftRefObject();
            IMetadata rhs = relationship.getRightRefObject();
            Boolean bLeftOut = Boolean.FALSE;
            if (relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getLeftCardinality() == IRelationship.Cardinality.ZERO_MANY) {
                bLeftOut = Boolean.TRUE;
            }
            Boolean bRightOut = Boolean.FALSE;
            if (relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_ONE || relationship.getRightCardinality() == IRelationship.Cardinality.ZERO_MANY) {
                bRightOut = Boolean.TRUE;
            }
            PushFilterToSubQuery.addToMap(rhs, lhs, bLeftOut, mp);
            PushFilterToSubQuery.addToMap(lhs, rhs, bRightOut, mp);
        }
        if (!mp.containsKey(qs)) {
            return false;
        }
        LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
        return !PushFilterToSubQuery.outerJoin(qs, mp, stack);
    }

    protected static void addToMap(IMetadata key, IMetadata v, Boolean b, HashMap<IMetadata, HashMap<IMetadata, Boolean>> mp) {
        HashMap<IMetadata, Boolean> val = mp.get(key);
        if (val == null) {
            val = new HashMap();
            mp.put(key, val);
        }
        val.put(v, b);
    }

    protected static boolean outerJoin(IMetadata qs, HashMap<IMetadata, HashMap<IMetadata, Boolean>> mp, LinkedList<IMetadata> stack) {
        if (stack.contains(qs)) {
            return false;
        }
        HashMap<IMetadata, Boolean> v = mp.get(qs);
        if (v == null || v.isEmpty()) {
            return false;
        }
        stack.addLast(qs);
        for (Map.Entry<IMetadata, Boolean> e : v.entrySet()) {
            Boolean b;
            IMetadata kk = e.getKey();
            if (stack.contains(kk) || !Boolean.TRUE.equals(b = e.getValue()) && !PushFilterToSubQuery.outerJoin(kk, mp, stack)) continue;
            stack.removeLast();
            return true;
        }
        stack.removeLast();
        return false;
    }

    private void moveFilterToSubQuery(PlanningEnvironment environment, IXQEQueryNode v5DetailFilter, RMQuery rmQuery) {
        Object orgExp;
        IXQEQueryNode parentNode = v5DetailFilter.getParent();
        v5DetailFilter.detach();
        RMEmbeddedFilterList rmFilterList = rmQuery.getRMEmbeddedFilterList(environment);
        RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, v5DetailFilter, "filterDefinition", "always");
        rmFilterList.addChild(rmEmbeddedFilter);
        Object jExpr = v5DetailFilter.getPropertyValue("orgFltExpr");
        if (jExpr != null) {
            rmEmbeddedFilter.setPropertyValue("orgFltExpr", jExpr);
        }
        if ((orgExp = v5DetailFilter.getPropertyValue("originalExpression")) != null) {
            rmEmbeddedFilter.setPropertyValue("originalExpression", orgExp);
        }
        rmEmbeddedFilter.setPropertyValue("fromV5Filter", Boolean.TRUE);
        v5DetailFilter.extract();
        if (parentNode.getNumberChildren() == 0) {
            parentNode.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(true, "The filter is not under a relational query", xqeTrace);
            return false;
        }
        if (this.getRMQuery(node) == null) {
            this.traceNodeCondition(false, "The query subject involved in the filter is not yet instantiated", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "This filter needs to be pushed in sub-query", xqeTrace);
        return true;
    }
}

