/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;

public class TransferJoinPathToFromClause
extends RQPTransformation {
    public TransferJoinPathToFromClause() {
        this.mName = "Build Join Path";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{301043};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RQPQuery rqpQuery = (RQPQuery)node.getParent();
        RQPJoinPath rqpJoinPath = (RQPJoinPath)rqpQuery.getFirstChildByType(801039);
        TransferJoinPathToFromClause.transferJoinPath(nodeFactory, node, rqpJoinPath);
    }

    public static void transferJoinPath(IXQENodeFactory nodeFactory, IXQEQueryNode sqlFromClause, RQPJoinPath rqpJoinPath) {
        if (rqpJoinPath != null) {
            List<IMetadata> goodJoinPath = rqpJoinPath.getJoinPath();
            if (goodJoinPath == null) {
                rqpJoinPath.detach();
                return;
            }
            RQPJoinPath joinPath = (RQPJoinPath)nodeFactory.createNode(801039);
            sqlFromClause.addChild(joinPath);
            ArrayList<IMetadata> newJoinPath = new ArrayList<IMetadata>(goodJoinPath);
            joinPath.setJoinPath(newJoinPath);
            rqpJoinPath.move(joinPath);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPJoinPath rqpJoinPath = null;
        rqpJoinPath = (RQPJoinPath)node.getFirstChildByType(801039);
        if (rqpJoinPath != null) {
            this.traceNodeCondition(false, "Join path already transferred.", xqeTrace);
            return false;
        }
        IXQEQueryNode rqpQuery = node.getParent();
        if (!(rqpQuery instanceof RQPQuery)) {
            this.traceNodeCondition(false, "Only applicable for RQPQuery.", xqeTrace);
            return false;
        }
        String reasonForTrace = "";
        boolean result = TransferJoinPathToFromClause.canTransferJoinPath(reasonForTrace, rqpQuery);
        this.traceNodeCondition(result, reasonForTrace, xqeTrace);
        return result;
    }

    public static boolean canTransferJoinPath(String reasonForTrace, IXQEQueryNode parentWithJoinPath) {
        RQPJoinPath rqpJoinPath = null;
        rqpJoinPath = (RQPJoinPath)parentWithJoinPath.getFirstChildByType(801039);
        if (rqpJoinPath == null) {
            reasonForTrace = "No join path to transfer.";
            return false;
        }
        List<IMetadata> goodJoinPath = rqpJoinPath.getJoinPath();
        if (goodJoinPath == null || goodJoinPath.size() == 0) {
            reasonForTrace = "Empty Join path.";
            return false;
        }
        reasonForTrace = "Transfer the join path.";
        return true;
    }
}

