/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class CheckCaseDataTypesCompatibility
extends RQPTransformation {
    public static final String PROP_CHECKED_CASE_DATATYPES = "checkedCaseDatatypes";

    public CheckCaseDataTypesCompatibility() {
        this.mName = "CheckCaseDataTypesCompatibility";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{201018, 201020};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean isLookupExpr;
        boolean bl = isLookupExpr = node.getType() == 201020;
        if (!this.checkDatatypeConsistencyInExpression(node)) {
            String parmMsg = isLookupExpr ? "lookup" : "case when";
            IXQEQueryNode p = node.getAncestorOfType(801008);
            if (p == null) {
                p = node.getAncestorOfType(101003);
            }
            if (p != null) {
                String n = (String)p.getPropertyValue("name");
                V5DataItem di = RQPUtilities.getV5DataItemInSelection(node, n);
                ResponseMessage respMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.PLN_IncompatibleDatatypesInCaseLookup, parmMsg);
                ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(respMsg, di, environment.getRoot());
            }
        }
        node.setPropertyValue(PROP_CHECKED_CASE_DATATYPES, "");
    }

    private boolean checkDatatypeConsistencyInExpression(IXQEQueryNode node) {
        int[] nodeTypesV5CaseWhenAndV5LookupMap = new int[]{201019, 201021};
        IXQEQueryNode firstChild = node.getChild(0);
        IXQEQueryNode lastChild = node.getChild(node.getNumberChildren() - 1);
        IXQEQueryNode[] caseWhenNodeList = node.getChildrenOfTypes(nodeTypesV5CaseWhenAndV5LookupMap);
        IDataType dataTypeToCompare = null;
        if (lastChild.getType() != 201019) {
            dataTypeToCompare = RQPUtilities.getNodeDataType(lastChild);
        }
        if (dataTypeToCompare == null || lastChild.getType() == 201042 && (dataTypeToCompare instanceof VariantType || dataTypeToCompare instanceof UnknownType)) {
            int nodeIndex = 1;
            dataTypeToCompare = this.getDataTypeToCompare(caseWhenNodeList, nodeIndex);
        }
        if (dataTypeToCompare != null) {
            for (IXQEQueryNode queryNode : caseWhenNodeList) {
                IXQEQueryNode nextNodeToCompare = queryNode.getChild(1);
                IDataType nextDataTypeToCompare = RQPUtilities.getNodeDataType(nextNodeToCompare);
                if (nextNodeToCompare.getType() == 201042 && (nextDataTypeToCompare instanceof VariantType || nextDataTypeToCompare instanceof UnknownType) || DataTypeComparator.areCompatibleDataTypes(dataTypeToCompare, nextDataTypeToCompare)) continue;
                return false;
            }
        }
        if (firstChild.getType() != 201019) {
            IDataType caseExprDatatype = RQPUtilities.getNodeDataType(firstChild);
            if (firstChild.getType() == 201042 && (caseExprDatatype instanceof VariantType || caseExprDatatype instanceof UnknownType)) {
                int nodeIndex = 0;
                caseExprDatatype = this.getDataTypeToCompare(caseWhenNodeList, nodeIndex);
            }
            for (IXQEQueryNode queryNode : caseWhenNodeList) {
                IXQEQueryNode nextNodeToCompare = queryNode.getChild(0);
                IDataType nextDataTypeToCompare = RQPUtilities.getNodeDataType(nextNodeToCompare);
                if (nextNodeToCompare.getType() == 201042 && (nextDataTypeToCompare instanceof VariantType || nextDataTypeToCompare instanceof UnknownType) || DataTypeComparator.areCompatibleDataTypes(caseExprDatatype, nextDataTypeToCompare)) continue;
                return false;
            }
        }
        return true;
    }

    private IDataType getDataTypeToCompare(IXQEQueryNode[] caseWhenNodeList, int nodeIndex) {
        for (IXQEQueryNode queryNode : caseWhenNodeList) {
            IXQEQueryNode nextChildToCompare = queryNode.getChild(nodeIndex);
            IDataType dataTypeToCompare = RQPUtilities.getNodeDataType(queryNode.getChild(nodeIndex));
            if (nextChildToCompare.getType() == 201042 && (dataTypeToCompare instanceof VariantType || dataTypeToCompare instanceof UnknownType)) continue;
            return dataTypeToCompare;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        return node.getPropertyValue(PROP_CHECKED_CASE_DATATYPES) == null;
    }
}

