/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLSortKeyList;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;

public class FinalizeSQL
extends Transformation {
    public FinalizeSQL() {
        this.mName = "Replace RQPQuery with one of: SQLSort/SQLGroupBy/SQLProject";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{801017, 801025, 801024, 801012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        this.moveProjectionListToSQLGroupBy(node, environment);
        this.moveFromClause(node, environment);
        this.deleteEmptySQLProject(node, environment);
        this.deleteEmptySubqueryList(node, environment);
        this.moveSQLFilterUnderSQLGroupByOrSqlProject(node, environment);
        this.replaceRQPQueryWithNewRoot(node, environment);
    }

    private void deleteEmptySQLProject(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlProject = node.getFirstChildByType(301015);
        if (sqlProject == null) {
            return;
        }
        if (sqlProject.getNumberChildren() == 0) {
            node.detachChild(sqlProject);
        }
    }

    private void deleteEmptySubqueryList(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode subqueryList = node.getFirstChildByType(801022);
        if (subqueryList == null) {
            return;
        }
        if (subqueryList.getNumberChildren() == 0) {
            node.detachChild(subqueryList);
        }
    }

    private void moveFromClause(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode fromClause;
        IXQEQueryNode sqlGroupBy;
        IXQEQueryNode sqlFilter;
        IXQEQueryNode parentOfFromClause = null;
        IXQEQueryNode sqlSummaryFilter = node.getFirstChildByType(301053);
        if (sqlSummaryFilter != null) {
            parentOfFromClause = sqlSummaryFilter;
        }
        if ((sqlFilter = node.getFirstChildByType(301009)) != null) {
            parentOfFromClause = sqlFilter;
        }
        if (parentOfFromClause == null && (sqlGroupBy = node.getFirstChildByType(301010)) != null) {
            parentOfFromClause = sqlGroupBy;
        }
        if (parentOfFromClause == null) {
            IXQEQueryNode sqlProject = node.getFirstChildByType(301015);
            if (sqlProject == null) {
                sqlProject = environment.getNodeFactory().createNode(301015);
                node.addChild(sqlProject);
            }
            parentOfFromClause = sqlProject;
        }
        if (null != (fromClause = node.getFirstChildByType(301043))) {
            fromClause.move(parentOfFromClause, 0);
        }
    }

    private void moveProjectionListToSQLGroupBy(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlGroupBy = node.getFirstChildByType(301010);
        if (sqlGroupBy == null) {
            return;
        }
        IXQEQueryNode sqlProject = node.getFirstChildByType(301015);
        IXQEQueryNode projectionList = sqlProject.getFirstChildByType(301030);
        projectionList.move(sqlGroupBy, 0);
    }

    private void moveSQLFilterUnderSQLGroupByOrSqlProject(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlFilter;
        IXQEQueryNode sqlGroupByOrSqlProject = node.getFirstChildByType(301010);
        if (sqlGroupByOrSqlProject == null) {
            sqlGroupByOrSqlProject = node.getFirstChildByType(301015);
        }
        if (sqlGroupByOrSqlProject == null) {
            return;
        }
        IXQEQueryNode sqlSummarylFilter = node.getFirstChildByType(301053);
        if (sqlSummarylFilter != null) {
            sqlSummarylFilter.move(sqlGroupByOrSqlProject, 0);
        }
        if ((sqlFilter = node.getFirstChildByType(301009)) == null) {
            return;
        }
        if (sqlSummarylFilter != null) {
            sqlFilter.move(sqlSummarylFilter, 0);
        } else {
            sqlFilter.move(sqlGroupByOrSqlProject, 0);
        }
    }

    private void replaceRQPQueryWithNewRoot(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode sqlGroupBy;
        IXQEQueryNode sqlASTRoot = null;
        IXQEQueryNode sqlSort = node.getFirstChildByType(301019);
        if (sqlSort != null) {
            sqlASTRoot = sqlSort;
        }
        if (sqlASTRoot == null && (sqlGroupBy = node.getFirstChildByType(301010)) != null) {
            sqlASTRoot = sqlGroupBy;
        }
        if (sqlASTRoot == null) {
            IXQEQueryNode sqlProject;
            sqlASTRoot = sqlProject = node.getFirstChildByType(301015);
        }
        if (1 < node.getNumberChildren()) {
            for (int i = 0; i < node.getNumberChildren(); ++i) {
                if (node.getChild(i) == sqlASTRoot) continue;
                node.getChild(i).move(sqlASTRoot);
            }
        }
        if (sqlASTRoot.getType() == 301019) {
            int numOfChildren = sqlASTRoot.getNumberChildren();
            SQLSortKeyList sortKeyList = (SQLSortKeyList)sqlASTRoot.getFirstChildByType(301021);
            if (sqlASTRoot.getPositionOfChild(sortKeyList) != numOfChildren - 1) {
                sqlASTRoot.detachChild(sortKeyList);
                sqlASTRoot.addChild(sortKeyList);
            }
        }
        this.generateDistinct(node, environment, sqlASTRoot);
        this.putSQLSortOnTopOfWithClause(sqlASTRoot);
    }

    private void putSQLSortOnTopOfWithClause(IXQEQueryNode sqlASTRoot) {
        IXQEQueryNode rqpQueryParent;
        if (sqlASTRoot.getType() != 301019) {
            return;
        }
        IXQEQueryNode parent = sqlASTRoot.getParent();
        if (parent != null && parent.getType() == 801017 && (rqpQueryParent = parent.getParent()) != null && rqpQueryParent.getType() == 301022) {
            IXQEQueryNode sqlSortKeyList = sqlASTRoot.detachChild(1);
            IXQEQueryNode sqlSort = sqlASTRoot.extract();
            rqpQueryParent.insertParent(sqlSort);
            sqlSort.addChild(sqlSortKeyList);
        }
    }

    private void generateDistinct(IXQEQueryNode node, PlanningEnvironment environment, IXQEQueryNode sqlASTRoot) {
        Object distinctProperty = node.getPropertyValue("distinct");
        if (distinctProperty != null && ((Boolean)distinctProperty).booleanValue()) {
            IXQEQueryNode sqlDistinct = environment.getNodeFactory().createNode(301008);
            IXQEQueryNode sqlGroupByOrSqlProject = null;
            switch (sqlASTRoot.getType()) {
                case 301019: {
                    sqlGroupByOrSqlProject = sqlASTRoot.getFirstChildByType(301010);
                    if (sqlGroupByOrSqlProject != null) break;
                    sqlGroupByOrSqlProject = sqlASTRoot.getFirstChildByType(301015);
                    break;
                }
                default: {
                    sqlGroupByOrSqlProject = sqlASTRoot;
                }
            }
            IXQEQueryNode detachNode = sqlGroupByOrSqlProject.exchange(sqlDistinct);
            sqlDistinct.addChild(detachNode);
        }
    }
}

