/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLIsDistinctFrom;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.IsQueryReusable;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.MDOLogger;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class GenerateDetailQueryForReuse
extends RQPTransformation {
    public GenerateDetailQueryForReuse() {
        this.mName = "Generate Detail Query For Reuse.";
        this.mPassNumbers = new int[]{55};
        this.mTypes = new int[]{301009};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLFilter filter = (SQLFilter)node;
        XQENodeFactory factory = environment.getNodeFactory();
        List<IXQEQueryNode> masterDetailFilters = this.getMasterDetailFiltersAndDetach(filter);
        IXQEQueryNode projectionNode = this.findProjectionNode(filter);
        RQPQuery rqpQuery = (RQPQuery)filter.getAncestorOfType(801017);
        String origSqlRangeVarName = rqpQuery.getName();
        String newSqlRangeVarName = origSqlRangeVarName + "_reusableDQ";
        this.transformEqualToSQLIsNotDistinctFrom(masterDetailFilters, factory);
        this.extractsInvalidFilterExpressionNodes(filter);
        IXQEQueryNode newFilter = this.createSQLFilterNodeWithMasterDetailFilters(factory, masterDetailFilters, newSqlRangeVarName, projectionNode);
        this.makeReusableSubquery(factory, projectionNode, newSqlRangeVarName, newFilter);
        this.updateQueryDependencyMap(newFilter, origSqlRangeVarName, newSqlRangeVarName);
        this.setPropertyForCognosSQLMessage(environment, newFilter);
    }

    private void updateQueryDependencyMap(IXQEQueryNode node, String origQueryName, String newQueryName) {
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(node);
        TreeMap queryDependencyMap = (TreeMap)rootQuerySet.getPropertyValue("queryDependencyMap");
        TreeSet dependList = (TreeSet)queryDependencyMap.get(origQueryName);
        if (dependList != null) {
            queryDependencyMap.put(newQueryName, dependList);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPSql rqpSql;
        Object isQueryReusable;
        if (!this.superPassesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        SQLFilter filter = (SQLFilter)node;
        if (!this.hasAtLeastOneMasterDetailFilter(filter)) {
            this.traceQueryCondition(false, "No master-detail filters to process.", trace);
            return false;
        }
        RQPQuery rqpQuery = (RQPQuery)filter.getAncestorOfType(801017);
        IXQEQueryNode rqpSqlNode = filter.getAncestorOfType(801041);
        if (rqpSqlNode != null && (isQueryReusable = (rqpSql = (RQPSql)rqpSqlNode).isQueryReusable()) != null && !((Boolean)isQueryReusable).booleanValue()) {
            this.traceQueryCondition(false, "No UDF can exist in the QRD.", trace);
            MDOLogger.logMDODisabledUDF(environment, rqpSqlNode);
            return false;
        }
        Governors.LocalCachePolicy localCachePolicy = RQPUtilities.getLocalCachePolicyFromGovernors(environment, filter);
        boolean allowReuseOfParameterizedQueries = QueryReuseManager.getInstance().isReuseOfParameterizedQueriesAllowed();
        if (localCachePolicy == Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT && !allowReuseOfParameterizedQueries && this.hasSQLParametersExcludesMDParameters(rqpSqlNode)) {
            this.traceQueryCondition(false, "In QUERY_REFERENCED_BY_LAYOUT mode, no parameters can exist in the QRD.", trace);
            MDOLogger.logMDODisabledParameters(environment, rqpSqlNode);
            return false;
        }
        if (localCachePolicy == Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY && !allowReuseOfParameterizedQueries && this.hasSQLParametersExcludesMDParameters(rqpQuery)) {
            this.traceQueryCondition(false, "In EXPLICITLY_PER_QUERY mode, no parameters can exist in the query.", trace);
            MDOLogger.logMDODisabledParameters(environment, rqpQuery);
            return false;
        }
        if (localCachePolicy == Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY) {
            if (IsQueryReusable.hasDependentV5Queries(filter)) {
                return false;
            }
            IXQEQueryNode groupByNode = this.getGroupByNode(filter);
            if (groupByNode == null) {
                this.traceQueryCondition(false, "Not groupby expression.", trace);
                MDOLogger.logMDODisabledNotGroupBy(environment, rqpQuery);
                return false;
            }
            if (!allowReuseOfParameterizedQueries && this.hasSQLParametersExcludesMDParameters(rqpQuery)) {
                this.traceQueryCondition(false, "In Contains parameters that is not master-detail parameters.", trace);
                MDOLogger.logMDODisabledParameters(environment, rqpQuery);
                return false;
            }
        }
        return true;
    }

    private List<IXQEQueryNode> getMasterDetailFiltersAndDetach(SQLFilter filter) {
        ArrayList<IXQEQueryNode> masterDetailFilters = new ArrayList<IXQEQueryNode>();
        SQLExpression predicate = filter.getPredicate();
        List<IXQEQueryNode> descs = predicate.getDescendantsOfTypeOrdered(301026, true);
        for (IXQEQueryNode desc : descs) {
            if (desc.getPropertyValue("useQueryReuse") == null) continue;
            desc.detach();
            masterDetailFilters.add(desc);
        }
        return masterDetailFilters;
    }

    private boolean hasAtLeastOneMasterDetailFilter(SQLFilter filter) {
        IXQEQueryNode[] descs;
        SQLExpression predicate = filter.getPredicate();
        for (IXQEQueryNode desc : descs = predicate.getDescendantsOfType(301026, true)) {
            if (desc.getPropertyValue("useQueryReuse") == null) continue;
            return true;
        }
        return false;
    }

    private IXQEQueryNode getGroupByNode(IXQEQueryNode masterDetailFilter) {
        IXQEQueryNode groupBy = masterDetailFilter.getAncestorOfTypeWithAnchor(301010, 301007);
        if (groupBy == null) {
            groupBy = masterDetailFilter.getAncestorOfTypeWithAnchor(301010, 801041);
        }
        return groupBy;
    }

    private void extractsInvalidFilterExpressionNodes(SQLFilter sqlFilter) {
        if (sqlFilter.getNumberChildren() <= 1) {
            sqlFilter.extract();
            return;
        }
        if (sqlFilter.getNumberChildren() == 2) {
            IXQEQueryNode[] sqlLogicals;
            SQLExpression predicate = sqlFilter.getPredicate();
            for (IXQEQueryNode sqlLogical : sqlLogicals = predicate.getDescendantsOfType(301027, true)) {
                if (sqlLogical.getNumberChildren() > 1) continue;
                sqlLogical.extract();
            }
        }
        if (sqlFilter.getNumberChildren() <= 1) {
            sqlFilter.extract();
        }
    }

    private IXQEQueryNode makeReusableSubquery(IXQENodeFactory factory, IXQEQueryNode inputQuery, String cursorName, IXQEQueryNode filter) {
        IXQEQueryNode topNode = inputQuery.getParent();
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        if (projectionNode == null) {
            return null;
        }
        IXQEQueryNode valueList = projectionNode.getFirstChildByType(301030);
        IXQEQueryNode[] columnRefs = this.createColumnReferences(factory, valueList, cursorName);
        SQLQueryNode cValueList = (SQLQueryNode)factory.createNode(301030);
        cValueList.addChildren(columnRefs, 0);
        SQLRangeVar reusableRangeVar = (SQLRangeVar)factory.createNode(301007);
        reusableRangeVar.setName(cursorName);
        reusableRangeVar.setQueryReusable(true);
        IXQEQueryNode child = topNode.detachChild(0);
        SQLProject newSqlProject = (SQLProject)factory.createNode(301015);
        topNode.addChild(newSqlProject);
        filter.addChild(reusableRangeVar, 0);
        newSqlProject.addChild(filter);
        newSqlProject.addChild(cValueList);
        reusableRangeVar.addChild(child);
        return reusableRangeVar;
    }

    private IXQEQueryNode[] createColumnReferences(IXQENodeFactory factory, IXQEQueryNode valueList, String cursorName) {
        int numOfProjItems = valueList.getNumberChildren();
        IXQEQueryNode[] columnRefs = new IXQEQueryNode[numOfProjItems];
        for (int i = 0; i < numOfProjItems; ++i) {
            SQLAlias alias = (SQLAlias)valueList.getChild(i);
            SQLAlias cAlias = (SQLAlias)factory.copyNode(alias);
            SQLColumn columnRef = RQPUtilities.createSQLColumn(factory, cursorName, alias.getName());
            cAlias.addChild(columnRef);
            columnRefs[i] = cAlias;
        }
        return columnRefs;
    }

    private IXQEQueryNode findProjectionNode(IXQEQueryNode node) {
        IXQEQueryNode projectionNode = null;
        IXQEQueryNode parent = node.getParent();
        block0: while (projectionNode == null) {
            if (parent.getNumberChildren() == 1) {
                parent = parent.getParent();
                continue;
            }
            for (IXQEQueryNode child : parent.getChildren()) {
                if (child.getType() != 301030) continue;
                projectionNode = parent;
                continue block0;
            }
        }
        return projectionNode;
    }

    private boolean hasSQLParametersExcludesMDParameters(IXQEQueryNode node) {
        IXQEQueryNode[] descs;
        for (IXQEQueryNode descendant : descs = node.getDescendantsOfType(301051, true)) {
            SQLComparison sqlComparison;
            IXQEQueryNode parent = descendant.getParent();
            if (parent.getType() == 301026 && (sqlComparison = (SQLComparison)parent).getPropertyValue("useQueryReuse") != null) continue;
            return true;
        }
        return false;
    }

    private void transformEqualToSQLIsNotDistinctFrom(List<IXQEQueryNode> masterDetailFilters, IXQENodeFactory factory) {
        for (int i = 0; i < masterDetailFilters.size(); ++i) {
            IXQEQueryNode filter = masterDetailFilters.get(i);
            if (filter.getType() != 301026) continue;
            SQLIsDistinctFrom sqlIsDistinctFrom = (SQLIsDistinctFrom)factory.createNode(301075);
            sqlIsDistinctFrom.setNegated(true);
            sqlIsDistinctFrom.addChildren(filter.getChildren(), 0);
            masterDetailFilters.set(i, sqlIsDistinctFrom);
        }
    }

    private IXQEQueryNode createSQLFilterNodeWithMasterDetailFilters(IXQENodeFactory factory, List<IXQEQueryNode> masterDetailFilters, String subqueryName, IXQEQueryNode projectionNode) {
        SQLFilter sqlFilter = null;
        if (masterDetailFilters.size() > 0) {
            sqlFilter = (SQLFilter)factory.createNode(301009);
            if (masterDetailFilters.size() == 1) {
                IXQEQueryNode filter = masterDetailFilters.get(0);
                this.exchangeMasterDetailFilterWithProjectionAlias(factory, filter, projectionNode, subqueryName);
                sqlFilter.addChild(filter);
            } else {
                SQLLogical logicalAND = (SQLLogical)factory.createNode(301027);
                logicalAND.setSubType(SQLLogical.SubType.AND);
                for (int i = 0; i < masterDetailFilters.size(); ++i) {
                    IXQEQueryNode filter = masterDetailFilters.get(i);
                    this.exchangeMasterDetailFilterWithProjectionAlias(factory, filter, projectionNode, subqueryName);
                    if (logicalAND.getNumberChildren() != 2) {
                        logicalAND.addChild(filter);
                        continue;
                    }
                    SQLLogical temp = (SQLLogical)factory.createNode(301027);
                    temp.setSubType(SQLLogical.SubType.AND);
                    temp.addChild(logicalAND);
                    temp.addChild(filter);
                    logicalAND = temp;
                }
                sqlFilter.addChild(logicalAND);
            }
        }
        return sqlFilter;
    }

    private void exchangeMasterDetailFilterWithProjectionAlias(IXQENodeFactory factory, IXQEQueryNode masterDetailFilter, IXQEQueryNode projectionNode, String subqueryName) {
        IXQEQueryNode expression = masterDetailFilter.getChild(0);
        String aliasName = null;
        IXQEQueryNode sqlValueList = projectionNode.getFirstChildByType(301030);
        for (IXQEQueryNode projItem : sqlValueList.getChildren()) {
            if (projItem.getType() != 301028 || !projItem.getChild(0).isSameExpression(expression, false)) continue;
            aliasName = ((SQLAlias)projItem).getName();
        }
        SQLColumn sqlColumn = (SQLColumn)factory.createNode(301005);
        sqlColumn.setTableName(subqueryName);
        sqlColumn.setName(aliasName);
        expression.exchange(sqlColumn);
    }

    private void setPropertyForCognosSQLMessage(PlanningEnvironment environment, IXQEQueryNode node) {
        RSAPIDataset dataSet;
        if ((MDOLogger.isKeyTransformationSeverity(environment) || MDOLogger.isMDODiagnosticOn(environment)) && (dataSet = (RSAPIDataset)node.getAncestorOfType(401005)) != null) {
            dataSet.setSqlToMessageFolderToTrue();
        }
    }
}

