/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.ReuseQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class IsQueryReusable
extends RQPTransformation {
    private static final String COMMA = ",";
    private static final String REPORT = "REPORT=";
    private static final String QUERY = ", QUERY=";

    public IsQueryReusable() {
        this.mName = "IsQueryReusable";
        this.mPassNumbers = new int[]{54};
        this.mTypes = new int[]{301007, 801041};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getType() == 801041) {
            RQPSql rqpSql = (RQPSql)node;
            rqpSql.setQueryReusable(true);
            return;
        }
        SQLRangeVar rangeVar = (SQLRangeVar)node;
        rangeVar.setQueryReusable(true);
    }

    public static String getTopQueryName(IXQEQueryNode node) {
        if (node.getType() == 801041) {
            return ((RQPQuery)((RQPSql)node).getMainRQPQuery()).getRefV5Query().getV5QueryName();
        }
        QTEQueryNode topQuery = null;
        IXQEQueryNode parent = node.getParent();
        while (parent != null) {
            if (parent.getType() == 301007 || parent.getType() == 801017) {
                IXQEQueryNode grandParent = parent.getParent();
                if (grandParent != null && grandParent.getType() == 301022) {
                    topQuery = parent;
                    break;
                }
                parent = grandParent;
                continue;
            }
            parent = parent.getParent();
        }
        if (topQuery != null) {
            if (topQuery.getType() == 301007) {
                return ((SQLRangeVar)topQuery).getName();
            }
            return ((RQPQuery)topQuery).getRefV5Query().getV5QueryName();
        }
        return null;
    }

    private boolean hasNestedSubQueryCandidateForQueryReuse(IXQEQueryNode node) {
        IXQEQueryNode[] subqueries;
        for (IXQEQueryNode subquery : subqueries = node.getDescendantsOfType(301007, false)) {
            if (!((SQLRangeVar)subquery).isCandidateForQueryReuse().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDependentV5Queries(IXQEQueryNode node) {
        V5QuerySet rootQuerySet;
        TreeSet<String> dependentQueries;
        String v5QueryName = IsQueryReusable.getTopQueryName(node);
        return v5QueryName != null && (dependentQueries = (rootQuerySet = V5QuerySet.getRootQuerySet(node)).getDependentQueriesOf(v5QueryName)) != null && !dependentQueries.isEmpty();
    }

    private boolean isGroupedQuery(IXQEQueryNode rqpQuery) {
        IXQEQueryNode child = this.getSQLRoot(rqpQuery);
        return child != null && child.getType() == 301010;
    }

    private IXQEQueryNode getSQLRoot(IXQEQueryNode rqpQuery) {
        IXQEQueryNode child = rqpQuery.getChild(0);
        if (child != null && child.getType() == 301019) {
            if ((child = child.getChild(0)) != null && child.getType() == 301008) {
                child = child.getChild(0);
            }
        } else if (child != null && child.getType() == 301008) {
            child = child.getChild(0);
        }
        return child;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object nativeSQL;
        String topNRows;
        if (System.getProperties().containsKey("SERVICE_PREFIX")) {
            return false;
        }
        RQPSql rqpSql = null;
        SQLRangeVar rangeVar = null;
        if (node.getType() == 301007) {
            rangeVar = (SQLRangeVar)node;
            if (rangeVar.getChild(0).getType() == 301016) {
                return false;
            }
            rqpSql = (RQPSql)node.getAncestorOfType(801041);
        } else {
            rqpSql = (RQPSql)node;
        }
        if (rqpSql == null) {
            return false;
        }
        boolean dashboardContext = false;
        if (node.getGovernors() != null && node.getGovernors().isDashboardContext().booleanValue()) {
            dashboardContext = true;
        }
        if (!dashboardContext && (topNRows = (String)rqpSql.getPropertyValue("topNRows")) != null) {
            return false;
        }
        QueryReuseManager qrm = (QueryReuseManager)((RequestEnvironment)environment.getRequestEnvironment()).getQueryReuseManager();
        Object property = rqpSql.getPropertyValue("relationalSubquery");
        Object propertySource = rqpSql.getPropertyValue("relationalSubquerySource");
        if (property != null && propertySource != null) {
            String relSubquerySourceName = (String)propertySource;
            if (relSubquerySourceName.equals(V5Query.RelationalSubquerySource.XTABREL.getName())) {
                if (!qrm.isOptimizeXtabRelationalEnabled()) {
                    this.addQRMTraceLog(environment, rqpSql.getName(), "relational crosstab sub query");
                    return false;
                }
            } else {
                if (relSubquerySourceName.equals(V5Query.RelationalSubquerySource.ROLAP.getName())) {
                    this.addQRMTraceLog(environment, rqpSql.getName(), "ROLAP sub query");
                    return false;
                }
                if (relSubquerySourceName.equals(V5Query.RelationalSubquerySource.REL_DECOMPOSITION_FROM_OLAP.getName())) {
                    this.addQRMTraceLog(environment, rqpSql.getName(), "sub query decomposed from OLAP");
                    return false;
                }
            }
        }
        Governors.LocalCachePolicy localCachePolicy = RQPUtilities.getLocalCachePolicyFromGovernors(environment, node);
        if (!this.queryReuseEnabled(environment, node.getGovernors(), localCachePolicy, node)) {
            return false;
        }
        boolean passedPolicyRules = false;
        switch (localCachePolicy) {
            case QUERY_REFERENCED_BY_LAYOUT: {
                if (rangeVar != null) break;
                passedPolicyRules = true;
                break;
            }
            case EXPLICITLY_PER_QUERY: {
                if (rangeVar != null && rangeVar.getPropertyValue("isQueryReusableInNestingCursors") == null) break;
                passedPolicyRules = true;
                break;
            }
            default: {
                passedPolicyRules = this.conditionForLowestSummarySubquery(node, environment, rqpSql, rangeVar);
            }
        }
        if (!passedPolicyRules) {
            return false;
        }
        if (node.hasDescendantOfType(401005, false)) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledMixedRelOLAP, this.getMainRQPQuery(rqpSql, rangeVar).getName());
            this.addQRMTraceLog(environment, this.getMainRQPQuery(rqpSql, rangeVar).getName(), "mixed relational OLAP expression");
            return false;
        }
        boolean allowReuseForParameterizedQueries = qrm.isReuseOfParameterizedQueriesAllowed();
        IXQEQueryNode[] allParams = node.getDescendantsOfType(301051, true);
        if (allParams.length > 0) {
            if (this.hasRegularParameter(allParams) && !allowReuseForParameterizedQueries) {
                this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledParameter, this.getMainRQPQuery(rqpSql, rangeVar).getName());
            }
            if (!allowReuseForParameterizedQueries || this.containsMasterDetailLinkParameter(allParams)) {
                this.addQRMTraceLogForParameter(environment, this.getMainRQPQuery(rqpSql, rangeVar).getName(), allParams);
                return false;
            }
        }
        if (rqpSql.isQueryReusable() == Boolean.FALSE) {
            this.appendReasonsWhyQueryReuseIsOFF(environment, rqpSql);
            Set udfList = (Set)rqpSql.getPropertyValue("UDFNames");
            if (udfList != null) {
                RQPQuery rqpQuery = this.getMainRQPQuery(rqpSql, rangeVar);
                this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledUDF, rqpQuery.getName());
                this.addQRMTraceLogForUDFs(environment, rqpQuery.getName(), udfList);
            }
            return false;
        }
        boolean hasNativeSQL = false;
        if (rqpSql == node) {
            nativeSQL = rqpSql.getDescendantsOfType(301013, false);
            hasNativeSQL = ((IXQEQueryNode[])nativeSQL).length > 0;
        } else {
            nativeSQL = rqpSql.getDescendantsOfTypeOrdered(301013, node);
            boolean bl = hasNativeSQL = !nativeSQL.isEmpty();
        }
        if (hasNativeSQL) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledNativeSQL, this.getMainRQPQuery(rqpSql, rangeVar).getName());
            this.addQRMTraceLog(environment, this.getMainRQPQuery(rqpSql, rangeVar).getName(), "native sql");
            return false;
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        RQPQuery rqpQuery = this.getMainRQPQuery(rqpSql, rangeVar);
        if (requestEnv.isGetParametersRequest() && this.isClonedQuery(rqpQuery, rqpSql)) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledGetParameters, this.getMainRQPQuery(rqpSql, rangeVar).getName());
            this.addQRMTraceLog(environment, this.getMainRQPQuery(rqpSql, rangeVar).getName(), "getParameters request");
            return false;
        }
        if (rangeVar != null && localCachePolicy == Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseEnabledLLSQ, ((RQPQuery)rangeVar.getChild(0)).getName(), ((RQPQuery)rqpSql.getMainRQPQuery()).getName());
        } else {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseEnabled, this.getMainRQPQuery(rqpSql, rangeVar).getName());
        }
        return true;
    }

    private boolean isClonedQuery(RQPQuery rqpQuery, RQPSql rqpSql) {
        RSAPIDataset dataset = (RSAPIDataset)rqpSql.getAncestorOfType(401005);
        if (dataset == null) {
            return false;
        }
        String qrdRefQueryName = dataset.getRefQueryName();
        if (!qrdRefQueryName.contains("_ForQrd_")) {
            return false;
        }
        String qrdName = dataset.getName();
        V5Query v5Query = (V5Query)rqpQuery.getRootRQPQuery().getPropertyValue("v5ref");
        if (v5Query == null) {
            return false;
        }
        String v5QueryName = (String)v5Query.getPropertyValue("originalQueryName");
        if (v5QueryName == null) {
            return false;
        }
        String clonedRefQueryName = v5QueryName + "_ForQrd_" + qrdName;
        return qrdRefQueryName.equals(clonedRefQueryName);
    }

    private String buildParameterList(IXQEQueryNode[] allParameters) {
        TreeSet<String> paramNames = new TreeSet<String>();
        for (IXQEQueryNode param : allParameters) {
            paramNames.add(((SQLParameter)param).getName());
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (String paramName : paramNames) {
            sb.append(paramName);
            if (i < paramNames.size()) {
                sb.append(COMMA);
            }
            ++i;
        }
        return sb.toString();
    }

    private String buildUDFList(Set<String> udfSet) {
        ArrayList<String> udfList = new ArrayList<String>(udfSet);
        Collections.sort(udfList);
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (String udfName : udfList) {
            sb.append(udfName);
            if (i < udfSet.size()) {
                sb.append(COMMA);
            }
            ++i;
        }
        return sb.toString();
    }

    private void addQRMTraceLog(PlanningEnvironment pEnvironment, String queryName, String disableReason) {
        QueryReuseManager queryReuseManager = (QueryReuseManager)((RequestEnvironment)pEnvironment.getRequestEnvironment()).getQueryReuseManager();
        if (queryReuseManager.loggingEnabled()) {
            queryReuseManager.logToXQELog(LogLevel.TRACE, REPORT + ((RequestEnvironment)pEnvironment.getRequestEnvironment()).getReportName() + QUERY + queryName + " is not reused due to " + disableReason);
        }
    }

    private void addQRMTraceLogForParameter(PlanningEnvironment pEnvironment, String queryName, IXQEQueryNode[] allParams) {
        QueryReuseManager queryReuseManager = (QueryReuseManager)((RequestEnvironment)pEnvironment.getRequestEnvironment()).getQueryReuseManager();
        if (queryReuseManager.loggingEnabled()) {
            queryReuseManager.logToXQELog(LogLevel.TRACE, REPORT + ((RequestEnvironment)pEnvironment.getRequestEnvironment()).getReportName() + QUERY + queryName + " is not reused due to parameters:" + this.buildParameterList(allParams));
        }
    }

    private void addQRMTraceLogForUDFs(PlanningEnvironment pEnvironment, String queryName, Set<String> udfNames) {
        QueryReuseManager queryReuseManager = (QueryReuseManager)((RequestEnvironment)pEnvironment.getRequestEnvironment()).getQueryReuseManager();
        if (queryReuseManager.loggingEnabled()) {
            queryReuseManager.logToXQELog(LogLevel.TRACE, REPORT + ((RequestEnvironment)pEnvironment.getRequestEnvironment()).getReportName() + QUERY + queryName + " is not reused due to UDFs:" + this.buildUDFList(udfNames));
        }
    }

    private void appendReasonsWhyQueryReuseIsOFF(PlanningEnvironment pEnvironment, RQPSql rqpSQL) {
        Set<String> reasons = rqpSQL.getQueryReuseOFFReason();
        if (((RequestEnvironment)pEnvironment.getRequestEnvironment()).getMaxSeverityLevel() >= 2 && reasons.size() > 0) {
            Object ee = pEnvironment.getExecutionEnvironment();
            for (String reason : reasons) {
                ee.addReuseNag(reason);
            }
            reasons.clear();
        }
    }

    private void appendQueryReuseMessage(PlanningEnvironment pEnvironment, IMessageKey.Param0 messageKey) {
        if (((RequestEnvironment)pEnvironment.getRequestEnvironment()).getMaxSeverityLevel() >= 2) {
            String nag = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale());
            ((ExecutionEnvironment)pEnvironment.getExecutionEnvironment()).addReuseNag(nag);
        }
    }

    private void appendQueryReuseMessage(PlanningEnvironment pEnvironment, IMessageKey.Param1 messageKey, String value1) {
        if (((RequestEnvironment)pEnvironment.getRequestEnvironment()).getMaxSeverityLevel() >= 2) {
            String nag = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), value1);
            ((ExecutionEnvironment)pEnvironment.getExecutionEnvironment()).addReuseNag(nag);
        }
    }

    private void appendQueryReuseMessage(PlanningEnvironment pEnvironment, IMessageKey.Param2 messageKey, String value1, String value2) {
        if (((RequestEnvironment)pEnvironment.getRequestEnvironment()).getMaxSeverityLevel() >= 2) {
            String nag = XQEMessages.getMessage(messageKey, XQEMessages.getCurrProductLocale(), value1, value2);
            ((ExecutionEnvironment)pEnvironment.getExecutionEnvironment()).addReuseNag(nag);
        }
    }

    private boolean conditionForLowestSummarySubquery(IXQEQueryNode node, PlanningEnvironment environment, RQPSql rqpSql, SQLRangeVar rangeVar) {
        if (rangeVar != null && !rangeVar.isCandidateForQueryReuse().booleanValue()) {
            return false;
        }
        if (this.hasNestedSubQueryCandidateForQueryReuse(node)) {
            return false;
        }
        RQPQuery rqpQuery = this.getMainRQPQuery(rqpSql, rangeVar);
        if (!this.isGroupedQuery(rqpQuery) && !this.queryReturnsOneRow(rqpQuery)) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledLLSQNonGrouped, rqpQuery.getName());
            this.addQRMTraceLog(environment, rqpQuery.getName(), "not being a grouped lowest sub query");
            return false;
        }
        if (IsQueryReusable.hasDependentV5Queries(rqpQuery)) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledLLSQReferencesOtherQuery, rqpQuery.getName());
            this.addQRMTraceLog(environment, rqpQuery.getName(), "not being a lowest sub query");
            return false;
        }
        return true;
    }

    private RQPQuery getMainRQPQuery(RQPSql rqpSql, SQLRangeVar rangeVar) {
        if (rangeVar != null) {
            return (RQPQuery)rangeVar.getChild(0);
        }
        return (RQPQuery)rqpSql.getMainRQPQuery();
    }

    private boolean queryReturnsOneRow(IXQEQueryNode rqpQuery) {
        IXQEQueryNode sql = RQPUtilities.getProjectionNode(this.getSQLRoot(rqpQuery));
        if (sql == null) {
            return false;
        }
        IXQEQueryNode projList = sql.getFirstChildByType(301030);
        for (IXQEQueryNode proj : projList.getChildren()) {
            List<IXQEQueryNode> sqlColumns = proj.getDescendantsOfTypeOrdered(301005, true);
            if (sqlColumns == null || sqlColumns.size() == 0) {
                return false;
            }
            for (IXQEQueryNode sqlColumn : sqlColumns) {
                boolean hasAncestorStdAggr = false;
                IXQEQueryNode[] ancestorAggrs = sqlColumn.getAncestorsOfType(301034);
                if (ancestorAggrs != null) {
                    for (IXQEQueryNode aggr : ancestorAggrs) {
                        if (!((SQLAggregate)aggr).isStandardAggregate()) continue;
                        hasAncestorStdAggr = true;
                        break;
                    }
                }
                if (hasAncestorStdAggr) continue;
                return false;
            }
        }
        return true;
    }

    private boolean queryReuseEnabled(PlanningEnvironment environment, Governors governors, Governors.LocalCachePolicy localCachePolicy, IXQEQueryNode node) {
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (requestEnv == null || governors == null) {
            return false;
        }
        if (!requestEnv.getQueryReuseManager().isQueryReuseEnabled()) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledConfig);
            return false;
        }
        if ((requestEnv.isValidateRequest() || requestEnv.isMixedRequest()) && requestEnv.getResponseMessageFolder().getMaxSeverityLevel() != 2) {
            this.appendQueryReuseMessage(environment, XQEMessageKeys.RUS_ReuseDisabledValidate);
            return false;
        }
        if (localCachePolicy == Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY && node.getType() == 301007) {
            return true;
        }
        if (!governors.isLocalCacheEnabled(environment).booleanValue()) {
            this.addQRMTraceLog(environment, ReuseQuery.getQueryName(node), "local cache disabled");
            return false;
        }
        return true;
    }

    private boolean hasRegularParameter(IXQEQueryNode[] allParams) {
        return allParams.length > this.getNumOfMasterDetailLinkParameters(allParams);
    }

    private boolean containsMasterDetailLinkParameter(IXQEQueryNode[] allParams) {
        return this.getNumOfMasterDetailLinkParameters(allParams) > 0;
    }

    private int getNumOfMasterDetailLinkParameters(IXQEQueryNode[] allParams) {
        int count = 0;
        for (IXQEQueryNode param : allParams) {
            SQLComparison sqlComparison;
            if (((SQLParameter)param).isMasterDetailLinkParameter()) {
                ++count;
                continue;
            }
            IXQEQueryNode parent = param.getParent();
            if (parent.getType() != 301026 || (sqlComparison = (SQLComparison)parent).getMasterDetailLinkName() == null) continue;
            ++count;
        }
        return count;
    }
}

