/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import java.util.ArrayList;
import java.util.List;

public class MoveDetailFilterToInsideOuterJoin
extends Transformation {
    public MoveDetailFilterToInsideOuterJoin() {
        this.mName = "Move a detail filter to inside an outer join.";
        this.mPassNumbers = new int[]{33};
        this.mTypes = new int[]{301011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        SQLRangeVar rightQuery = (SQLRangeVar)node.getChild(1);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLRangeVar newRangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
        newRangeVar.setName(rightQuery.getName());
        newRangeVar.setDerivedColumnList(new ArrayList<String>(rightQuery.getDerivedColumnList()));
        newRangeVar.setSubQueryType(SQLRangeVar.PropertySubqueryTypeEnum.RMSQLCALCFILTER_OR_RMMODELQUERYASVIEW);
        rightQuery.setPropertyValue("refSQLRangeVarHavingMovedDetailFilter", newRangeVar);
        node.exchangeChildNode(rightQuery, newRangeVar);
        RQPQuery rqpQuery = (RQPQuery)nodeFactory.createNode(801017);
        rqpQuery.setName(rightQuery.getName());
        newRangeVar.addChild(rqpQuery);
        RQPProjectionList projList = (RQPProjectionList)nodeFactory.createNode(801016);
        rqpQuery.addChild(projList);
        List<String> columnNames = rightQuery.getDerivedColumnList();
        for (String columnName : columnNames) {
            SQLAlias sqlAlias = (SQLAlias)nodeFactory.createNode(301028);
            projList.addChild(sqlAlias);
            sqlAlias.setName(columnName);
            SQLColumn sqlColumn = (SQLColumn)nodeFactory.createNode(301005);
            sqlAlias.addChild(sqlColumn);
            sqlColumn.setName(columnName);
            sqlColumn.setTableName(rightQuery.getName());
        }
        RQPDetailFilterList filterList = (RQPDetailFilterList)rqpQuery.getOrCreateList(environment, 801011);
        RQPQuery outerQuery = (RQPQuery)node.getAncestorOfType(801017);
        RQPDetailFilterList outerDetailFilters = outerQuery.getDetailFilterList();
        for (int i = 0; i < outerDetailFilters.getNumberChildren(); ++i) {
            V5DetailFilter filter = (V5DetailFilter)outerDetailFilters.getChild(i);
            String previousRMQuery = (String)filter.getPropertyValue("RMQueryOperationName");
            if (null == previousRMQuery || !previousRMQuery.equals(rightQuery.getName())) continue;
            filter.move(filterList);
        }
        if (0 == outerDetailFilters.getNumberChildren()) {
            outerDetailFilters.detach();
        }
        SQLFromClause sqlFromClause = (SQLFromClause)nodeFactory.createNode(301043);
        rqpQuery.addChild(sqlFromClause);
        sqlFromClause.addChild(rightQuery);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        if (SQLJoin.SubType.LEFT_OUTER != ((SQLJoin)node).getJoinType()) {
            return status;
        }
        if (301007 != node.getChild(1).getType()) {
            return status;
        }
        RQPQuery outerQuery = (RQPQuery)node.getAncestorOfType(801017);
        if (null == outerQuery) {
            return status;
        }
        RQPDetailFilterList detailFilters = outerQuery.getDetailFilterList();
        if (null == detailFilters || 0 == detailFilters.getNumberChildren()) {
            return status;
        }
        SQLRangeVar rightQuery = (SQLRangeVar)node.getChild(1);
        for (int i = 0; i < detailFilters.getNumberChildren(); ++i) {
            V5DetailFilter filter;
            String previousRMQuery;
            if (101008 != detailFilters.getChild(i).getType() || null == (previousRMQuery = (String)(filter = (V5DetailFilter)detailFilters.getChild(i)).getPropertyValue("RMQueryOperationName")) || !previousRMQuery.equals(rightQuery.getName())) continue;
            status = true;
            break;
        }
        return status;
    }
}

