/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.List;

public class ReplaceDataItemSelfRefInSortWithSQLColumnAlias
extends RQPTransformation {
    public ReplaceDataItemSelfRefInSortWithSQLColumnAlias() {
        this.mName = "Replace RQPDataItemSelfRef in RQPSort with SQLColum Alias";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{801010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String columnName;
        RQPDataItemSelfRef dataItemSelfRef = (RQPDataItemSelfRef)node;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPDataItem projItem = rqpQuery.findProjection(dataItemSelfRef.getName());
        if (null == projItem) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "ReplaceDataItemSelfRefInSortWithSQLColumnAlias requires projItem");
        }
        if (projItem.getParent().getType() == 301028) {
            SQLAlias alias = (SQLAlias)projItem.getParent();
            columnName = alias.getName();
        } else {
            columnName = dataItemSelfRef.getName();
        }
        SQLColumn sqlCol = (SQLColumn)environment.getNodeFactory().createNode(301005);
        sqlCol.setName(columnName);
        V5QuerySet querySet = (V5QuerySet)rqpQuery.getAncestorOfType(101002);
        if (querySet.getDataSources() != null && querySet.getDataSources().size() > 1) {
            this.associateDatasource(dataItemSelfRef, sqlCol);
        }
        node.exchange(sqlCol);
    }

    private void associateDatasource(RQPDataItemSelfRef dataItemSelfRef, SQLColumn sqlCol) {
        IXQEQueryNode[] v5BoundModelIdentifiers = dataItemSelfRef.getRefProjection().getDescendantsOfType(201116, true);
        if (v5BoundModelIdentifiers.length > 0) {
            ArrayList<IModelDataSource> allds = new ArrayList<IModelDataSource>();
            for (int i = 0; i < v5BoundModelIdentifiers.length; ++i) {
                IModelDataSource ds;
                V5BoundModelIdentifier v5BoundModelIdentifier = (V5BoundModelIdentifier)v5BoundModelIdentifiers[i];
                List<IModelDataSource> datasources = v5BoundModelIdentifier.getQuerySubject().getDataSources();
                if (datasources == null || datasources.size() != 1 || !(ds = datasources.get(0)).isRelational()) continue;
                if (allds.isEmpty()) {
                    allds.add(ds);
                    continue;
                }
                if (allds.contains(ds)) continue;
                allds.add(ds);
            }
            if (allds.size() == 1) {
                sqlCol.setPropertyValue("dataSource", allds.get(0));
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPDataItemSelfRef dataItemSelfRef;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        if (node.getType() == 801010 && (dataItemSelfRef = (RQPDataItemSelfRef)node).isWithinSortScope()) {
            this.traceNodeCondition(true, "RQPDataItemSelfRef node is within RQPSort scope.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "RQPDataItemSelfRef node is NOT in RQPSort scope.", xqeTrace);
        return false;
    }
}

