/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPQueryRef;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.DisableQueryReuseForUDF;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import java.util.Set;

public class ReplaceRQPQueryRefWithQueryPlan
extends Transformation {
    public ReplaceRQPQueryRefWithQueryPlan() {
        this.mName = "Replace RQPQueryRef with query plan.";
        this.mPassNumbers = new int[]{51};
        this.mTypes = new int[]{801049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = ((RQPQueryRef)node).getReferenceOf();
        IXQEQueryNode queryPlan = v5Query.getQueryPlan();
        SQLRangeVar sqlRangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        sqlRangeVar.setName(v5Query.getV5QueryName());
        if (queryPlan.getType() == 801017) {
            Set udfNames = (Set)queryPlan.getPropertyValue("UDFNames");
            Object refByInPredicate = v5Query.getPropertyValue("refByInPredicate");
            if (udfNames == null && refByInPredicate == null) {
                sqlRangeVar.setCandidateForQueryReuse(true);
            }
            if (udfNames != null) {
                IXQEQueryNode rqpSql = node.getAncestorOfType(801041);
                if (rqpSql != null) {
                    ((RQPSql)rqpSql).setQueryReusable(false);
                    DisableQueryReuseForUDF.addUdfName(rqpSql, udfNames);
                }
            } else if (refByInPredicate != null) {
                sqlRangeVar.setCandidateForQueryReuse(false);
                sqlRangeVar.setPropertyValue("refByInPredicate", true);
            }
            Governors governors = (Governors)v5Query.getPropertyValue("governors");
            if (governors.isLocalCacheEnabled(environment).booleanValue() && governors.getLocalCachePolicy() == Governors.LocalCachePolicy.EXPLICITLY_PER_QUERY) {
                sqlRangeVar.setPropertyValue("isQueryReusableInNestingCursors", true);
            }
        }
        node.exchange(sqlRangeVar);
        if (v5Query.getCount() <= 1) {
            queryPlan.move(sqlRangeVar);
            if (queryPlan.getType() == 801017 && !RQPUtilities.isRelationalSubquery((RQPQuery)queryPlan)) {
                v5Query.detach();
            }
        } else {
            sqlRangeVar.addChild(environment.getNodeFactory().deepCopyNode(queryPlan));
            if (queryPlan.getType() == 401005 && ((RSAPIDataset)queryPlan).isNoMetadataMode()) {
                ((RSAPIDataset)sqlRangeVar.getChild(0)).setNoMetadataMode();
            }
            v5Query.decrementCount();
        }
    }

    public void removeUnusedNodes(RQPQuery rqpQuery) {
        IXQEQueryNode[] rqpQuerychildren;
        int[] types = new int[]{801046, 801042, 101049};
        for (IXQEQueryNode rqpChild : rqpQuerychildren = rqpQuery.getChildrenOfTypes(types)) {
            rqpQuery.detachChild(rqpChild);
        }
    }
}

