/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ReplaceV5BoundParameterToSQLParameter
extends RQPTransformation {
    public ReplaceV5BoundParameterToSQLParameter() {
        this.mName = "Converts V5 bound parameter node into SQL Parameter node.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{201127};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode pn;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLParameter parameterNode = (SQLParameter)nodeFactory.createNode(301051);
        parameterNode.setName(((V5BoundParameter)node).getParameterName());
        parameterNode.setModelFilterItem(((V5BoundParameter)node).getIdentifier());
        IDataType dt = ((V5BoundParameter)node).getDataType();
        if (dt.equals(StringType.DEFAULTSTRINGTYPE) && (pn = node.getParent()) != null && pn.getType() != 801008) {
            dt = DataTypeFactory.getVarcharType();
        }
        parameterNode.setDataType(dt);
        parameterNode.setMode(((V5BoundParameter)node).getMode());
        if ("INOUT".equalsIgnoreCase(((V5BoundParameter)node).getMode()) || "IN".equalsIgnoreCase(((V5BoundParameter)node).getMode())) {
            parameterNode.setInValue(((V5BoundParameter)node).getInValue());
        }
        if (node.getParent().getType() == 301061) {
            parameterNode.setUseParameterizedSQL(true);
            if (node.getPropertyValue("isStoredProcedureParam") != null) {
                parameterNode.setPropertyValue("isStoredProcedureParam", true);
            }
        }
        if (((V5BoundParameter)node).isMasterDetailParameter()) {
            parameterNode.setIsMasterDetailParameter(true);
        }
        node.exchange(parameterNode);
    }
}

