/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPBridgeTabularQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.Bridge.ApplyAggregatesAcrossBridge;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ApplySummaryFilterAcrossBridge
extends RQPTransformation {
    public ApplySummaryFilterAcrossBridge() {
        this.mName = "Apply Summary Filter Across Bridge";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{101011};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5SummaryFilter summaryFilter = (V5SummaryFilter)node;
        RQPQuery outerQuery = RQPNode.getRQPQuery(summaryFilter);
        RQPQuery filterQuery = (RQPQuery)outerQuery.getSubqueryList().getChild(0);
        RQPBridgeTabularQuery bridgeTabularQuery = filterQuery.getDefaultBridgeTabularQuery();
        if (ApplyAggregatesAcrossBridge.expressionUsesMultipleShores(bridgeTabularQuery, summaryFilter, true)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeMultiShoreSummaryFilter, outerQuery.getName(), summaryFilter.getPropertyValue("originalExpression").toString());
        }
        Set<String> scope = this.generateFilterScope(environment, summaryFilter, outerQuery);
        boolean forReportScope = summaryFilter.getFirstChildByType(101012) == null && summaryFilter.getFirstDescendantOfTypeOrdered(201037, false) == null && summaryFilter.getPropertyValue("convertedFromDetail") != Boolean.TRUE;
        List<IXQEQueryNode> refs = summaryFilter.getDescendantsOfTypeOrdered(801009, false);
        for (IXQEQueryNode ref : refs) {
            if (ref.getParent().getType() == 201037) {
                ref.getParent().detach();
                continue;
            }
            RQPDataItemRef dataItemRef = (RQPDataItemRef)ref;
            RQPDataItem referencedItem = bridgeTabularQuery.getRQPDataItemByName(dataItemRef.getName());
            int aggregateType = ApplyAggregatesAcrossBridge.getDataItemAggregateSubtype(referencedItem);
            if (dataItemRef.getParent().getType() == 201031) {
                V5AggregateFunction aggregateFunction = (V5AggregateFunction)dataItemRef.getParent();
                aggregateType = aggregateFunction.getSubType();
                IXQEQueryNode parent = dataItemRef.getParent().getParent();
                parent.exchangeChildNode(dataItemRef.getParent(), dataItemRef, false);
            }
            if (referencedItem.isGroupingItem()) {
                RQPDataItemRef tabularItemRef = RQPDataItemRef.create(environment, bridgeTabularQuery.getName(), referencedItem.getName());
                RQPDataItem item = filterQuery.getRQPDataItem(environment, (IXQEQueryNode)tabularItemRef, referencedItem);
                dataItemRef.setName(item.getName());
                dataItemRef.setQueryName(filterQuery.getName());
                continue;
            }
            RQPDataItem item = this.processNonGroupingItem(environment, filterQuery, bridgeTabularQuery, referencedItem, scope, forReportScope, aggregateType);
            dataItemRef.setName(item.getName());
            dataItemRef.setQueryName(filterQuery.getName());
        }
        IXQEQueryNode detailFilter = environment.getNodeFactory().createNode(101008);
        IXQEQueryNode filterExpression = summaryFilter.getChild(0);
        filterExpression.move(detailFilter);
        outerQuery.addToDetailFilterList(environment, detailFilter);
        summaryFilter.detach();
    }

    private Set<String> generateFilterScope(PlanningEnvironment environment, V5SummaryFilter summaryFilter, RQPQuery outerQuery) {
        LinkedHashSet<String> scope = new LinkedHashSet<String>();
        IXQEQueryNode[] levels = summaryFilter.getChildrenOfTypeOrdered(101012);
        if (levels.length > 0) {
            for (IXQEQueryNode level : levels) {
                V5SummaryFilterLevel filterLevel = (V5SummaryFilterLevel)level;
                scope.add(filterLevel.getRefDataItem());
            }
        } else {
            List<IXQEQueryNode> breakClauses = summaryFilter.getDescendantsOfTypeOrdered(201037, false);
            if (breakClauses.size() > 0) {
                for (IXQEQueryNode breakClause : breakClauses) {
                    RQPDataItemRef itemRef = (RQPDataItemRef)breakClause.getChild(0);
                    scope.add(itemRef.getName());
                }
            } else {
                for (IXQEQueryNode item : outerQuery.getProjectionList().getChildren()) {
                    RQPDataItem dataItem = (RQPDataItem)item;
                    if (!dataItem.isGroupingItem()) continue;
                    IXQEQueryNode expression = dataItem.getExpression();
                    scope.add(((RQPDataItemRef)expression).getName());
                }
            }
        }
        return scope;
    }

    private RQPDataItem processNonGroupingItem(PlanningEnvironment environment, RQPQuery filterQuery, RQPBridgeTabularQuery bridgeTabularQuery, RQPDataItem referencedItem, Set<String> scope, boolean forReportScope, int aggregateType) {
        List<IXQEQueryNode> rowNumberScope = this.getRowNumberScope(environment, bridgeTabularQuery, scope, referencedItem);
        RQPDataItem tabularItem = bridgeTabularQuery.generateRowNumber(environment, referencedItem, rowNumberScope, false);
        RQPDataItemRef tabularItemRef = RQPDataItemRef.create(environment, bridgeTabularQuery.getName(), tabularItem.getName());
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
        aggr.setSubType(aggregateType);
        aggr.addChild(tabularItemRef);
        V5AggregateBreakClause breakClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        aggr.addChild(breakClause);
        if (!forReportScope) {
            List<IXQEQueryNode> aggregateScope = this.getScope(environment, filterQuery, scope);
            for (IXQEQueryNode scopeItem : aggregateScope) {
                breakClause.addChild(scopeItem);
            }
        }
        return filterQuery.getRQPDataItem(environment, (IXQEQueryNode)aggr, referencedItem);
    }

    private List<IXQEQueryNode> getRowNumberScope(PlanningEnvironment environment, RQPQuery query, Set<String> scopeNames, RQPDataItem item) {
        LinkedHashSet<String> rowNumberScopeNames = new LinkedHashSet<String>(scopeNames);
        IXQEQueryNode projectionList = item.getParent();
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            RQPDataItem dataItem = (RQPDataItem)projection;
            if (!dataItem.isBridgeKey() || !item.getBridgeStream().equals(dataItem.getBridgeStream())) continue;
            rowNumberScopeNames.add(dataItem.getName());
        }
        return this.getScope(environment, query, rowNumberScopeNames);
    }

    private List<IXQEQueryNode> getScope(PlanningEnvironment environment, RQPQuery query, Set<String> scopeNames) {
        ArrayList<IXQEQueryNode> newScope = new ArrayList<IXQEQueryNode>();
        for (String name : scopeNames) {
            RQPDataItem scopeItem = query.getRQPDataItemByName(name);
            RQPDataItemRef expression = (RQPDataItemRef)scopeItem.getExpression();
            RQPDataItem newDataItem = RQPDataItem.create(environment, name);
            newDataItem.addChild(environment.getNodeFactory().deepCopyNode(expression));
            newScope.add(newDataItem);
        }
        return newScope;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        RQPQuery query = RQPNode.getRQPQuery(node);
        if (query.getType() != 801051) {
            this.traceNodeCondition(false, "Filter not found on a bridge tabular query.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Filter found on a bridge tabular query.", trace);
        return true;
    }
}

