/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.transformation.v5tocogsql.PrePlanV5QueryToCogSQLQueryTransformationLibrary;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CheckUnresolvedPrompts
extends RQPTransformation {
    public CheckUnresolvedPrompts() {
        this.mName = "Check for unresolved prompts.";
        this.mPassNumbers = new int[]{108};
        this.mTypes = new int[]{801041};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        throw new UnresolvedParameterException(reqEnv, null, reqEnv.getRequestParameters().getUnresolvedParameters());
    }

    boolean isCalledFromCommandBlocksAndUnresolvedParametersHaveDefaultValue(Parameters unresolvedParameters, RequestEnvironment reqEnv) {
        if (!reqEnv.getMacroInCommandBlocks()) {
            return false;
        }
        boolean bHasDefaultValue = false;
        for (Parameter p : unresolvedParameters.values()) {
            if (p.getCapabilities().isOptional() && !p.isExplicitValueRequired()) {
                bHasDefaultValue = true;
                continue;
            }
            bHasDefaultValue = false;
            break;
        }
        return bHasDefaultValue;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode rootNode;
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if ("validateAll".equals(requestEnv.getOperationName())) {
            return false;
        }
        Parameters parameters = requestEnv.getRequestParameters();
        if (requestEnv.getResolveConnection()) {
            return false;
        }
        boolean isPrePlan = this.getTransformationLibrary() instanceof PrePlanV5QueryToCogSQLQueryTransformationLibrary;
        if (!isPrePlan && (rootNode = environment.getRoot()).getType() == 101002) {
            IXQEQueryNode[] v5Queries;
            for (IXQEQueryNode q : v5Queries = rootNode.getChildrenOfType(101006)) {
                V5Query v5Query = (V5Query)q;
                if (!v5Query.isDMR()) continue;
                return false;
            }
        }
        if (node.getGovernors().getNoDataMode().booleanValue()) {
            return false;
        }
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (querySet != null && querySet.getIsPromptHandlingNoFault()) {
            return false;
        }
        Parameters unresolvedParameters = parameters.getUnresolvedParameters();
        if (!unresolvedParameters.isEmpty()) {
            return !this.isCalledFromCommandBlocksAndUnresolvedParametersHaveDefaultValue(unresolvedParameters, requestEnv);
        }
        return requestEnv.isGetParametersRequest();
    }
}

