/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ConvertNestedGenericFunctionToStdAggregate
extends RQPTransformation {
    public ConvertNestedGenericFunctionToStdAggregate() {
        this.mName = "Convert max or min function into a standard aggregate";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{201042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5GenericFunction funcToReplace = (V5GenericFunction)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5ValueSummaryFunction funcToKeep = (V5ValueSummaryFunction)nodeFactory.createNode(201031);
        if (funcToReplace.getName().equalsIgnoreCase(SQLAggregate.SubType.MAX.toString())) {
            funcToKeep.setSubType(4);
        } else {
            funcToKeep.setSubType(6);
        }
        node.exchange(funcToKeep, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        String fnName = ((V5GenericFunction)node).getName();
        if (!fnName.equalsIgnoreCase(SQLAggregate.SubType.MAX.toString()) && !fnName.equalsIgnoreCase(SQLAggregate.SubType.MIN.toString())) {
            return false;
        }
        return ConvertNestedGenericFunctionToStdAggregate.isNestedInStdAggregate(node);
    }

    private static boolean isNestedInStdAggregate(IXQEQueryNode node) {
        boolean isNested = false;
        IXQEQueryNode parent = node.getParent();
        while (parent.getType() != 801008) {
            if (parent.getType() == 201031) {
                isNested = true;
                break;
            }
            parent = parent.getParent();
        }
        return isNested;
    }
}

