/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunctionSubtype;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.List;

public class CreateSubQueryForWindowAggrWithIncompatibleForClause
extends RQPTransformation {
    public CreateSubQueryForWindowAggrWithIncompatibleForClause() {
        this.mName = "createSubQueryForWindowAggrWithIncompatibleForClause.";
        this.mPassNumbers = new int[]{58};
        this.mTypes = new int[]{201033};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery originalQuery = RQPNode.getRQPQuery(node);
        IXQEQueryNode parent = node.getParent();
        RQPDataItem oldProjection = (RQPDataItem)node.getAncestorOfType(801008);
        List<IXQEQueryNode> aggregates = node.getChild(0).getDescendantsOfTypeOrdered(201031, true);
        ArrayList<IXQEQueryNode> forClauseOfInnerAggs = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] arrayForClause = null;
        boolean updateOuterReferences = false;
        for (IXQEQueryNode aggregate : aggregates) {
            IXQEQueryNode[] aggr = (IXQEQueryNode[])aggregate;
            V5AggregateBreakClause forClause = aggr.getForClause();
            if (forClause != null && forClause.getNumberChildren() > 0) {
                for (IXQEQueryNode forClauseItem : forClause.getChildren()) {
                    this.addForClauseItem(forClauseItem, forClauseOfInnerAggs);
                }
                arrayForClause = forClause.getChildren();
            } else if (originalQuery.isSummarizedQuery() && (arrayForClause = originalQuery.getGroupingItems()) != null && arrayForClause.length > 0) {
                for (IXQEQueryNode gc : arrayForClause) {
                    this.addForClauseItem(((RQPDataItemSelfRef)gc).getRefProjection().getExpression(), forClauseOfInnerAggs);
                }
            }
            RQPSummaryQuery newSumQueryForInnerAggr = (RQPSummaryQuery)RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(originalQuery.getRootRQPQuery(), arrayForClause, new int[]{801024}, environment);
            if (newSumQueryForInnerAggr == null || parent.getType() != 801008) {
                newSumQueryForInnerAggr = RQPSummaryQuery.createSummaryQueryWithSameScope(environment, originalQuery);
            } else {
                updateOuterReferences = true;
            }
            IXQEQueryNode aggrParent = aggr.getParent();
            int aggrPosition = aggrParent.getPositionOfChild((QTEQueryNode)aggr);
            MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, newSumQueryForInnerAggr, (IXQEQueryNode)aggr, V5AggregateFunctionSubtype.getName(aggr.getSubType()), true);
            V5ValueSummaryFunction minFunction = ExpressionAnalyzer.createV5SummaryFunctionMin(environment);
            IXQEQueryNode refDI = aggrParent.getChild(aggrPosition);
            refDI.insertParent(minFunction);
        }
        ArrayList<IXQEQueryNode> newForClause = new ArrayList<IXQEQueryNode>();
        V5AggregateBreakClause forClauseOfOuterAggr = ((V5AggregateFunction)node).getForClause();
        for (IXQEQueryNode forClauseItem : forClauseOfOuterAggr.getChildren()) {
            this.addForClauseItem(forClauseItem, newForClause);
        }
        for (IXQEQueryNode forClauseItem : forClauseOfInnerAggs) {
            this.addForClauseItem(forClauseItem, newForClause);
        }
        RQPSummaryQuery newSumQueryForOuterAggr = (RQPSummaryQuery)RQPSummaryQuery.getSummaryQueryMatchingGroupingItems(originalQuery.getRootRQPQuery(), newForClause.toArray(new IXQEQueryNode[0]), new int[]{801024}, environment);
        if (newSumQueryForOuterAggr == null) {
            newSumQueryForOuterAggr = originalQuery.getRootRQPQuery().createSummaryQuery(environment);
            for (int i = 0; i < newForClause.size(); ++i) {
                newSumQueryForOuterAggr.createGroupingColumn(environment, environment.getNodeFactory().deepCopyNode((IXQEQueryNode)newForClause.get(i)));
            }
        }
        RQPDataItem newDI = MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, newSumQueryForOuterAggr, node, V5AggregateFunctionSubtype.getName(((V5AggregateFunction)node).getSubType()), true);
        if (updateOuterReferences) {
            IXQEQueryNode[] diRefs;
            String projectionName = oldProjection.getName();
            String originalQueryName = originalQuery.getName();
            for (IXQEQueryNode diRef : diRefs = originalQuery.getParentRQPQuery().getDescendantsOfType(801009, false)) {
                RQPQuery q;
                RQPDataItemRef ref = (RQPDataItemRef)diRef;
                if (!ref.getQueryName().equals(originalQueryName) || !ref.getName().equals(projectionName) || (q = RQPNode.getRQPQuery(ref)) == newSumQueryForOuterAggr) continue;
                ref.setQueryName(newSumQueryForOuterAggr.getName());
                ref.setName(newDI.getName());
            }
            oldProjection.detach();
        }
    }

    private void addForClauseItem(IXQEQueryNode forClauseItem, List<IXQEQueryNode> forClauseOfInnerAggs) {
        for (IXQEQueryNode fc : forClauseOfInnerAggs) {
            if (!forClauseItem.isSameExpression(fc, false)) continue;
            return;
        }
        forClauseOfInnerAggs.add(forClauseItem);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The window aggregate is not under a RQP query", xqeTrace);
            return false;
        }
        RQPDataItem di = (RQPDataItem)node.getAncestorOfType(801008);
        if (di == null) {
            this.traceNodeCondition(false, "The window aggregate is not in a projection expression", xqeTrace);
            return false;
        }
        if (di.isGroupingItem()) {
            this.traceNodeCondition(false, "Cannot split when the dataItem is a grouping item.", xqeTrace);
            return false;
        }
        V5AggregateBreakClause forClause = ((V5AggregateFunction)node).getForClause();
        if (forClause == null || forClause.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "The window aggregate does not have explicit FOR clause", xqeTrace);
            return false;
        }
        if (ExpressionAnalyzer.exprOrRefExprHasAggregate(forClause)) {
            this.traceNodeCondition(false, "The FOR clause of analytic function contains another window aggregate", xqeTrace);
            return false;
        }
        IXQEQueryNode[] aggregates = node.getChild(0).getDescendantsOfType(201031, true);
        if (aggregates.length == 0) {
            this.traceNodeCondition(false, "The window aggregate does not have standard aggregates as operand", xqeTrace);
            return false;
        }
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        boolean isCompatible = true;
        if (parentQuery.isSummarizedQuery()) {
            isCompatible = this.isCompatible(forClause, parentQuery.getGroupingItems());
        } else {
            for (IXQEQueryNode aggr : aggregates) {
                V5AggregateBreakClause forClauseOfInnerAggr = ((V5AggregateFunction)aggr).getForClause();
                if (forClauseOfInnerAggr != null && this.isCompatible(forClause, forClauseOfInnerAggr.getChildren())) continue;
                isCompatible = false;
                break;
            }
        }
        if (isCompatible) {
            this.traceNodeCondition(false, "The FOR clause of window aggregate is compatible with FOR clause of inner aggregate", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "The window aggregate needs to be moved to a new subquery", xqeTrace);
        return true;
    }

    private boolean isCompatible(V5AggregateBreakClause forClause, IXQEQueryNode[] groupingItems) {
        if (groupingItems == null || groupingItems.length == 0) {
            return false;
        }
        for (IXQEQueryNode forClauseItem : forClause.getChildren()) {
            int i;
            for (i = 0; i < groupingItems.length; ++i) {
                IXQEQueryNode groupingItem = groupingItems[i];
                if (groupingItem.getType() == 801010) {
                    groupingItem = ((RQPDataItemSelfRef)groupingItem).getRefProjection().getExpression();
                }
                if (RQPSummaryQuery.isSameGroupingColumnExpression(forClauseItem, groupingItem)) break;
            }
            if (i != groupingItems.length) continue;
            return false;
        }
        return true;
    }
}

