/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFooterQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.PushMedianOverDetailValueExprToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class DistributeAggregatesInAppropriateSubQueries
extends RQPTransformation {
    private static final String PROP_BOOLEAN_IS_DISTRIBUTED = "isDistributed";
    public static final String PROP_TARGET_QUERY = "targetQuery";

    public DistributeAggregatesInAppropriateSubQueries() {
        this.mName = "Distribute aggregates in appropriate subqueries.";
        this.mPassNumbers = new int[]{56};
        this.mTypes = new int[]{801008, 101011};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] aggregateNodes;
        for (IXQEQueryNode aggregateNode : aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node)) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregateNode;
            RQPQuery parentQuery = RQPNode.getRQPQuery(aggregate);
            if (parentQuery == null || this.isInForClauseOfStdAggregateToBeDistributed(aggregate)) continue;
            if (!this.canMoveToSummaryQuery(node, aggregate)) {
                if (!aggregate.getRollupAggregateNode() || !this.ancestorCanBeMoved(aggregate)) continue;
                aggregate.setPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED, true);
                V5ValueSet valueSet = ((RQPDataItem)node).getRollupScope();
                IXQEQueryNode subQueryList = parentQuery.getParentRQPQuery().getSubqueryList();
                RQPQuery footerQuery = parentQuery.getParentRQPQuery();
                for (IXQEQueryNode subQuery : subQueryList.getChildren()) {
                    if (subQuery.getType() != 801012 || ((RQPFooterQuery)subQuery).getV5ValueSet() != valueSet) continue;
                    footerQuery = (RQPFooterQuery)subQuery;
                }
                aggregate.setPropertyValue(PROP_TARGET_QUERY, footerQuery);
                continue;
            }
            V5AggregateFunction operand = aggregate;
            if (ExpressionAnalyzer.isAnalyticFunction(aggregate)) {
                if (!this.canMoveAnalyticFunction(aggregate, node)) continue;
                operand = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(aggregate);
            }
            RQPQuery targetQuery = null;
            RQPSummaryQuery recalculatedQuery = null;
            targetQuery = node.getType() == 801008 ? RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, operand, new int[]{801024, 801012}) : DistributeAggregatesInAppropriateSubQueries.getSummaryQueryForSummaryFilterAggregate(node, aggregate, environment, operand);
            if (this.grandparentButNotParentWithSameTarget(aggregate, targetQuery.getName())) {
                recalculatedQuery = targetQuery.findSumQueryCreatedFromSplitAndWithSameScope();
                if (recalculatedQuery == null || this.grandparentButNotParentWithSameTarget(aggregate, recalculatedQuery.getName())) {
                    recalculatedQuery = RQPQuery.createSummaryQueryWithSameScope(environment, targetQuery);
                    recalculatedQuery.setPropertyValue("createdFromSplit", true);
                }
                if (targetQuery == targetQuery.getRootRQPQuery().getLowestLevelSummaryQuery()) {
                    targetQuery.setLowestLevelSummaryQueryProperty(recalculatedQuery);
                }
                aggregate.setPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED, true);
                aggregate.setPropertyValue(PROP_TARGET_QUERY, recalculatedQuery);
                continue;
            }
            aggregate.setPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED, true);
            if (targetQuery.getGroupingItems() == null && !this.canMoveAggregateLiteralToSummaryQuery(aggregate, node)) continue;
            aggregate.setPropertyValue(PROP_TARGET_QUERY, targetQuery);
        }
        for (int i = 0; i < aggregateNodes.length; ++i) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregateNodes[i];
            RQPQuery targetQuery = (RQPQuery)aggregate.getPropertyValue(PROP_TARGET_QUERY);
            if (targetQuery == null) continue;
            this.removeForClauseOfStdAggregate(aggregate);
            aggregate.removeProperty(PROP_TARGET_QUERY);
            if (null == RQPNode.getRQPQuery(aggregate) || targetQuery == RQPNode.getRQPQuery(aggregate)) continue;
            DistributeAggregatesInAppropriateSubQueries.addAggregateToSubqueryAndCreateReferenceToIt(node, targetQuery, aggregate, environment);
        }
    }

    private boolean grandparentButNotParentWithSameTarget(V5AggregateFunction aggregate, String targetQueryName) {
        IXQEQueryNode[] ancestors = aggregate.getAncestorsOfTypes(new int[]{201031, 201033, 201035});
        for (int i = 0; i < ancestors.length; ++i) {
            IXQEQueryNode ancestor = ancestors[i];
            if (i == 0) {
                if (ancestor.getPropertyValue(PROP_TARGET_QUERY) == null || !targetQueryName.equals(((RQPQuery)ancestor.getPropertyValue(PROP_TARGET_QUERY)).getName())) continue;
                return false;
            }
            if (ancestor.getPropertyValue(PROP_TARGET_QUERY) == null || !targetQueryName.equals(((RQPQuery)ancestor.getPropertyValue(PROP_TARGET_QUERY)).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean ancestorCanBeMoved(IXQEQueryNode node) {
        IXQEQueryNode[] ancestors;
        for (IXQEQueryNode ancestor : ancestors = node.getAncestorsOfTypes(new int[]{201031, 201033})) {
            if (null == ancestor.getPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED)) continue;
            return true;
        }
        return false;
    }

    private boolean isInForClauseOfStdAggregateToBeDistributed(IXQEQueryNode aggr) {
        IXQEQueryNode[] forClauseAncestors;
        for (IXQEQueryNode forClause : forClauseAncestors = aggr.getAncestorsOfType(201037)) {
            IXQEQueryNode aggregate = forClause.getParent();
            if (!ExpressionAnalyzer.isStandardAggregate(aggregate) || null == aggregate.getPropertyValue(PROP_TARGET_QUERY)) continue;
            return true;
        }
        return false;
    }

    private void removeForClauseOfStdAggregate(IXQEQueryNode aggregate) {
        V5AggregateBreakClause forClause = ((V5AggregateFunction)aggregate).getForClause();
        if (forClause != null && ExpressionAnalyzer.isStandardAggregate(aggregate)) {
            forClause.detach();
        }
    }

    public static void addAggregateToSubqueryAndCreateReferenceToIt(IXQEQueryNode node, RQPQuery subQuery, V5AggregateFunction aggregate, PlanningEnvironment environment) {
        RQPDataItem rqpDataItemInTargetSubQuery = subQuery.getRQPDataItemWithSameExpression(aggregate);
        IXQEQueryNode aggregateParent = aggregate.getParent();
        int aggregatePosition = aggregateParent.getPositionOfChild(aggregate);
        if (rqpDataItemInTargetSubQuery != null) {
            String rqpDataItemName = rqpDataItemInTargetSubQuery.getName();
            RQPDataItemRef dataItemRef = RQPDataItemRef.create(environment, subQuery.getName(), rqpDataItemName);
            aggregate.exchange(dataItemRef);
        } else {
            String rqpDataItemName = node.getType() == 801008 ? ((RQPDataItem)node).getName() : (aggregate.getSubType() == 0 ? "aggregate" : RQPNameGenerator.generateNameForNewRQPDataItem(aggregate, subQuery));
            rqpDataItemName = RQPNameGenerator.generateUniqueRQPDataItemName(subQuery, rqpDataItemName);
            rqpDataItemInTargetSubQuery = RQPDataItem.create(environment, rqpDataItemName);
            aggregate.detach();
            rqpDataItemInTargetSubQuery.addChild(aggregate);
            rqpDataItemInTargetSubQuery.copyPropertiesFrom(node);
            subQuery.addToProjectionList(environment, rqpDataItemInTargetSubQuery);
            RQPDataItemRef dataItemRef = RQPDataItemRef.create(environment, subQuery.getName(), rqpDataItemName);
            aggregateParent.addChild(dataItemRef, aggregatePosition);
            PushMedianOverDetailValueExprToTabularQuery.replaceReferencesToSubQuery(environment, subQuery, rqpDataItemInTargetSubQuery);
            Boolean b = (Boolean)node.getPropertyValue("lookup");
            if (b != null) {
                rqpDataItemInTargetSubQuery.setPropertyValue("lookup", b);
            }
        }
    }

    public static RQPQuery getSummaryQueryForSummaryFilterAggregate(IXQEQueryNode node, V5AggregateFunction aggregate, PlanningEnvironment environment, V5AggregateFunction operand) {
        RQPSummaryFilterList.AggregateScope aggScope = DistributeAggregatesInAppropriateSubQueries.determineScopeOfAggregateInFilterExpression(node, aggregate, environment, operand);
        switch (aggScope) {
            case explicitForClause: {
                return RQPSummaryQuery.getSummaryQueryMatchingAggregateForClause(environment, operand, new int[]{801024, 801012});
            }
            case summaryFilterLevelScope: {
                V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)node.getFirstChildByType(101012);
                return RQPSummaryQuery.getSummaryQueryWithScope(summaryFilterLevel.getRefDataItem(), node, environment);
            }
            case contextLevelScope: {
                String contextLevel = null;
                contextLevel = aggregate.getType() != 201031 ? (String)operand.getPropertyValue("contextLevel") : (String)aggregate.getPropertyValue("contextLevel");
                return RQPSummaryQuery.getSummaryQueryWithScope(contextLevel, node, environment);
            }
            case defaultSummaryScope: {
                return RQPNode.getRQPQuery(node).getParentRQPQuery().getDefaultSummaryQuery();
            }
            case forReportScope: {
                return RQPSummaryQuery.getOrCreateForReportSummaryQuery(environment, RQPNode.getRQPQuery(node).getParentRQPQuery());
            }
            case forTabularScope: {
                return RQPNode.getRQPQuery(node).getParentRQPQuery().getDefaultTabularQuery();
            }
        }
        return null;
    }

    public static RQPSummaryFilterList.AggregateScope determineScopeOfAggregateInFilterExpression(IXQEQueryNode node, V5AggregateFunction aggregate, PlanningEnvironment environment, V5AggregateFunction operand) {
        V5AggregateFunction outMostAggr;
        if (ExpressionAnalyzer.isStandardAggregate(aggregate)) {
            V5AggregateBreakClause forClause = operand.getForClause();
            if (forClause != null) {
                return RQPSummaryFilterList.AggregateScope.explicitForClause;
            }
            if (!RQPNode.getRQPQuery(node).getRootRQPQuery().isAutoSummaryTRUE()) {
                return DistributeAggregatesInAppropriateSubQueries.getSummaryFilterScopeForAutoFALSE(node);
            }
            if (node.getPropertyValue("convertedFromDetail") == Boolean.TRUE) {
                return RQPSummaryFilterList.AggregateScope.defaultSummaryScope;
            }
        }
        if (ExpressionAnalyzer.hasAggregateAncestor(aggregate) && !ExpressionAnalyzer.hasAnalyticAggregateAncestor(aggregate) && (outMostAggr = (V5AggregateFunction)aggregate.getAncestorOfType(201031)) != null && outMostAggr.getRollupAggregateNode()) {
            return RQPSummaryFilterList.AggregateScope.defaultSummaryScope;
        }
        if (aggregate.getPropertyValue("applyDefaultSummaryScope") == Boolean.TRUE) {
            return RQPSummaryFilterList.AggregateScope.defaultSummaryScope;
        }
        String contextLevel = (String)aggregate.getPropertyValue("contextLevel");
        if (contextLevel != null) {
            return RQPSummaryFilterList.AggregateScope.contextLevelScope;
        }
        if (aggregate.getType() != 201031) {
            return DistributeAggregatesInAppropriateSubQueries.determineScopeForAnalyticFunctions(node, aggregate, environment);
        }
        V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)node.getFirstChildByType(101012);
        if (summaryFilterLevel != null) {
            return RQPSummaryFilterList.AggregateScope.summaryFilterLevelScope;
        }
        return RQPSummaryFilterList.AggregateScope.forReportScope;
    }

    public static RQPSummaryFilterList.AggregateScope determineScopeForAnalyticFunctions(IXQEQueryNode node, V5AggregateFunction aggregate, PlanningEnvironment environment) {
        V5AggregateFunction operandAnalyticF = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(aggregate);
        if (operandAnalyticF == null) {
            return RQPSummaryFilterList.AggregateScope.forTabularScope;
        }
        return DistributeAggregatesInAppropriateSubQueries.determineScopeOfAggregateInFilterExpression(node, operandAnalyticF, environment, operandAnalyticF);
    }

    public static RQPSummaryFilterList.AggregateScope getSummaryFilterScopeForAutoFALSE(IXQEQueryNode summaryFilter) {
        V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)summaryFilter.getFirstChildByType(101012);
        if (summaryFilterLevel != null) {
            return RQPSummaryFilterList.AggregateScope.summaryFilterLevelScope;
        }
        return RQPSummaryFilterList.AggregateScope.forReportScope;
    }

    private boolean canMoveToSummaryQuery(IXQEQueryNode node, V5AggregateFunction aggregate) {
        if (node.getType() == 101011) {
            return true;
        }
        if (aggregate.getType() == 201035) {
            return false;
        }
        if (aggregate.getRollupAggregateNode()) {
            return node.getPropertyValue("containsAnalyticOrRunningMovingWithDefaultScopeAndSummaryFilter") != null;
        }
        return true;
    }

    private boolean isInDefaultSummaryQuery(RQPQuery query) {
        RQPQuery parentRQPQuery = query.getParentRQPQuery();
        RQPSummaryQuery defaultSummaryQuery = parentRQPQuery.getDefaultSummaryQuery();
        return query == defaultSummaryQuery;
    }

    private boolean canMoveAnalyticFunction(V5AggregateFunction aggregate, IXQEQueryNode node) {
        RQPQuery parentQuery = RQPQuery.getRQPQuery(aggregate);
        V5AggregateFunction operand = ExpressionAnalyzer.getStdAggregateOperandOfAnalyticFunction(aggregate);
        if (operand == null) {
            return node.getType() == 101011;
        }
        if (parentQuery.getType() == 801017) {
            return (operand.getForClause() != null || node.getType() != 801008) && !ExpressionAnalyzer.isAnalyticFunction(operand) && !RQPUtilities.containsDetailExpr(aggregate);
        }
        if (operand.getRollupAggregateNode()) {
            return false;
        }
        if (operand.getForClause() != null) {
            return true;
        }
        return !this.isInDefaultSummaryQuery(parentQuery);
    }

    private boolean canMoveAggregateLiteralToSummaryQuery(V5AggregateFunction aggregate, IXQEQueryNode node) {
        boolean canMoveAggregateLiteralToSummaryQuery = true;
        RQPQuery parentQuery = RQPNode.getRQPQuery(aggregate);
        int[] types = new int[]{801009, 201116, 201097, 201060};
        RQPProjectionList projectionList = parentQuery.getProjectionList();
        boolean bAggregateLiteral = false;
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            IXQEQueryNode[] aggregateNodes;
            RQPDataItem projection = (RQPDataItem)projectionList.getChild(i);
            IXQEQueryNode projExpr = projection.getExpression();
            for (IXQEQueryNode a : aggregateNodes = ExpressionAnalyzer.getAggregateNodes(projExpr)) {
                if (0 != a.getDescendantsOfTypes(types, false).length || a.getParent().getType() == 201031) {
                    bAggregateLiteral = false;
                    break;
                }
                bAggregateLiteral = true;
            }
            if (bAggregateLiteral) continue;
            canMoveAggregateLiteralToSummaryQuery = true;
            return canMoveAggregateLiteralToSummaryQuery;
        }
        if (bAggregateLiteral) {
            canMoveAggregateLiteralToSummaryQuery = false;
            return canMoveAggregateLiteralToSummaryQuery;
        }
        return canMoveAggregateLiteralToSummaryQuery;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] analyticsAggregates;
        XQETrace xqeTrace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The RQPDataItem node is not under a RQP query", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        if (rqpQuery.isMultiFactQuery()) {
            this.traceNodeCondition(false, "The RQPDataItem node is under a multi-fact RQP query", xqeTrace);
            return false;
        }
        if (rqpQuery.isBridgeSummaryFilterQuery()) {
            this.traceNodeCondition(false, "The RQPDataItem node is under a Bridge Summary Filter Query", xqeTrace);
            return false;
        }
        if (node.getType() == 801008 && ((RQPDataItem)node).isGroupingItem() && (analyticsAggregates = node.getDescendantsOfType(201033, true)).length == 0) {
            return false;
        }
        if (!RQPUtilities.isUnderRQPSummaryQueryOrRootQueryProjectionList(node) && node.getType() != 101011) {
            this.traceNodeCondition(false, "The RQPDataItem node is not under a RQPSummaryQuery", xqeTrace);
            return false;
        }
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "The RQPDataItem does not have expression", xqeTrace);
            return false;
        }
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node);
        for (int i = 0; i < aggregateNodes.length; ++i) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregateNodes[i];
            if (this.isInForClauseOfStdAggregateToBeDistributed(aggregate) || !this.canMoveToSummaryQuery(node, aggregate) || aggregate.getPropertyValue(PROP_BOOLEAN_IS_DISTRIBUTED) != null || aggregate.getType() == 201033 && !this.canMoveAnalyticFunction(aggregate, node)) continue;
            if (ExpressionAnalyzer.isStandardAggregate(aggregate) && aggregate.getDescendantsOfType(201037, false).length > 0) {
                this.traceNodeCondition(true, "The standard aggregate has explicit FOR clause.", xqeTrace);
                return true;
            }
            if (node.getType() == 101011) {
                return true;
            }
            RQPQuery parentQuery = RQPQuery.getRQPQuery(aggregate);
            if (parentQuery == null || parentQuery.getType() != 801017 && parentQuery.getType() != 801012) continue;
            this.traceNodeCondition(true, "The standard aggregate scope does not match with query scope.", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The RQPDataItem node's aggregate is already in the right sub-query", xqeTrace);
        return false;
    }
}

