/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPFactQuery;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeProjectionsInFactQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DistributeFiltersInFactQueries
extends RQPTransformation {
    public DistributeFiltersInFactQueries() {
        this.mName = "DistributeFiltersInFactQueries.";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{801017, 801025};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode detailFilterList;
        RQPQuery rqpQuery = node instanceof RQPTabularQuery ? ((RQPNode)node).getParentRQPQuery() : (RQPQuery)node;
        RQPFactManager factManager = rqpQuery.getFactManager();
        IXQEQueryNode summaryFilterList = node.getFirstChildByType(801023);
        if (summaryFilterList != null) {
            this.processSummaryFilters(environment, (RQPSummaryFilterList)summaryFilterList, factManager);
        }
        if ((detailFilterList = node.getFirstChildByType(801011)) != null) {
            this.processDetailFilters(environment, (RQPDetailFilterList)detailFilterList, factManager);
        }
        this.distributeEmbeddedFiltersToFactQueries(environment, factManager);
    }

    private void distributeEmbeddedFiltersToFactQueries(PlanningEnvironment environment, RQPFactManager factManager) {
        RQPQuery parentQuery = factManager.getParentRQPQuery();
        RMEmbeddedFilterList embeddedFilterList = (RMEmbeddedFilterList)parentQuery.getFirstChildByType(801036);
        if (embeddedFilterList != null) {
            List<RQPQuery> factQueries = factManager.getFactQueries();
            for (RQPQuery factQuery : factQueries) {
                if (factQuery.hasChildOfType(801036)) continue;
                factQuery.addChild(environment.getNodeFactory().deepCopyNode(embeddedFilterList));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processDetailFilters(PlanningEnvironment environment, RQPDetailFilterList detailFilterList, RQPFactManager factManager) {
        IXQEQueryNode[] iXQEQueryNodeArray = detailFilterList.getChildren();
        int n = iXQEQueryNodeArray.length;
        int n2 = 0;
        while (true) {
            block18: {
                Iterator<RQPQuery> iterator;
                IXQEQueryNode detailFilter;
                block15: {
                    block16: {
                        boolean isConvertedFromSummaryFilterTRUE;
                        List<RQPQuery> supportingFactQueries;
                        block14: {
                            IXQEQueryNode[] boundModelIDs;
                            block19: {
                                block20: {
                                    block17: {
                                        if (n2 >= n) break block16;
                                        detailFilter = iXQEQueryNodeArray[n2];
                                        supportingFactQueries = null;
                                        boolean bl = isConvertedFromSummaryFilterTRUE = detailFilter.getPropertyValue("convertedFromSummary") == Boolean.TRUE;
                                        if (!isConvertedFromSummaryFilterTRUE || factManager.isUsingBridge() || !factManager.needToStayInOuterQuery(detailFilter, RQPFactManager.Context.FILTER)) break block17;
                                        List<RQPQuery> factQueries = factManager.getSupportingQueries(detailFilter);
                                        for (RQPQuery factQuery : factQueries) {
                                            if (!this.factStreamCannotSupportFilter(factQuery, factManager)) continue;
                                            throw new XQERuntimeException(XQEMessageKeys.PLN_FilterCannotBeAppliedOnEmptyFact, ((V5DetailFilter)detailFilter).getOriginalExpression(), factManager.getFactStreamToQSPrettyPrint(factQuery.getName()));
                                        }
                                        this.splitFilterExp(environment, factManager, detailFilter);
                                        break block18;
                                    }
                                    boundModelIDs = detailFilter.getDescendantsOfType(201116, true);
                                    if (boundModelIDs.length != 0) break block19;
                                    if (!ExpressionAnalyzer.containsNonSQL99Function(detailFilter)) break block20;
                                    supportingFactQueries = factManager.getFactQueries();
                                    break block14;
                                }
                                detailFilter.setPropertyValue("stayInOuterQuery", true);
                                break block18;
                            }
                            IXQEQueryNode[] inPredicates = detailFilter.getDescendantsOfType(201011, true);
                            if (inPredicates.length > 0) {
                                IXQEQueryNode tempHolder = this.getModelIdsExcludingRightOperandOfInExpr(environment, boundModelIDs, inPredicates);
                                if (tempHolder != null) {
                                    supportingFactQueries = factManager.getSupportingQueries(tempHolder);
                                    tempHolder.detach();
                                } else {
                                    supportingFactQueries = factManager.getSupportingQueries(detailFilter);
                                }
                            } else {
                                supportingFactQueries = factManager.getSupportingQueries(detailFilter);
                            }
                        }
                        if (supportingFactQueries.size() != 0) {
                            iterator = supportingFactQueries.iterator();
                            break block15;
                        } else {
                            if (!factManager.isUsingBridge()) {
                                throw new XQERuntimeException(XQEMessageKeys.PLN_FilterCannotBeApplied, ((V5DetailFilter)detailFilter).getOriginalExpression(), factManager.getFactStreamToQSPrettyPrint());
                            }
                            if (isConvertedFromSummaryFilterTRUE) {
                                throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeMultiShoreSummaryFilter, RQPNode.getRQPQuery(factManager).getName(), ((V5DetailFilter)detailFilter).getOriginalExpression());
                            }
                            throw new XQERuntimeException(XQEMessageKeys.PLN_NonSupportedBridgeMultiShoreDetailFilter, RQPNode.getRQPQuery(factManager).getName(), ((V5DetailFilter)detailFilter).getOriginalExpression());
                        }
                    }
                    if (detailFilterList.getNumberChildren() == 0) {
                        detailFilterList.detach();
                    }
                    return;
                }
                while (iterator.hasNext()) {
                    RQPQuery factQuery;
                    factQuery = iterator.next();
                    if (this.factStreamCannotSupportFilter(factQuery, factManager)) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_FilterCannotBeAppliedOnEmptyFact, ((V5DetailFilter)detailFilter).getOriginalExpression(), factManager.getFactStreamToQSPrettyPrint(factQuery.getName()));
                    }
                    V5DetailFilter clonedDetailFilter = (V5DetailFilter)environment.getNodeFactory().deepCopyNode(detailFilter);
                    List<IXQEQueryNode> filters = factQuery.getFilterOnUnProjectedItem();
                    if (filters.contains(detailFilter)) {
                        filters.remove(detailFilter);
                        filters.add(clonedDetailFilter);
                        continue;
                    }
                    factQuery.addToDetailFilterList(environment, clonedDetailFilter);
                }
                detailFilter.detach();
            }
            ++n2;
        }
    }

    private IXQEQueryNode getModelIdsExcludingRightOperandOfInExpr(PlanningEnvironment environment, IXQEQueryNode[] boundModelIDs, IXQEQueryNode[] inPredicates) {
        ArrayList<IXQEQueryNode> rightOperandIds = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode inP : inPredicates) {
            IXQEQueryNode[] boundIdsInRightOperand;
            for (IXQEQueryNode node : boundIdsInRightOperand = inP.getChild(1).getDescendantsOfType(201116, true)) {
                rightOperandIds.add(node);
            }
        }
        if (rightOperandIds.size() == 0) {
            return null;
        }
        IXQEQueryNode tempHolder = environment.getNodeFactory().createNode(201011);
        for (IXQEQueryNode id : boundModelIDs) {
            boolean found = false;
            for (IXQEQueryNode id1 : rightOperandIds) {
                if (id != id1) continue;
                found = true;
                break;
            }
            if (found) continue;
            tempHolder.addChild(environment.getNodeFactory().deepCopyNode(id));
        }
        return tempHolder;
    }

    private void processSummaryFilters(PlanningEnvironment environment, RQPSummaryFilterList summaryFilterList, RQPFactManager factManager) {
        for (IXQEQueryNode summaryFilter : summaryFilterList.getChildren()) {
            List<RQPQuery> supportingFactQueries = factManager.getSupportingQueries(summaryFilter);
            if (factManager.isUsingBridge()) {
                this.splitFilterAcrossBridge(environment, factManager, summaryFilter);
                continue;
            }
            if (factManager.needToStayInOuterQuery(summaryFilter, RQPFactManager.Context.FILTER)) {
                factManager.getRootRQPQuery().setPropertyValue("hasSummaryFilterAfterStitch", true);
                this.splitFilterExp(environment, factManager, summaryFilter);
                continue;
            }
            if (supportingFactQueries.size() == 0) {
                DistributeFiltersInFactQueries.checkForAnyForAllClause(factManager, summaryFilter, false);
                this.splitFilterExp(environment, factManager, summaryFilter);
                factManager.getRootRQPQuery().setPropertyValue("hasSummaryFilterAfterStitch", true);
                continue;
            }
            for (RQPQuery factQuery : supportingFactQueries) {
                V5SummaryFilter clonedSummaryFilter = (V5SummaryFilter)environment.getNodeFactory().deepCopyNode(summaryFilter);
                factQuery.addToSummaryFilterList(environment, clonedSummaryFilter);
            }
            summaryFilter.detach();
        }
        if (summaryFilterList.getNumberChildren() == 0) {
            summaryFilterList.detach();
        }
    }

    public static void checkForAnyForAllClause(RQPFactManager factManager, IXQEQueryNode expression, boolean contextProjection) {
        List<IXQEQueryNode> explicitForClauses = expression.getDescendantsOfTypeOrdered(201037, false);
        if (explicitForClauses.size() == 0) {
            return;
        }
        for (IXQEQueryNode explicitForClause : explicitForClauses) {
            List<IXQEQueryNode> forClauseItemsCanNotBePushed;
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)explicitForClause;
            if (forClause.getNumberChildren() == 0 || (forClauseItemsCanNotBePushed = DistributeFiltersInFactQueries.getForClauseItemsThatCanNotBePushed(factManager, forClause, contextProjection)).size() == 0) continue;
            if (forClause.getSubType() == 2) {
                DistributeFiltersInFactQueries.reduceForAnyClause(forClause, forClauseItemsCanNotBePushed);
                continue;
            }
            if (contextProjection) {
                RQPDataItem rqpDataItem = (RQPDataItem)expression;
                DistributeProjectionsInFactQueries.throwErrorIfCanNotSplitExpression(rqpDataItem, true);
                continue;
            }
            DistributeFiltersInFactQueries.throwExceptionForFilterCanNotBePushed(explicitForClause);
        }
    }

    private static void reduceForAnyClause(IXQEQueryNode forClause, List<IXQEQueryNode> forClauseItemsCanNotBePushed) {
        for (IXQEQueryNode forClauseItem : forClauseItemsCanNotBePushed) {
            forClause.detachChild(forClauseItem);
        }
    }

    private void splitFilterExp(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode expressionNode) {
        if (!expressionNode.hasDescendantOfType(201116, true)) {
            return;
        }
        for (IXQEQueryNode childExpr : expressionNode.getChildren()) {
            if (childExpr instanceof V5SummaryFilterLevel) continue;
            boolean pushedDownToFactStream = false;
            List<RQPQuery> supportingFactQueries = null;
            if (DistributeProjectionsInFactQueries.canPushDownToFactQuery(childExpr, factManager, true) && (supportingFactQueries = factManager.getSupportingQueries(childExpr)).size() > 0) {
                this.adjustScopeForSummaryFilterAggregate(environment, factManager, childExpr, true, supportingFactQueries);
                factManager.pushExpressionInQueriesAndCreateRefInOuterQuery(environment, supportingFactQueries, childExpr, "rc", false);
                pushedDownToFactStream = true;
            }
            if (pushedDownToFactStream) continue;
            this.adjustScopeForSummaryFilterAggregate(environment, factManager, childExpr, false, supportingFactQueries);
            this.splitFilterExp(environment, factManager, childExpr);
        }
    }

    private void splitFilterAcrossBridge(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode expressionNode) {
        if (!expressionNode.hasDescendantOfType(201116, true)) {
            return;
        }
        for (IXQEQueryNode childExpr : expressionNode.getChildren()) {
            if (childExpr instanceof V5SummaryFilterLevel) continue;
            boolean keepOutside = false;
            if (childExpr.getType() == 201031 && ((V5AggregateFunction)childExpr).getRollupAggregateNode()) {
                keepOutside = true;
            }
            boolean pushedDownToFactStream = false;
            List<RQPQuery> supportingFactQueries = null;
            if (!keepOutside && DistributeProjectionsInFactQueries.canPushDownToFactQuery(childExpr, factManager, true) && (supportingFactQueries = factManager.getSupportingQueries(childExpr)).size() == 1) {
                V5ValueSet valueSet = null;
                valueSet = this.getScopeForSummaryFilterAggregate(environment, factManager, childExpr, true, supportingFactQueries);
                boolean avoidDuplicate = true;
                MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, supportingFactQueries.get(0), childExpr, "sf", avoidDuplicate, valueSet);
                pushedDownToFactStream = true;
            }
            if (pushedDownToFactStream) continue;
            this.splitFilterAcrossBridge(environment, factManager, childExpr);
        }
    }

    private static void throwExceptionForFilterCanNotBePushed(IXQEQueryNode childExpr) {
        V5SummaryFilter summaryFilter = (V5SummaryFilter)childExpr.getAncestorOfType(101011);
        throw new XQERuntimeException(XQEMessageKeys.PLN_CanNotPushFilterExpressionToMultiFactQuery, summaryFilter.getOriginalExpression());
    }

    private static List<IXQEQueryNode> getForClauseItemsThatCanNotBePushed(RQPFactManager factManager, IXQEQueryNode forClause, boolean contextProjection) {
        ArrayList<IXQEQueryNode> forClauseItemsThatCanNotBePushed = new ArrayList<IXQEQueryNode>();
        V5AggregateFunction aggNode = (V5AggregateFunction)forClause.getAncestorOfTypes(new int[]{201031, 201033, 201035});
        List<RQPQuery> factQueries = factManager.getSupportingQueries(aggNode.getChild(0));
        if (factQueries.size() != 1) {
            List<RQPQuery> queries;
            if (factQueries.isEmpty() && !(queries = factManager.getSupportingQueries(forClause)).isEmpty()) {
                IXQEQueryNode[] v5Identifiers = aggNode.getChild(0).getDescendantsOfType(201116, true);
                boolean allAggregate = true;
                for (IXQEQueryNode v5Id : v5Identifiers) {
                    V5AggregateFunction aggParent = (V5AggregateFunction)v5Id.getAncestorOfTypes(new int[]{201031, 201033, 201035});
                    List<RQPQuery> queriesAgg = factManager.getSupportingQueries(aggParent);
                    if (!queriesAgg.isEmpty() && queries.containsAll(queriesAgg)) continue;
                    allAggregate = false;
                    break;
                }
                if (allAggregate) {
                    return forClauseItemsThatCanNotBePushed;
                }
            }
            StringBuilder buffer = new StringBuilder();
            aggNode.writeFormattedText(buffer);
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregateExpressionToMultiFactQuery, buffer.toString());
        }
        RQPQuery factQuerySupportingOperand = factQueries.get(0);
        if (!contextProjection && factQuerySupportingOperand.hasNoProjections()) {
            DistributeFiltersInFactQueries.throwExceptionForFilterCanNotBeAppliedOnEmptyFactStream(forClause, aggNode.getChild(0));
        }
        for (IXQEQueryNode forClauseItem : forClause.getChildren()) {
            List<RQPQuery> factQueriesSupportingForClauseItem = factManager.getSupportingQueries(forClauseItem);
            boolean found = false;
            for (RQPQuery factQuery : factQueriesSupportingForClauseItem) {
                if (factQuery != factQuerySupportingOperand) continue;
                found = true;
                break;
            }
            if (found) continue;
            forClauseItemsThatCanNotBePushed.add(forClauseItem);
        }
        return forClauseItemsThatCanNotBePushed;
    }

    private static void throwExceptionForFilterCanNotBeAppliedOnEmptyFactStream(IXQEQueryNode forClause, IXQEQueryNode operand) {
        V5SummaryFilter summaryFilter = (V5SummaryFilter)forClause.getAncestorOfType(101011);
        IXQEQueryNode[] v5Identifier = operand.getDescendantsOfType(201116, true);
        String itemName = "";
        if (v5Identifier.length > 0) {
            itemName = ((V5BoundModelIdentifier)v5Identifier[0]).getIdentifier();
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_CanNotPushFilterExpressionToEmptyFactStream, summaryFilter.getOriginalExpression(), itemName);
    }

    private void adjustScopeForSummaryFilterAggregate(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode expression, boolean pushedToFS, List<RQPQuery> supportingFactQueries) {
        if (!ExpressionAnalyzer.isAggregateFunction(expression)) {
            return;
        }
        V5AggregateFunction aggregate = (V5AggregateFunction)expression;
        RQPQuery rqpQuery = (RQPQuery)aggregate.getAncestorOfType(801017);
        V5SummaryFilter v5SummaryFilter = (V5SummaryFilter)aggregate.getAncestorOfType(101011);
        V5AggregateFunction operand = aggregate;
        if (aggregate.getType() == 201033 || aggregate.getType() == 201035) {
            return;
        }
        RQPSummaryFilterList.AggregateScope aggScope = DistributeAggregatesInAppropriateSubQueries.determineScopeOfAggregateInFilterExpression(v5SummaryFilter, aggregate, environment, operand);
        switch (aggScope) {
            case explicitForClause: {
                return;
            }
            case summaryFilterLevelScope: {
                V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)v5SummaryFilter.getFirstChildByType(101012);
                this.adjustScopeToSummaryFilterLevel(environment, pushedToFS, supportingFactQueries, aggregate, rqpQuery, summaryFilterLevel.getRefDataItem());
                break;
            }
            case contextLevelScope: {
                String contextLevel = (String)aggregate.getPropertyValue("contextLevel");
                this.adjustScopeToSummaryFilterLevel(environment, pushedToFS, supportingFactQueries, aggregate, rqpQuery, contextLevel);
                break;
            }
            case defaultSummaryScope: {
                this.adjustScopeToLowestLevel(environment, rqpQuery, aggregate, pushedToFS);
                break;
            }
            case forReportScope: {
                this.adjustScopeForReport(environment, aggregate);
            }
            default: {
                return;
            }
        }
    }

    private V5ValueSet getScopeForSummaryFilterAggregate(PlanningEnvironment environment, RQPFactManager factManager, IXQEQueryNode expression, boolean pushedToFS, List<RQPQuery> supportingFactQueries) {
        if (!ExpressionAnalyzer.isAggregateFunction(expression)) {
            return null;
        }
        V5AggregateFunction aggregate = (V5AggregateFunction)expression;
        RQPQuery rqpQuery = (RQPQuery)aggregate.getAncestorOfType(801017);
        V5SummaryFilter v5SummaryFilter = (V5SummaryFilter)aggregate.getAncestorOfType(101011);
        V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)v5SummaryFilter.getFirstChildByType(101012);
        if (summaryFilterLevel != null) {
            V5ValueSet valueSet = this.getScopeToSummaryFilterLevelInFS(rqpQuery, summaryFilterLevel.getRefDataItem());
            return valueSet;
        }
        return null;
    }

    private void adjustScopeForReport(PlanningEnvironment environment, V5AggregateFunction aggregate) {
        ArrayList<RQPDataItem> groupingItems = new ArrayList<RQPDataItem>();
        DistributeProjectionsInFactQueries.addForClause(environment, aggregate, groupingItems);
    }

    private void adjustScopeToSummaryFilterLevel(PlanningEnvironment environment, boolean pushedToFS, List<RQPQuery> supportingFactQueries, V5AggregateFunction aggregate, RQPQuery rqpQuery, String levelRef) {
        if (pushedToFS) {
            this.adjustScopeToSummaryFilterLevelInFS(environment, supportingFactQueries, aggregate, rqpQuery, levelRef);
        } else {
            this.adjustScopeToSummaryFilterLevelInOuterQuery(environment, aggregate, rqpQuery, levelRef);
        }
    }

    private void adjustScopeToSummaryFilterLevelInOuterQuery(PlanningEnvironment environment, V5AggregateFunction aggregate, RQPQuery rqpQuery, String levelRef) {
        RQPQuery rootRQPQuery = rqpQuery.getRootRQPQuery();
        List<IXQEQueryNode> v5VS = rootRQPQuery.getDescendantsOfTypeOrdered(101057, false);
        List<V5DataItem> v5GroupingItems = null;
        List<RQPDataItem> groupingItems = new ArrayList<RQPDataItem>();
        for (IXQEQueryNode v5vs : v5VS) {
            if (!levelRef.equals(((V5ValueSet)v5vs).getRefDataItemProperty())) continue;
            v5GroupingItems = ProcessDataItemRefInValueSet.getGroupingItems(v5vs, rootRQPQuery, false);
            groupingItems = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rootRQPQuery, v5GroupingItems);
            break;
        }
        DistributeProjectionsInFactQueries.addForClause(environment, aggregate, groupingItems);
    }

    private void adjustScopeToSummaryFilterLevelInFS(PlanningEnvironment environment, List<RQPQuery> supportingFactQueries, V5AggregateFunction aggregate, RQPQuery rqpQuery, String levelRef) {
        RQPQuery rootRQPQuery = rqpQuery.getRootRQPQuery();
        List<IXQEQueryNode> v5VS = rootRQPQuery.getDescendantsOfTypeOrdered(101057, false);
        List<V5DataItem> v5GroupingItems = null;
        ArrayList<RQPDataItem> groupingItems = new ArrayList<RQPDataItem>();
        String factQueryName = ((RQPFactQuery)supportingFactQueries.get(0)).getName();
        RQPFactQuery factQuery = (RQPFactQuery)rqpQuery.getSubquery(factQueryName);
        List<RQPDataItem> groupingItemsOfFactStream = factQuery.getProjectionsMarkedAsGroupingColumns();
        for (IXQEQueryNode v5vs : v5VS) {
            if (!levelRef.equals(((V5ValueSet)v5vs).getRefDataItemProperty())) continue;
            v5GroupingItems = ProcessDataItemRefInValueSet.getGroupingItems(v5vs, rootRQPQuery, false);
            List<RQPDataItem> groupingItemsOfQRD = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rootRQPQuery, v5GroupingItems);
            block1: for (RQPDataItem groupingItemQRD : groupingItemsOfQRD) {
                String nameQRD = groupingItemQRD.getName();
                for (RQPDataItem groupingItemOfFactStream : groupingItemsOfFactStream) {
                    String nameFS = groupingItemOfFactStream.getOriginalName();
                    if (!nameQRD.equals(nameFS)) continue;
                    groupingItems.add(groupingItemOfFactStream);
                    continue block1;
                }
            }
        }
        DistributeProjectionsInFactQueries.addForClause(environment, aggregate, groupingItems);
    }

    private V5ValueSet getScopeToSummaryFilterLevelInFS(RQPQuery rqpQuery, String levelRef) {
        RQPQuery rootRQPQuery = rqpQuery.getRootRQPQuery();
        List<IXQEQueryNode> v5VS = rootRQPQuery.getDescendantsOfTypeOrdered(101057, false);
        for (IXQEQueryNode v5vs : v5VS) {
            V5ValueSet valueSet = (V5ValueSet)v5vs;
            if (!levelRef.equals(valueSet.getRefDataItemProperty())) continue;
            return valueSet;
        }
        return null;
    }

    private void adjustScopeToLowestLevel(PlanningEnvironment environment, RQPQuery rqpQuery, V5AggregateFunction aggregate, boolean pushedToFS) {
        if (pushedToFS) {
            return;
        }
        List<RQPDataItem> groupingItems = rqpQuery.getProjectionsMarkedAsGroupingColumns();
        DistributeProjectionsInFactQueries.addForClause(environment, aggregate, groupingItems);
    }

    private boolean factStreamCannotSupportFilter(RQPQuery factQuery, RQPFactManager factManager) {
        return factQuery.getProjectionList().getNumberChildren() == 0 && !factManager.isUsingBridge();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        RQPQuery rqpQuery = node instanceof RQPTabularQuery ? ((RQPNode)node).getParentRQPQuery() : (RQPQuery)node;
        if (!rqpQuery.isMultiFactQuery() && !rqpQuery.isUsingBridge()) {
            this.traceNodeCondition(false, "We don't need to distribute filters as we are not in multi-fact situation.", trace);
            return false;
        }
        IXQEQueryNode[] filters = node.getChildrenOfTypes(new int[]{801011, 801023});
        if (filters.length == 0) {
            this.traceNodeCondition(false, "There is no detail or summary filter to distribute.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The filters will be distributed to the different fact queries.", trace);
        return true;
    }
}

