/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;

public class DropExplicitForClauseContainingLiteralOnly
extends RQPTransformation {
    public DropExplicitForClauseContainingLiteralOnly() {
        this.mName = "DropExplicitForClauseContainingLiteralOnly";
        this.mPassNumbers = new int[]{55};
        this.mTypes = new int[]{801008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node);
        for (int i = 0; i < aggregateNodes.length; ++i) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregateNodes[i];
            if (!this.hasOnlyLiteralGroupingItem(aggregate)) continue;
            V5AggregateBreakClause forClause = aggregate.getForClause();
            for (IXQEQueryNode child : forClause.getChildren()) {
                child.detach();
            }
        }
    }

    private boolean hasOnlyLiteralGroupingItem(IXQEQueryNode aggregate) {
        V5AggregateBreakClause forClause = ((V5AggregateFunction)aggregate).getForClause();
        if (forClause == null) {
            return false;
        }
        IXQEQueryNode[] children = forClause.getChildren();
        if (children.length == 0) {
            return false;
        }
        for (IXQEQueryNode child : children) {
            int[] types = new int[]{201018, 201019, 201017};
            IXQEQueryNode[] refs = child.getDescendantsOfTypes(types, true);
            if (refs.length != 0) {
                return false;
            }
            if (RQPUtilities.isConstantGroupingItem(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IXQEQueryNode[] aggregateNodes = ExpressionAnalyzer.getAggregateNodes(node);
        for (int i = 0; i < aggregateNodes.length; ++i) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggregateNodes[i];
            if (!this.hasOnlyLiteralGroupingItem(aggregate)) continue;
            return true;
        }
        return false;
    }
}

