/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5AggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeQRD;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.DistributeDynamicGroupingColumnAndFilterInDSQS;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathSelector;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CreateV5QueryForDynamicSQS
extends Transformation {
    public static final String PROP_GENERATE_QUERY_FOR_DYNAMIC_SQS = "generateDynamicSQSQuery";
    public static final String PROP_STITCH_QUERY = "stitchQuery";
    public static final String PROP_ROOT_DSQS_QUERY = "rootDSQSQuery";
    public static final String PROP_BOOL_POTENTIAL_DUPLICATE_COLUMN = "potentialDuplicateColumn";
    public static final String PROP_BOOL_STATIC_COLUMN_PROJECTED = "staticColumnProjectedInReport";
    public static final String PROP_BOOL_QUERY_FOR_NON_DSQS_ITEMS = "queryForNonDSQSItems";
    private static final int MAX_TRIES = 10000;
    public static final String ONE_ONE = "1:1";
    public static final String ONE_MANY = "1:n";

    public CreateV5QueryForDynamicSQS() {
        this.mName = "CreateV5QueryForDynamicSQS";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TreeSet<IQuerySubject> dynamicSQS;
        V5Query currentQuery = (V5Query)node;
        if (currentQuery.getDynamicSQS() == null && !CreateV5QueryForDynamicSQS.isStitchQuery(currentQuery)) {
            currentQuery.setPropertyValue(PROP_ROOT_DSQS_QUERY, currentQuery);
        }
        if ((dynamicSQS = currentQuery.getReferencedDynamicSQS()).size() == 1) {
            V5Query dynamicSQSQuery = this.createOneDynamicSQSQuery(environment, currentQuery, dynamicSQS.iterator().next());
            if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(currentQuery)) {
                this.createQueryForNonDSQSItems(environment, currentQuery, dynamicSQSQuery);
            }
        } else {
            this.createJoinedDynamicSQS(environment, currentQuery, dynamicSQS);
            if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(currentQuery)) {
                this.createQueryForNonDSQSItems(environment, currentQuery, currentQuery);
            }
        }
        node.setPropertyValue(PROP_GENERATE_QUERY_FOR_DYNAMIC_SQS, true);
    }

    private V5Query createOneDynamicSQSQuery(PlanningEnvironment environment, V5Query currentQuery, IQuerySubject dynamicSQS) {
        V5Query dynamicSQSQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, dynamicSQS, currentQuery);
        dynamicSQSQuery.setPropertyValue("dynamicSQSQuery", dynamicSQS);
        if (CreateV5QueryForDynamicSQS.isRootDSQSQuery(currentQuery)) {
            IXQEQueryNode[] dis;
            for (IXQEQueryNode di : dis = currentQuery.getV5Selection().getChildren()) {
                if (CreateV5QueryForDynamicSQS.isGroupingItem((V5DataItem)di)) continue;
                this.convertModelIdToQueryRefId(environment.getNodeFactory(), di, dynamicSQSQuery);
            }
        } else {
            this.convertModelIdToQueryRefId(environment.getNodeFactory(), currentQuery, dynamicSQSQuery);
        }
        if (currentQuery.getV5Source().getNumberChildren() == 0) {
            this.removeUnreferencedFacts(dynamicSQSQuery);
        }
        return dynamicSQSQuery;
    }

    private void createJoinedDynamicSQS(PlanningEnvironment environment, V5Query currentQuery, TreeSet<IQuerySubject> dynamicSQS) {
        ArrayList<IMetadata> qsToJoin = new ArrayList<IMetadata>();
        Iterator<IQuerySubject> it = dynamicSQS.iterator();
        while (it.hasNext()) {
            qsToJoin.add(it.next());
        }
        RQPJoinPathFinder joinPathFinder = new RQPJoinPathFinder(qsToJoin, currentQuery.getGovernors(), environment);
        List<List<IMetadata>> allJoinPaths = joinPathFinder.getAllJoinPaths();
        FactFinder ff = new FactFinder(environment);
        ff.addJoinPaths(allJoinPaths);
        List<IMetadata> joinPath = null;
        if (ff.isValid()) {
            TreeSet<IMetadata> factQSs = new TreeSet<IMetadata>();
            ff.getFactQuerySubjects(factQSs);
            if (allJoinPaths.size() == 1) {
                joinPath = allJoinPaths.get(0);
            } else {
                RQPJoinPathSelector joinSelector = new RQPJoinPathSelector();
                joinPath = joinSelector.selectBestJoinPath(allJoinPaths);
            }
            if (factQSs.size() > 1 && joinPath.size() >= qsToJoin.size()) {
                this.throwErrorForSQSJoinedViaDimensions(allJoinPaths, dynamicSQS);
            }
        }
        if (joinPath.size() == 1) {
            this.convertToJoinQuery(environment, currentQuery, dynamicSQS, (IRelationship)joinPath.get(0));
        } else {
            this.createStitchQueries(environment, currentQuery, dynamicSQS, joinPath);
        }
    }

    private void throwErrorForSQSJoinedViaDimensions(List<List<IMetadata>> allJoinPaths, TreeSet<IQuerySubject> dynamicSQS) {
        StringBuilder prettyPrintedDSQS = new StringBuilder();
        Iterator<IQuerySubject> it = dynamicSQS.iterator();
        for (int i = 0; i < dynamicSQS.size(); ++i) {
            prettyPrintedDSQS.append(it.next().getID());
            if (i >= dynamicSQS.size() - 1) continue;
            prettyPrintedDSQS.append(",");
        }
        String prettyPrintedJoinPath = null;
        if (allJoinPaths.size() > 0) {
            List<IMetadata> joinPath = allJoinPaths.get(0);
            TreeSet<IMetadata> joins = new TreeSet<IMetadata>();
            joins.addAll(joinPath);
            StringBuilder sb1 = new StringBuilder();
            FactFinder.dumpJoins(joins, 0, sb1, false);
            prettyPrintedJoinPath = sb1.toString();
        } else {
            prettyPrintedJoinPath = " ";
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidJoinPathBetweenDSQS, prettyPrintedJoinPath, prettyPrintedDSQS.toString());
    }

    private void convertToJoinQuery(PlanningEnvironment environment, V5Query currentQuery, TreeSet<IQuerySubject> dynamicSQS, IRelationship relationShip) {
        IQuerySubject leftSQS = null;
        IQuerySubject rightSQS = null;
        for (IQuerySubject sqs : dynamicSQS) {
            if (sqs == relationShip.getLeftRefObject()) {
                leftSQS = sqs;
                continue;
            }
            rightSQS = sqs;
        }
        V5Query leftSQSQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, leftSQS, currentQuery, false);
        V5Query rightSQSQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, rightSQS, currentQuery, false);
        V5Source source = currentQuery.getV5Source();
        source.removeProperty("model");
        CreateV5QueryForDynamicSQS.buildJoinOperation(environment, currentQuery, relationShip, leftSQSQuery.getV5QueryName(), rightSQSQuery.getV5QueryName());
        IXQEQueryNode[] dis = currentQuery.getV5Selection().getChildren();
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode di : dis) {
            V5DataItem dataItem = (V5DataItem)di;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(dataItem)) continue;
            this.convertModelIdToQueryRefId(factory, dataItem, leftSQSQuery);
            this.convertModelIdToQueryRefId(factory, dataItem, rightSQSQuery);
        }
    }

    public static String getUniqueQueryName(V5Query query) {
        V5QuerySet querySet = (V5QuerySet)query.getParent();
        String originalQueryName = query.getV5QueryName();
        StringBuilder sb = new StringBuilder(originalQueryName);
        for (int i = 1; i < 10000; ++i) {
            sb.append(i);
            if (querySet.getV5Query(sb.toString()) != null) continue;
            return sb.toString();
        }
        return null;
    }

    public static V5DataItem addDataItem(IXQENodeFactory factory, V5BoundModelIdentifier v5BoundId, V5Selection selection) {
        V5DataItem newDi = (V5DataItem)factory.createNode(101003);
        newDi.addChild(factory.deepCopyNode(v5BoundId));
        newDi.setNameProperty(v5BoundId.getColumnName());
        newDi.setAggregateProperty(CreateV5QueryForDynamicSQS.determineAggAttribute(v5BoundId));
        newDi.setIsOriginal();
        selection.addChild(newDi);
        return newDi;
    }

    private static String determineAggAttribute(V5BoundModelIdentifier v5BoundId) {
        IMetadata metadataObj = v5BoundId.getMetadata();
        if (metadataObj != null && metadataObj.getObjectType() == MetadataType.QUERY_ITEM) {
            return SummaryQuerySubjectUtilities.determineAggAttribute((IQueryItem)metadataObj);
        }
        return "automatic";
    }

    private void removeUnreferencedFacts(V5Query dynamicSQSQuery) {
        IXQEQueryNode[] children;
        V5Selection selection = dynamicSQSQuery.getV5Selection();
        for (IXQEQueryNode di : children = selection.getChildren()) {
            V5DataItem v5Di = (V5DataItem)di;
            if (v5Di.getAggregateProperty().equals("none") || v5Di.isReferenced()) continue;
            di.detach();
        }
    }

    public static boolean isStitchQuery(V5Query query) {
        return query.getPropertyValue(PROP_STITCH_QUERY) != null;
    }

    private static void addInJoinExpr(IXQENodeFactory factory, V5Query joinQuery, IXQEQueryNode leftJoinExpr, IXQEQueryNode rightJoinExpr) {
        V5JoinOperation joinOperation = (V5JoinOperation)joinQuery.getV5Source().getChild(0);
        IXQEQueryNode existingJoinExpr = null;
        if (joinOperation.getNumberChildren() > 2) {
            existingJoinExpr = joinOperation.getChild(2);
            IXQEQueryNode[] equalNodes = existingJoinExpr.getDescendantsOfType(201013, true);
            String leftJoinColName = ((V5BoundDataItemReference)leftJoinExpr).getNameParts()[1];
            String rightJoinColName = ((V5BoundDataItemReference)rightJoinExpr).getNameParts()[1];
            for (IXQEQueryNode eq : equalNodes) {
                if (((V5ComparisonExpression)eq).getSubType() != 2 || !CreateV5QueryForDynamicSQS.equivalentJoin(eq, leftJoinColName, rightJoinColName)) continue;
                return;
            }
        }
        V5ComparisonExpression equalNode = (V5ComparisonExpression)factory.createNode(201013);
        equalNode.setSubType(2);
        equalNode.addChild(leftJoinExpr);
        equalNode.addChild(rightJoinExpr);
        if (joinOperation.getNumberChildren() > 2) {
            V5LogicalExpression andNode = (V5LogicalExpression)factory.createNode(201003);
            andNode.setSubType(0);
            existingJoinExpr.insertParent(andNode);
            andNode.addChild(equalNode);
        } else {
            joinOperation.addChild(equalNode);
        }
    }

    private static boolean equivalentJoin(IXQEQueryNode existingEqualNode, String dynLeftJoinCol, String dynRightJoinCol) {
        IXQEQueryNode existingLeftExpr = existingEqualNode.getChild(0);
        IXQEQueryNode existingRightExpr = existingEqualNode.getChild(1);
        String existingLeftColumnName = null;
        String existingRightColumnName = null;
        if (existingLeftExpr.getType() == 201116) {
            existingLeftColumnName = ((V5BoundMultiPartIdentifier)existingLeftExpr).getNameParts()[2];
        }
        if (existingRightExpr.getType() == 201116) {
            existingRightColumnName = ((V5BoundMultiPartIdentifier)existingRightExpr).getNameParts()[2];
        }
        return dynLeftJoinCol.equals(existingLeftColumnName) && dynRightJoinCol.equals(existingRightColumnName) || dynRightJoinCol.equals(existingLeftColumnName) && dynLeftJoinCol.equals(existingRightColumnName);
    }

    private void createQueryForNonDSQSItems(PlanningEnvironment environment, V5Query currentQuery, V5Query dsqsQuery) {
        IXQEQueryNode[] dis;
        ArrayList<V5BoundModelIdentifier> nonDSQSItems = new ArrayList<V5BoundModelIdentifier>();
        for (IXQEQueryNode child : dis = currentQuery.getV5Selection().getChildren()) {
            IXQEQueryNode[] boundIds;
            V5DataItem di = (V5DataItem)child;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(di) || !di.getIsProjected()) continue;
            for (IXQEQueryNode id : boundIds = di.getDescendantsOfType(201116, true)) {
                if (id.getAncestorOfType(201037) != null) continue;
                nonDSQSItems.add((V5BoundModelIdentifier)id);
            }
        }
        if (nonDSQSItems.size() == 0) {
            return;
        }
        String newQueryName = CreateV5QueryForDynamicSQS.getUniqueQueryName(currentQuery);
        V5Query nonDSQSQuery = SummaryQuerySubjectUtilities.createV5Query(environment, null, currentQuery, newQueryName);
        nonDSQSQuery.setPropertyValue(PROP_BOOL_QUERY_FOR_NON_DSQS_ITEMS, true);
        nonDSQSQuery.getV5Source().resetReferencedQueries();
        V5Selection newSelection = nonDSQSQuery.getV5Selection();
        XQENodeFactory factory = environment.getNodeFactory();
        for (V5BoundModelIdentifier id : nonDSQSItems) {
            V5DataItem dataItem = CreateV5QueryForDynamicSQS.findProjection(factory, id, nonDSQSQuery);
            if (dataItem == null) {
                IXQEQueryNode parent = id.getAncestorOfType(101003);
                dataItem = (V5DataItem)factory.copyNode(parent);
                dataItem.addChild(factory.copyNode(id));
                newSelection.addChild(dataItem);
            }
            CreateV5QueryForDynamicSQS.replaceSimpleNodeWithDataItemRef(factory, id, dataItem, newQueryName);
        }
        if (currentQuery != dsqsQuery) {
            CreateV5QueryForDynamicSQS.buildJoinOperation(environment, currentQuery, null, dsqsQuery.getV5QueryName(), nonDSQSQuery.getV5QueryName());
        } else {
            V5Query stitchQuery = this.createQueryToJoinDSQSsWithNonDSQSQuery(environment, currentQuery, nonDSQSQuery);
            CreateV5QueryForDynamicSQS.buildJoinOperation(environment, stitchQuery, null, currentQuery.getV5QueryName(), nonDSQSQuery.getV5QueryName());
        }
    }

    private V5Query createQueryToJoinDSQSsWithNonDSQSQuery(PlanningEnvironment environment, V5Query currentQuery, V5Query nonDSQSQuery) {
        V5Query newQuery = SummaryQuerySubjectUtilities.createV5Query(environment, null, currentQuery, CreateV5QueryForDynamicSQS.getUniqueQueryName(currentQuery));
        String currentQueryName = currentQuery.getV5QueryName();
        currentQuery.setPropertyValue("name", newQuery.getV5QueryName());
        newQuery.setPropertyValue("name", currentQueryName);
        newQuery.setPropertyValue(PROP_ROOT_DSQS_QUERY, newQuery);
        currentQuery.setPropertyValue(PROP_ROOT_DSQS_QUERY, newQuery);
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(currentQuery);
        this.updateRootQuery(querySet, currentQuery, newQuery);
        newQuery.setPropertyValue(PROP_GENERATE_QUERY_FOR_DYNAMIC_SQS, true);
        querySet.addQueryInQueryMap(currentQueryName, currentQuery);
        querySet.addQueryInQueryMap(newQuery.getV5QueryName(), newQuery);
        if (currentQuery.getPropertyValue("referencedByRootQRD") != null) {
            newQuery.setPropertyValue("referencedByRootQRD", true);
            currentQuery.setPropertyValue(PROP_STITCH_QUERY, true);
            currentQuery.removeProperty("referencedByRootQRD");
            currentQuery.setRootQueryName(currentQueryName);
            currentQuery.initializeCount();
        } else {
            newQuery.setPropertyValue(PROP_BOOL_QUERY_FOR_NON_DSQS_ITEMS, true);
        }
        newQuery.getV5Source().resetReferencedQueries();
        V5Selection newSelection = newQuery.getV5Selection();
        XQENodeFactory factory = environment.getNodeFactory();
        String nonDSQSQueryName = nonDSQSQuery.getV5QueryName();
        currentQueryName = currentQuery.getV5QueryName();
        IXQEQueryNode[] dis = currentQuery.getV5Selection().getChildren();
        ArrayList<V5DataItem> toBeRemoved = new ArrayList<V5DataItem>();
        for (IXQEQueryNode child : dis) {
            V5DataItem di = (V5DataItem)child;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(di)) {
                newSelection.addChild(factory.deepCopyNode(di));
                toBeRemoved.add(di);
                continue;
            }
            IXQEQueryNode expr = di.getExpression(true);
            if (expr.getType() != 201060) continue;
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)expr;
            if (diRef.getNameParts()[0].equals(nonDSQSQueryName)) {
                newSelection.addChild(factory.deepCopyNode(di));
                toBeRemoved.add(di);
                continue;
            }
            V5BoundDataItemReference newRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(factory, di, currentQueryName);
            V5DataItem newDi = (V5DataItem)factory.copyNode(di);
            newDi.addChild(newRef);
            newSelection.addChild(newDi);
        }
        for (V5DataItem di : toBeRemoved) {
            di.detach();
        }
        IXQEQueryNode[] filters = currentQuery.getDescendantsOfTypes(new int[]{101008, 101011}, false);
        int nbFilters = filters.length;
        for (int i = 0; i < nbFilters; ++i) {
            newQuery.addChild(filters[i].detach());
        }
        return newQuery;
    }

    private void updateRootQuery(V5QuerySet querySet, V5Query oldRootQuery, V5Query newRootQuery) {
        for (IXQEQueryNode node : querySet.getChildren()) {
            V5Query query;
            V5Query rootQuery;
            if (node.getType() != 101006 || (rootQuery = (V5Query)(query = (V5Query)node).getPropertyValue(PROP_ROOT_DSQS_QUERY)) == null || rootQuery != oldRootQuery) continue;
            query.setPropertyValue(PROP_ROOT_DSQS_QUERY, newRootQuery);
        }
    }

    public static boolean isRootDSQSQuery(V5Query query) {
        return query == query.getPropertyValue(PROP_ROOT_DSQS_QUERY);
    }

    private void convertModelIdToQueryRefId(IXQENodeFactory factory, IXQEQueryNode startingNode, V5Query dynamicSQSQuery) {
        IXQEQueryNode[] boundIds;
        for (IXQEQueryNode b : boundIds = startingNode.getDescendantsOfType(201116, true)) {
            V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)b;
            String queryName = dynamicSQSQuery.getV5QueryName();
            V5DataItem di = CreateV5QueryForDynamicSQS.findProjection(factory, v5BoundId, dynamicSQSQuery);
            if (di == null) continue;
            CreateV5QueryForDynamicSQS.replaceSimpleNodeWithDataItemRef(factory, v5BoundId, di, queryName);
            di.setIsReferenced();
        }
    }

    public static V5DataItem findProjection(IXQENodeFactory factory, V5BoundModelIdentifier v5BoundId, V5Query subQuery) {
        Set<IQuerySubject> leafSQSs;
        V5DataItem di = null;
        if (subQuery == null) {
            return di;
        }
        IQuerySubject qs = v5BoundId.getQuerySubject();
        if (qs == subQuery.getDynamicSQS()) {
            di = CreateV5QueryForDynamicSQS.getDataItemByRefName(subQuery.getV5Selection(), v5BoundId.getNameParts()[2]);
            di.setIsReferenced();
            return di;
        }
        if (CreateV5QueryForDynamicSQS.isStitchQuery(subQuery) && (leafSQSs = CreateV5QueryForDynamicSQS.getDescendantSQSs(subQuery)).contains(qs)) {
            V5Selection selection = subQuery.getV5Selection();
            di = selection.getDataItemByExpression(v5BoundId);
            if (di == null) {
                di = CreateV5QueryForDynamicSQS.addDataItem(factory, v5BoundId, selection);
                if (v5BoundId.getAncestorOfType(101019) != null) {
                    di.setAggregateProperty("none");
                    di.setPropertyValue("static", true);
                }
            } else {
                di.setIsReferenced();
            }
        }
        return di;
    }

    public static Set<IQuerySubject> getDescendantSQSs(V5Query subQuery) {
        HashSet<IQuerySubject> descendantSQSs = new HashSet<IQuerySubject>();
        V5JoinOperation joinOperation = (V5JoinOperation)subQuery.getV5Source().getChild(0);
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(subQuery);
        for (int i = 0; i < 2; ++i) {
            V5Query operandQ = querySet.getV5Query(((V5JoinOperand)joinOperation.getChild(i)).getQueryRef());
            if (operandQ == null || operandQ.getDynamicSQS() == null) continue;
            descendantSQSs.add(operandQ.getDynamicSQS());
        }
        return descendantSQSs;
    }

    public static V5DataItem getDataItemByRefName(V5Selection selection, String columnName) {
        V5DataItem di = selection.getDataItemByRefName(columnName);
        if (di == null) {
            CreateV5QueryForDynamicSQS.throwsErrorNotFoundItemInNestedSQS((V5Query)selection.getParent(), columnName);
        }
        return di;
    }

    static boolean isStaticGroupingColumn(V5DataItem v5Di) {
        return v5Di.getPropertyValue("static") != null;
    }

    public static void throwsErrorNotFoundItemInNestedSQS(V5Query query, String columnName) {
        IQuerySubject qs = query.getDynamicSQS();
        String name = null;
        name = qs != null ? qs.getID() : query.getV5QueryName();
        String msg = "The column " + columnName + " is not found in the query subject " + name;
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, msg);
    }

    public static void replaceSimpleNodeWithDataItemRef(IXQENodeFactory factory, IXQEQueryNode nodeToBeReplaced, V5DataItem diInNestedQuery, String nestedQueryName) {
        V5BoundDataItemReference queryItemRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(factory, diInNestedQuery, nestedQueryName);
        nodeToBeReplaced.exchange(queryItemRef);
    }

    public static V5BoundDataItemReference createV5QueryRefItem(IXQENodeFactory factory, V5DataItem refDataItem, String refQueryName) {
        V5BoundDataItemReference queryItemRef = (V5BoundDataItemReference)factory.createNode(201060);
        queryItemRef.setRefDataItem(refDataItem);
        queryItemRef.setIsQueryRefItem();
        queryItemRef.setIdentifier(UniqueNameGenerator.createEscapedUniqueName(refQueryName, refDataItem.getNameProperty()));
        return queryItemRef;
    }

    private static List<V5DataItem> getGroupingColumns(V5Query query) {
        IXQEQueryNode[] dis = query.getV5Selection().getChildren();
        ArrayList<V5DataItem> gcs = new ArrayList<V5DataItem>();
        for (IXQEQueryNode di : dis) {
            if (!CreateV5QueryForDynamicSQS.isGroupingItem((V5DataItem)di)) continue;
            gcs.add((V5DataItem)di);
        }
        return gcs;
    }

    public static V5JoinOperation buildJoinOperation(PlanningEnvironment environment, V5Query currentQuery, IRelationship relationship, String leftQueryName, String rightQueryName) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5JoinOperation joinOperation = (V5JoinOperation)factory.createNode(101019);
        V5Source source = currentQuery.getV5Source();
        source.addChild(joinOperation);
        V5JoinOperand leftOperand = (V5JoinOperand)factory.createNode(101021);
        leftOperand.setPropertyValue("queryRef", leftQueryName);
        V5JoinOperand rightOperand = (V5JoinOperand)factory.createNode(101021);
        rightOperand.setPropertyValue("queryRef", rightQueryName);
        joinOperation.addChild(leftOperand);
        joinOperation.addChild(rightOperand);
        TreeSet<String> referencedQueries = new TreeSet<String>();
        referencedQueries.add(leftQueryName);
        referencedQueries.add(rightQueryName);
        source.setReferencedQueries(referencedQueries);
        if (relationship != null) {
            leftOperand.setPropertyValue("cardinality", relationship.getLeftCardinality().toString());
            rightOperand.setPropertyValue("cardinality", relationship.getRightCardinality().toString());
            IXQEQueryNode joinExpr = RQPUtilities.createV5ValueExpression(relationship, environment, null);
            joinExpr = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, joinExpr);
            joinOperation.addChild(joinExpr);
            SQLJoin.SubType joinType = DecomposeQRD.determineJoinTypeBasedOnCardinality((String)leftOperand.getPropertyValue("cardinality"), (String)rightOperand.getPropertyValue("cardinality"));
            joinOperation.setJoinType(joinType);
            joinOperation.setPropertyValue("joinFilterType", (Object)relationship.getJoinFilterType());
        } else {
            CreateV5QueryForDynamicSQS.buildJoinBasedOnSharedDynamicGroupingColumns(environment, joinOperation, leftQueryName, rightQueryName);
        }
        return joinOperation;
    }

    private static void buildJoinBasedOnSharedDynamicGroupingColumns(PlanningEnvironment environment, V5JoinOperation joinOperation, String leftQueryName, String rightQueryName) {
        V5JoinOperand leftOperand = (V5JoinOperand)joinOperation.getChild(0);
        V5JoinOperand rightOperand = (V5JoinOperand)joinOperation.getChild(1);
        leftOperand.setPropertyValue("cardinality", ONE_MANY);
        rightOperand.setPropertyValue("cardinality", ONE_ONE);
        joinOperation.setJoinType(SQLJoin.SubType.INNER);
        V5Query joinQuery = (V5Query)joinOperation.getParent().getParent();
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)environment.getRoot();
        V5Selection leftSelection = querySet.getV5Query(leftQueryName).getV5Selection();
        List<V5DataItem> rightGroupingCols = CreateV5QueryForDynamicSQS.getGroupingColumns(querySet.getV5Query(rightQueryName));
        if (rightGroupingCols.size() == 0) {
            V5LiteralValue oneValue = (V5LiteralValue)factory.createNode(201026);
            oneValue.setDataType(IntegerType.INTEGERTYPE);
            oneValue.setValue("1");
            CreateV5QueryForDynamicSQS.addInJoinExpr(factory, joinQuery, oneValue, factory.copyNode(oneValue));
        } else {
            for (V5DataItem di : rightGroupingCols) {
                V5DataItem leftDi = CreateV5QueryForDynamicSQS.getDataItemByRefName(leftSelection, di.getNameProperty());
                V5BoundDataItemReference leftRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(factory, leftDi, leftQueryName);
                V5BoundDataItemReference rightRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(factory, di, rightQueryName);
                CreateV5QueryForDynamicSQS.addInJoinExpr(factory, joinQuery, leftRef, rightRef);
            }
        }
    }

    public static boolean isGroupingItem(V5DataItem di) {
        IMetadata metadataObj;
        String aggregate = di.getAggregateProperty();
        if (aggregate != null && V5AggregateEnum.isStandardAggregate(aggregate)) {
            return false;
        }
        IXQEQueryNode expr = di.getExpression(true);
        if (expr.getType() == 201116 && (metadataObj = ((V5BoundModelIdentifier)expr).getMetadata()) != null && metadataObj.getObjectType() == MetadataType.QUERY_ITEM) {
            String usage = ((IQueryItem)metadataObj).getUsage();
            return usage.equals("identifier") || usage.equals("attribute") || usage.equals("unsupported");
        }
        return di.isGroupingItem();
    }

    private void createStitchQueries(PlanningEnvironment environment, V5Query currentQuery, TreeSet<IQuerySubject> dynamicSQS, List<IMetadata> joinPath) {
        int nbJoins = joinPath.size();
        ArrayList<V5Query> stitchQueries = new ArrayList<V5Query>();
        V5Query joinQuery = currentQuery;
        ArrayList<V5Query> dsqsQueries = new ArrayList<V5Query>();
        for (int i = nbJoins - 1; i >= 0; --i) {
            IQuerySubject rightSQS;
            IRelationship relationship = (IRelationship)joinPath.get(i);
            if (i > 0) {
                IRelationship previousJoin = (IRelationship)joinPath.get(i - 1);
                rightSQS = (IQuerySubject)relationship.getRightRefObject();
                if (rightSQS == previousJoin.getLeftRefObject() || rightSQS == previousJoin.getRightRefObject()) {
                    rightSQS = (IQuerySubject)relationship.getLeftRefObject();
                }
                V5Query rightQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, rightSQS, currentQuery, false);
                rightQuery.getV5Source().resetReferencedQueries();
                dsqsQueries.add(rightQuery);
                V5Query stitchQuery = SummaryQuerySubjectUtilities.createV5Query(environment, null, currentQuery, this.buildStitchQueryName(previousJoin, currentQuery));
                stitchQuery.setPropertyValue(PROP_STITCH_QUERY, true);
                CreateV5QueryForDynamicSQS.buildJoinOperation(environment, joinQuery, relationship, stitchQuery.getV5QueryName(), rightQuery.getV5QueryName());
                joinQuery = stitchQuery;
                stitchQueries.add(stitchQuery);
                continue;
            }
            IQuerySubject leftSQS = (IQuerySubject)relationship.getLeftRefObject();
            rightSQS = (IQuerySubject)relationship.getRightRefObject();
            V5Query leftQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, leftSQS, currentQuery, false);
            leftQuery.getV5Source().resetReferencedQueries();
            dsqsQueries.add(leftQuery);
            V5Query rightQuery = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(environment, rightSQS, currentQuery, false);
            rightQuery.getV5Source().resetReferencedQueries();
            dsqsQueries.add(rightQuery);
            CreateV5QueryForDynamicSQS.buildJoinOperation(environment, joinQuery, relationship, leftQuery.getV5QueryName(), rightQuery.getV5QueryName());
        }
        this.pushFactItemsInSQS(environment, currentQuery);
    }

    private void pushFactItemsInSQS(PlanningEnvironment environment, V5Query currentQuery) {
        List<V5Query> subQueries = DistributeDynamicGroupingColumnAndFilterInDSQS.getSubQueries(environment, currentQuery);
        if (subQueries.size() == 0) {
            return;
        }
        IXQEQueryNode[] dis = currentQuery.getV5Selection().getChildren();
        XQENodeFactory factory = environment.getNodeFactory();
        for (IXQEQueryNode di : dis) {
            V5DataItem dataItem = (V5DataItem)di;
            if (CreateV5QueryForDynamicSQS.isGroupingItem(dataItem)) continue;
            for (V5Query subQuery : subQueries) {
                this.convertModelIdToQueryRefId(factory, dataItem, subQuery);
            }
        }
        for (V5Query subQuery : subQueries) {
            this.pushFactItemsInSQS(environment, subQuery);
        }
    }

    private String buildStitchQueryName(IRelationship join, V5Query currentQuery) {
        StringBuilder sb = new StringBuilder("stq_");
        sb.append(SummaryQuerySubjectUtilities.buildQueryNameForSQS((IQuerySubject)join.getLeftRefObject(), currentQuery));
        sb.append("_");
        sb.append(SummaryQuerySubjectUtilities.buildQueryNameForSQS((IQuerySubject)join.getRightRefObject(), currentQuery));
        return sb.toString();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (node.getPropertyValue(PROP_GENERATE_QUERY_FOR_DYNAMIC_SQS) != null) {
            this.traceNodeCondition(false, "Dynamic SQS involved in this query have been generated.", xqeTrace);
            return false;
        }
        if (((V5Query)node).getReferencedDynamicSQS() == null) {
            this.traceNodeCondition(false, "This query does not reference a dynamicSQS.", xqeTrace);
            return false;
        }
        if (Boolean.TRUE != node.getPropertyValue("unwound")) {
            this.traceNodeCondition(false, "This query is not unwound yet.", xqeTrace);
            return false;
        }
        return true;
    }
}

