/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import java.util.ArrayList;
import java.util.List;

public class ExpandAutoForClauseForOlapAggregates
extends Transformation {
    public ExpandAutoForClauseForOlapAggregates() {
        this.mName = "ExpandAutoForClauseForOlapAggregates";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201033, 201035};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        List<V5DataItem> dynamicColumns = this.getDynamicGroupingItems(query);
        V5AggregateBreakClause newForClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
        for (V5DataItem col : dynamicColumns) {
            newForClause.addChild(environment.getNodeFactory().deepCopyNode(col.getExpression(true)));
        }
        node.addChild(newForClause);
    }

    private List<V5DataItem> getDynamicGroupingItems(V5Query dynamicSQSQuery) {
        IXQEQueryNode[] dataItems = dynamicSQSQuery.getV5Selection().getChildren();
        ArrayList<V5DataItem> gpItems = new ArrayList<V5DataItem>();
        for (IXQEQueryNode i : dataItems) {
            V5DataItem di = (V5DataItem)i;
            if (di.getPropertyValue("staticColumnProjectedInReport") != null) continue;
            if (CreateV5QueryForDynamicSQS.isStaticGroupingColumn(di)) {
                if (di.getPropertyValue("staticColumnSameExprAsDynamic") == null) continue;
                gpItems.add(di);
                continue;
            }
            if (!"none".equals(di.getAggregateProperty())) continue;
            gpItems.add(di);
        }
        return gpItems;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null || query.getDynamicSQS() == null) {
            this.traceNodeCondition(false, "This query is not a dynamic SQS.", xqeTrace);
            return false;
        }
        V5AggregateBreakClause forClause = ((V5AggregateFunction)node).getForClause();
        if (forClause != null) {
            this.traceNodeCondition(false, "This aggregate has explicit FOR clause.", xqeTrace);
            return false;
        }
        return true;
    }
}

